/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.precedence;

import com.tangosol.coherence.dsltools.base.BaseTokenStream;
import com.tangosol.coherence.dsltools.base.NestedBaseTokens;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class OPParser {
    OPScanner m_scanner;

    public OPParser(String sExper, TokenTable table) {
        this(new StringReader(sExper), table);
    }

    public OPParser(Reader reader, TokenTable table) {
        this.m_scanner = new OPScanner(table);
        this.m_scanner.scan(reader);
    }

    public OPParser(OPScanner scanner) {
        this.m_scanner = scanner;
        this.m_scanner.reset();
    }

    public OPScanner getScanner() {
        return this.m_scanner;
    }

    public Term parse() {
        return this.expression(0);
    }

    public Term expression(int nRightBindingPower) {
        OPScanner scanner = this.m_scanner;
        OPToken t = this.m_scanner.getCurrent();
        if (t == null) {
            return AtomicTerm.createNull();
        }
        scanner.next();
        Term left = t.nud(this);
        while ((t = scanner.getCurrent()) != null && nRightBindingPower < t.leftBindingPower()) {
            scanner.next();
            left = t.led(this, left);
        }
        return left;
    }

    public Term[] nodeList(String sEndMarker) {
        return this.nodeList(sEndMarker, false);
    }

    public Term[] nodeList(String sEndMarker, boolean fEndStreamAllowed) {
        ArrayList<Term> lst = new ArrayList<Term>();
        OPScanner scanner = this.m_scanner;
        while (!scanner.isEnd() && !scanner.matches(sEndMarker)) {
            Term t = this.expression(0);
            lst.add(t);
            if (fEndStreamAllowed && scanner.isEnd()) {
                return lst.toArray(new Term[lst.size()]);
            }
            if (scanner.matches(sEndMarker)) break;
            scanner.advance(",");
        }
        if (!scanner.matches(sEndMarker)) {
            throw new OPException("Unfullfilled expectation \"" + sEndMarker + "\" not found!");
        }
        return lst.toArray(new Term[lst.size()]);
    }

    public Term[] nodeList() {
        ArrayList<Term> lst = new ArrayList<Term>();
        OPScanner scanner = this.m_scanner;
        while (!scanner.isEnd()) {
            Term t = this.expression(0);
            lst.add(t);
            if (!scanner.isEnd() && scanner.advanceWhenMatching(",")) continue;
            break;
        }
        return lst.toArray(new Term[lst.size()]);
    }

    public Term[] readNestedCommaSeparatedList(NestedBaseTokens nest) {
        OPScanner scanner = this.m_scanner;
        ArrayList<Term> lst = new ArrayList<Term>();
        scanner.pushStream(new BaseTokenStream(nest));
        while (!scanner.isEnd()) {
            Term t = this.expression(0);
            lst.add(t);
            if (this.getScanner().isEnd()) break;
            this.getScanner().advance(",");
        }
        this.getScanner().popStream();
        return lst.toArray(new Term[lst.size()]);
    }
}

