/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.PropertyAccessor;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.ast.Assignment;
import com.tangosol.coherence.mvel.compiler.AbstractParser;
import com.tangosol.coherence.mvel.compiler.CompiledAccExpression;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class DeepAssignmentNode
extends ASTNode
implements Assignment {
    private String property;
    private char[] stmt;
    private CompiledAccExpression acc;
    private ExecutableStatement statement;

    public DeepAssignmentNode(char[] expr, int fields, int operation, String name, ParserContext pCtx) {
        this.fields |= 2 | fields;
        this.name = expr;
        if (operation != -1) {
            this.property = name;
            this.stmt = ParseTools.createShortFormOperativeAssignment(this.property, expr, operation);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int mark = ParseTools.find(expr, '=');
            if (mark != -1) {
                this.property = ParseTools.createStringTrimmed(expr, 0, mark);
                this.stmt = ParseTools.subset(expr, mark + 1);
                if ((fields & 0x10) != 0) {
                    this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
                }
            } else {
                this.property = new String(expr);
            }
        }
        if ((fields & 0x10) != 0) {
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), pCtx);
        }
    }

    public DeepAssignmentNode(char[] expr, int fields, ParserContext pCtx) {
        this(expr, fields, -1, null, pCtx);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), this.statement.getKnownEgressType(), AbstractParser.getCurrentThreadParserContext());
        }
        Object object = ctx;
        ctx = this.statement.getValue(ctx, thisValue, factory);
        this.acc.setValue(object, thisValue, factory, ctx);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object object = ctx;
        ctx = MVEL.eval(this.stmt, ctx, factory);
        PropertyAccessor.set(object, factory, this.property, ctx);
        return ctx;
    }

    public String getAbsoluteName() {
        return this.property.substring(0, this.property.indexOf(46));
    }

    public String getAssignmentVar() {
        return this.property;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public boolean isAssignment() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

