/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ArrayTools;
import com.tangosol.coherence.mvel.util.ParseTools;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] expr) {
        try {
            this.name = expr;
            this.declaringClass = Class.forName(new String(ParseTools.subset(expr, 0, ArrayTools.findLast('.', expr))), true, Thread.currentThread().getContextClassLoader());
            this.methodName = new String(ParseTools.subset(expr, ArrayTools.findLast('.', expr) + 1));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName);
            }
        }
        catch (Exception e) {
            throw new CompileException("unable to import class", e);
        }
    }

    private Method resolveMethod() {
        for (Method meth : this.declaringClass.getMethods()) {
            if (!Modifier.isStatic(meth.getModifiers()) || !this.methodName.equals(meth.getName())) continue;
            this.method = meth;
            return this.method;
        }
        return null;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.methodName, this.method == null ? (this.method = this.resolveMethod()) : this.method);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

