/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.optimizers.impl.refl.nodes;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.DataConversion;
import com.tangosol.coherence.mvel.compiler.AccessorNode;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.PropertyTools;
import java.lang.reflect.Field;

public class FieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;
    private boolean primitive;

    public FieldAccessor() {
    }

    public FieldAccessor(Field field) {
        this.field = field;
        this.primitive = this.field.getType().isPrimitive();
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(ctx), elCtx, vars);
            }
            return this.field.get(ctx);
        }
        catch (Exception e) {
            throw new CompileException("unable to access field: " + this.field.getName(), e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        if (this.nextNode != null) {
            try {
                return this.nextNode.setValue(this.field.get(ctx), elCtx, variableFactory, value == null && this.primitive ? PropertyTools.getPrimitiveInitialValue(this.field.getType()) : value);
            }
            catch (Exception e) {
                throw new CompileException("unable to access field", e);
            }
        }
        try {
            if (this.coercionRequired) {
                value = DataConversion.convert(ctx, this.field.getClass());
                this.field.set(ctx, value);
                return value;
            }
            this.field.set(ctx, value);
            return value;
        }
        catch (IllegalArgumentException e) {
            if (!this.coercionRequired) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new CompileException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new CompileException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

