/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.templates.util;

import com.tangosol.coherence.mvel.templates.TemplateError;
import com.tangosol.coherence.mvel.templates.res.Node;
import com.tangosol.coherence.mvel.templates.res.TerminalNode;
import com.tangosol.coherence.mvel.util.ParseTools;
import com.tangosol.coherence.mvel.util.StringAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class TemplateTools {
    public static Node getLastNode(Node node) {
        Node n = node;
        while (!(n.getNext() instanceof TerminalNode)) {
            n = n.getNext();
        }
        return n;
    }

    public static int captureToEOS(char[] expression, int cursor) {
        int length = expression.length;
        while (cursor != length) {
            switch (expression[cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    cursor = ParseTools.balancedCapture(expression, cursor, expression[cursor]);
                    break;
                }
                case ';': 
                case '}': {
                    return cursor;
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public static String readInFile(String file) {
        return TemplateTools.readInFile(new File(file));
    }

    public static String readInFile(File file) {
        try {
            FileChannel fc = new FileInputStream(file).getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender appender = new StringAppender();
            block3: while (true) {
                buf.rewind();
                int read = fc.read(buf);
                if (read == -1) break;
                buf.rewind();
                while (true) {
                    if (read == 0) continue block3;
                    appender.append((char)buf.get());
                    --read;
                }
                break;
            }
            fc.close();
            return appender.toString();
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + file.getName() + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + file.getName() + "' (stacktrace nested)", e);
        }
    }

    public static String readStream(InputStream instream) {
        try {
            int read;
            byte[] buf = new byte[10];
            StringAppender appender = new StringAppender();
            while ((read = instream.read(buf)) != -1) {
                for (int i = 0; i < read; ++i) {
                    appender.append((char)buf[i]);
                }
            }
            return appender.toString();
        }
        catch (NullPointerException e) {
            if (instream == null) {
                throw new TemplateError("null input stream", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including (stacktrace nested)", e);
        }
    }
}

