/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Collection;
import com.tangosol.coherence.reporter.MBeanQuery;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ObjectName;

public class DataSource {
    protected List m_listVE = new LinkedList();
    protected List m_listScalar;
    protected List m_listAgg = new LinkedList();
    protected Map m_mapExtract;
    protected Map m_mapGroup;
    protected ImmutableArrayList m_ialAgg;
    protected Map m_mapScalar;
    protected List m_listGroup = new LinkedList();
    protected boolean m_fGroupBy;
    protected Map m_mapIndex;

    public DataSource() {
        this.m_listScalar = new LinkedList();
    }

    public int addExtractor(ValueExtractor extractor) {
        int cSize = this.m_listVE.size();
        this.m_listVE.add(new Collection(extractor));
        return cSize;
    }

    public int addScalar(ValueExtractor extractor) {
        int cSize = this.m_listScalar.size();
        this.m_listScalar.add(extractor);
        return cSize;
    }

    public int addAggregator(InvocableMap.EntryAggregator aggregator) {
        if (this.m_fGroupBy) {
            int cSize = this.m_listVE.size();
            this.m_listVE.add(aggregator);
            return cSize;
        }
        int cSize = this.m_listAgg.size();
        this.m_listAgg.add(aggregator);
        return cSize;
    }

    public int addGroupBy(ValueExtractor extractor) {
        int iSize = this.m_listGroup.size();
        this.m_listGroup.add(extractor);
        return iSize;
    }

    public void execute(MBeanQuery mapMBeans, Set setMBeans) {
        if (this.m_listGroup.size() == 0) {
            this.m_listGroup.add(new IdentityExtractor());
        }
        this.m_ialAgg = this.getAggregates(mapMBeans, setMBeans, this.m_listAgg);
        this.m_mapGroup = this.getDetail(mapMBeans, setMBeans, this.m_listGroup);
        this.m_mapExtract = this.getAggregates(mapMBeans, setMBeans, this.m_listVE, this.m_listGroup);
        Set setGroups = this.m_mapExtract.keySet();
        this.m_mapScalar = this.getScalar(this.m_mapExtract, this.m_listScalar);
    }

    protected Map getScalar(Map mapResults, List listVE) {
        int cVE = listVE.size();
        int cResults = mapResults.size();
        if (cVE > 0 && cResults > 0) {
            ValueExtractor[] aVE = listVE.toArray(new ValueExtractor[cVE]);
            MultiExtractor extractor = new MultiExtractor(aVE);
            SafeHashMap mapScalars = new SafeHashMap();
            for (Object oKey : mapResults.keySet()) {
                mapScalars.put(oKey, extractor.extract(oKey));
            }
            return mapScalars;
        }
        return null;
    }

    protected Map getDetail(MBeanQuery mapMBeans, Set setMBeans, List listVE) {
        int cSize = listVE.size();
        if (cSize > 0) {
            ValueExtractor[] aVE = listVE.toArray(new ValueExtractor[cSize]);
            MultiExtractor multiExtractor = new MultiExtractor(aVE);
            return mapMBeans.invokeAll(setMBeans, new ExtractorProcessor(multiExtractor));
        }
        return null;
    }

    protected ImmutableArrayList getAggregates(MBeanQuery mapMBeans, Set setMBeans, List listAgg) {
        int cSize = listAgg.size();
        if (cSize > 0) {
            InvocableMap.EntryAggregator[] aVE = listAgg.toArray(new InvocableMap.EntryAggregator[cSize]);
            CompositeAggregator aggComp = CompositeAggregator.createInstance(aVE);
            return (ImmutableArrayList)mapMBeans.aggregate(setMBeans, (InvocableMap.EntryAggregator)aggComp);
        }
        return null;
    }

    protected Map getAggregates(MBeanQuery mapMBeans, Set setMBeans, List listAgg, List listBy) {
        int cAgg = listAgg.size();
        int cBy = listBy.size();
        if (cAgg > 0 && cBy > 0) {
            InvocableMap.EntryAggregator[] aEA = listAgg.toArray(new InvocableMap.EntryAggregator[cAgg]);
            ValueExtractor[] aVE = listBy.toArray(new ValueExtractor[cBy]);
            CompositeAggregator CA = CompositeAggregator.createInstance(aEA);
            MultiExtractor ME = new MultiExtractor(aVE);
            GroupAggregator ga = GroupAggregator.createInstance(ME, (InvocableMap.EntryAggregator)CA);
            return (Map)mapMBeans.aggregate(setMBeans, (InvocableMap.EntryAggregator)ga);
        }
        return null;
    }

    public Object getAggValue(Object oKey, int nPos) {
        if (this.m_fGroupBy) {
            return this.getValue(oKey, nPos);
        }
        return this.m_ialAgg.get(nPos);
    }

    protected ImmutableArrayList convertObjectName(ObjectName oKey) {
        int nSize = this.m_listGroup.size();
        Object[] ao = new Object[nSize];
        for (int i = 0; i < nSize; ++i) {
            ao[i] = ((ImmutableArrayList)this.m_mapGroup.get(oKey)).get(i);
        }
        return new ImmutableArrayList(ao);
    }

    protected ObjectName convertIAL(ImmutableArrayList ial) {
        Map map = this.ensureIndex();
        return (ObjectName)map.get(ial);
    }

    protected Map ensureIndex() {
        HashMap map = this.m_mapIndex;
        if (map == null) {
            map = new HashMap();
            for (Map.Entry entry : this.m_mapGroup.entrySet()) {
                map.put(entry.getValue(), entry.getKey());
            }
            this.m_mapIndex = map;
        }
        return this.m_mapIndex;
    }

    public Object getValue(Object oKey, int nPos) {
        Object oValKey = oKey instanceof ObjectName ? this.convertObjectName((ObjectName)oKey) : oKey;
        return ((ImmutableArrayList)this.m_mapExtract.get(oValKey)).get(nPos);
    }

    public Object getScalarValue(Object oKey, int nPos) {
        Object oValKey = oKey instanceof ObjectName ? this.convertObjectName((ObjectName)oKey) : oKey;
        return ((ImmutableArrayList)this.m_mapScalar.get(oValKey)).get(nPos);
    }

    public Object getGroupValue(Object oKey, int nPos) {
        return this.getAggValue(oKey, nPos);
    }

    public void setGroupBy(boolean fGroupBy) {
        this.m_fGroupBy = fGroupBy;
    }

    public boolean isGroupBy() {
        return this.m_fGroupBy;
    }

    public Set getGroupKeys() {
        TreeMap setResults = new TreeMap(new Comparator(){

            public int compare(Object o, Object o1) {
                ImmutableArrayList ial = (ImmutableArrayList)o;
                ImmutableArrayList ial1 = (ImmutableArrayList)o1;
                int cThis = ial.size();
                int cThat = ial1.size();
                int c = Math.min(cThis, cThat);
                for (int i = 0; i < c; ++i) {
                    int iResult;
                    Object oThis = ial.get(i);
                    Object oThat = ial1.get(i);
                    if (oThis == null || oThat == null) {
                        iResult = oThis == null ? (oThat == null ? 0 : -1) : 1;
                    } else if (oThis instanceof ObjectName && oThat instanceof ObjectName) {
                        String s = ((ObjectName)oThis).getKeyPropertyListString();
                        String s1 = ((ObjectName)oThat).getKeyPropertyListString();
                        iResult = s.compareTo(s1);
                    } else {
                        iResult = ((Comparable)oThis).compareTo(oThat);
                    }
                    if (iResult == 0) continue;
                    return iResult;
                }
                return cThis - cThat;
            }
        });
        Set setMBeans = this.m_mapExtract.keySet();
        Iterator iter = setMBeans.iterator();
        while (iter.hasNext()) {
            setResults.put(iter.next(), null);
        }
        return setResults.keySet();
    }

    public void postProcesS() {
        this.m_listVE.clear();
        this.m_listAgg.clear();
        this.m_listGroup.clear();
        this.m_listScalar.clear();
        if (this.m_mapExtract != null) {
            this.m_mapExtract.clear();
        }
        if (this.m_mapGroup != null) {
            this.m_mapGroup.clear();
        }
        if (this.m_mapIndex != null) {
            this.m_mapIndex.clear();
        }
        if (this.m_mapScalar != null) {
            this.m_mapScalar.clear();
        }
    }

    public static class DataSouceIndex {
        protected int m_mapID;
        protected int m_mapPos;
    }
}

