/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.ServiceConnection;
import com.tangosol.coherence.transaction.internal.TxConfigurableCacheFactory;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ConfigHelper {
    public static final String TXN_CACHE_CONFIG = "internal-txn-cache-config.xml";
    public static final String DEFAULT_TXN_SCHEME = "default-transactional-scheme";
    public static final String HIGH_UNITS = "high-units";
    public static final String[] TXN_SCHEME_CACHE_ELEMENTS = new String[]{"high-units"};
    protected XmlElement m_xmlTxnInternalScheme = null;
    protected XmlElement m_xmlTxnDefaultScheme = null;
    protected String m_sDefaultTxnService = null;
    protected static final Map<DefaultConfigurableCacheFactory, TxConfigurableCacheFactory> m_mapTxCCF = new WeakHashMap<DefaultConfigurableCacheFactory, TxConfigurableCacheFactory>();
    protected static final Map<ClassLoader, ConfigHelper> m_mapConfigHelper = new HashMap<ClassLoader, ConfigHelper>();

    protected ConfigHelper(ClassLoader loader) {
        this(DefaultConfigurableCacheFactory.loadConfig(TXN_CACHE_CONFIG, loader));
    }

    protected ConfigHelper(XmlDocument xmlInternalConfig) {
        this.loadInternalTransactionConfig(xmlInternalConfig);
    }

    protected void loadInternalTransactionConfig(XmlDocument xmlInternalConfig) {
        List listElements = xmlInternalConfig.getSafeElement("caching-schemes").getElementList();
        for (XmlElement xml : listElements) {
            String sScheme = xml.getSafeElement("scheme-name").getString();
            if (sScheme.equals("V$txn-natural-scheme")) {
                this.m_xmlTxnInternalScheme = xml;
                continue;
            }
            if (!sScheme.equals(DEFAULT_TXN_SCHEME)) continue;
            this.m_sDefaultTxnService = xml.getSafeElement("service-name").getString();
            this.m_xmlTxnDefaultScheme = xml;
        }
        if (this.m_xmlTxnInternalScheme == null || this.m_sDefaultTxnService == null || this.m_xmlTxnDefaultScheme == null) {
            throw new IllegalStateException("There was an error reading the internal transaction configuration.  The most likely cause is a cache configuration file name collision.  The user specified cache configuration file may not be named internal-txn-cache-config.xml.");
        }
    }

    protected CacheService getTransactionalService(String sServiceName, String sConfigURI, ClassLoader loader, XmlElement xmlConfig) {
        loader = Base.ensureClassLoader(loader);
        ConfigurableCacheFactory ccf = ConfigHelper.getConfigurableCacheFactory(sConfigURI, loader, xmlConfig);
        if (sServiceName == null || sServiceName.length() == 0) {
            sServiceName = this.m_sDefaultTxnService;
        }
        return (CacheService)ccf.ensureService(sServiceName);
    }

    protected XmlElement resolveTransactionalScheme(XmlElement xmlScheme) {
        int i;
        List listCustom = xmlScheme.getElementList();
        List listInternal = this.m_xmlTxnInternalScheme.getElementList();
        for (i = 0; i < listInternal.size(); ++i) {
            XmlElement xmlInternal = (XmlElement)listInternal.get(i);
            String sElementName = xmlInternal.getName();
            XmlElement xmlElement = xmlScheme.getElement(sElementName);
            if (xmlElement == null) {
                listCustom.add(xmlInternal.clone());
                continue;
            }
            if (xmlInternal.getSafeAttribute("override").getBoolean(false)) continue;
            listCustom.remove(xmlElement);
            listCustom.add(xmlInternal.clone());
        }
        for (i = 0; i < TXN_SCHEME_CACHE_ELEMENTS.length; ++i) {
            String txSchemeCacheElement = TXN_SCHEME_CACHE_ELEMENTS[i];
            listCustom.remove(xmlScheme.getElement(txSchemeCacheElement));
        }
        return xmlScheme;
    }

    public static NamedCache instantiateCache(String sCacheName, ClassLoader loader, CacheService service) {
        ServiceConnection connection = new ServiceConnection(service, loader);
        return connection.instantiateCache(sCacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackingMapManager instantiateBackingMapManager(DefaultConfigurableCacheFactory dccf, ClassLoader loader) {
        TxConfigurableCacheFactory txCCF;
        loader = Base.ensureClassLoader(loader);
        Map<DefaultConfigurableCacheFactory, TxConfigurableCacheFactory> map = m_mapTxCCF;
        synchronized (map) {
            txCCF = m_mapTxCCF.get(loader);
            if (txCCF == null) {
                txCCF = new TxConfigurableCacheFactory(dccf, loader);
                m_mapTxCCF.put(dccf, txCCF);
            }
        }
        return txCCF.instantiateManager();
    }

    public static XmlElement resolveTransactionalScheme(XmlElement xmlScheme, ClassLoader loader) {
        return ConfigHelper.ensureConfigHelper(loader).resolveTransactionalScheme(xmlScheme);
    }

    public static CacheService ensureTransactionalService(String sService, String sConfigURI, ClassLoader loader, XmlElement xmlConfig) {
        return ConfigHelper.ensureConfigHelper(loader).getTransactionalService(sService, sConfigURI, loader, xmlConfig);
    }

    private static ConfigurableCacheFactory getConfigurableCacheFactory(String sConfigURI, ClassLoader loader, XmlElement xmlConfig) {
        if (sConfigURI == null) {
            if (xmlConfig != null) {
                CacheFactory.getCacheFactoryBuilder().setCacheConfiguration(loader, xmlConfig);
            }
            return CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(loader);
        }
        if (xmlConfig != null) {
            CacheFactory.getCacheFactoryBuilder().setCacheConfiguration(sConfigURI, loader, xmlConfig);
        }
        return CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(sConfigURI, loader);
    }

    private static synchronized ConfigHelper ensureConfigHelper(ClassLoader loader) {
        ConfigHelper helper = m_mapConfigHelper.get(loader);
        if (helper == null) {
            helper = new ConfigHelper(loader);
            m_mapConfigHelper.put(loader, helper);
        }
        return helper;
    }
}

