/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.router.OutboundRouterImpl;
import com.tangosol.coherence.transaction.internal.router.Router;

public class Endpoint {
    private final String m_sAddress;
    private Component m_component;
    private Router m_router = new OutboundRouterImpl();

    public Endpoint(String sAddress) {
        this.m_sAddress = sAddress;
    }

    public Endpoint(String sAddress, Component component) {
        this.m_sAddress = sAddress;
        this.m_component = component;
    }

    public String getAddress() {
        return this.m_sAddress;
    }

    public void setRouter(Router router) {
        this.m_router = router;
    }

    public Router getRouter() {
        return this.m_router;
    }

    public Message dispatch(Message msg) {
        if (this.m_component != null) {
            try {
                msg = this.m_component.invoke(msg);
            }
            catch (RuntimeException e) {
                msg.getResults().setException(e);
                return msg;
            }
        }
        return this.m_router.route(msg);
    }

    public String toString() {
        return "[Endpoint: " + this.getAddress() + "]";
    }
}

