/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.OptimisticNamedCache;
import com.tangosol.coherence.transaction.exception.ConnectionClosedException;
import com.tangosol.coherence.transaction.internal.ComparatorWrapper;
import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.ExtractorWrapper;
import com.tangosol.coherence.transaction.internal.FilterWrapper;
import com.tangosol.coherence.transaction.internal.MapEventTransformerImpl;
import com.tangosol.coherence.transaction.internal.MapListenerWrapper;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceConnection;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.ServiceWrapper;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.ValuesKeyExtractor;
import com.tangosol.coherence.transaction.internal.operation.AddIndexOperation;
import com.tangosol.coherence.transaction.internal.operation.AggregateOperation;
import com.tangosol.coherence.transaction.internal.operation.DeleteOperation;
import com.tangosol.coherence.transaction.internal.operation.EntrySetOperation;
import com.tangosol.coherence.transaction.internal.operation.FetchOperation;
import com.tangosol.coherence.transaction.internal.operation.InsertOperation;
import com.tangosol.coherence.transaction.internal.operation.InvokeFilterOperation;
import com.tangosol.coherence.transaction.internal.operation.InvokeKeyOperation;
import com.tangosol.coherence.transaction.internal.operation.KeySetOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.operation.PutAllOperation;
import com.tangosol.coherence.transaction.internal.operation.PutOperation;
import com.tangosol.coherence.transaction.internal.operation.RemoveIndexOperation;
import com.tangosol.coherence.transaction.internal.operation.RemoveOperation;
import com.tangosol.coherence.transaction.internal.operation.SizeOperation;
import com.tangosol.coherence.transaction.internal.operation.UpdateOperation;
import com.tangosol.coherence.transaction.internal.storage.FixedPartitionKey;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.util.EntrySetWrapper;
import com.tangosol.coherence.transaction.internal.util.KeySetWrapper;
import com.tangosol.coherence.transaction.internal.util.PartitionedEntrySetWrapper;
import com.tangosol.coherence.transaction.internal.util.PartitionedKeySetWrapper;
import com.tangosol.coherence.transaction.internal.util.ValuesWrapper;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.MapEventTransformerFilter;
import com.tangosol.util.processor.UpdaterProcessor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OptimisticNamedCacheImpl
implements OptimisticNamedCache {
    private final String m_sTable;
    private final ServiceConnection m_connection;
    private boolean m_valid = true;
    private ServiceContext m_context;
    Endpoint m_localDirector;

    public OptimisticNamedCacheImpl(ServiceConnection connection, String sTable) {
        this.m_connection = connection;
        this.m_sTable = sTable;
        CacheService service = (CacheService)this.m_connection.getService();
        ClassLoader loader = this.m_connection.getClassLoader();
        this.m_context = ServiceContext.getContext(service.getInfo().getServiceName());
        this.m_localDirector = this.m_context.getCompositionManager().getEndpoint("local-director");
        this.m_context.getSchema().ensureStorage(sTable, loader);
        LocalMemberState.getMemberState(this.getServiceName()).getJmxStats().registerCache(sTable, service);
    }

    @Override
    public void update(Object key, Object value, Filter validator) {
        UpdateOperation op = new UpdateOperation(this.getServiceName());
        op.addKey(key);
        op.setValue(value);
        op.setPredicate(validator);
        this.invoke(op);
    }

    @Override
    public void delete(Object key, Filter validator) {
        DeleteOperation op = new DeleteOperation(this.getServiceName());
        op.addKey(key);
        op.setValue(Storage.NIL);
        op.setPredicate(validator);
        this.invoke(op);
    }

    @Override
    public void insert(Object key, Object value) {
        InsertOperation op = new InsertOperation(this.getServiceName());
        op.addKey(key);
        op.setValue(value);
        op.setPredicate(Operation.INSERT_PREDICATE);
        this.invoke(op);
    }

    @Override
    public Map getAll(Collection collection) {
        FetchOperation op = new FetchOperation(this.getServiceName());
        HashSet set = new HashSet();
        set.addAll(collection);
        op.addKeys(set);
        return this.invoke(op).getResults();
    }

    @Override
    public Set keySet(Filter filter) {
        KeySetOperation op = new KeySetOperation(this.getServiceName());
        if (filter == null) {
            op.setPredicate(new FilterWrapper(AlwaysFilter.INSTANCE, this.m_context, this.m_sTable));
            op.setPartitionSet(new PartitionSet(((DistributedCacheService)this.m_context.getService()).getPartitionCount()));
            return new PartitionedKeySetWrapper(op, this);
        }
        op.setPredicate(new FilterWrapper(filter, this.m_context, this.m_sTable));
        Results map = this.invoke(op).getResults();
        return new KeySetWrapper(map.keySet(), this);
    }

    @Override
    public Set entrySet(Filter filter) {
        return this.entrySet(filter, null);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        EntrySetOperation op = new EntrySetOperation(this.getServiceName());
        op.setComparator(new ComparatorWrapper(comparator));
        if (filter == null) {
            op.setPredicate(new FilterWrapper(AlwaysFilter.INSTANCE, this.m_context, this.m_sTable));
            op.setPartitionSet(new PartitionSet(((DistributedCacheService)this.m_context.getService()).getPartitionCount()));
            return new PartitionedEntrySetWrapper(op, this);
        }
        op.setPredicate(new FilterWrapper(filter, this.m_context, this.m_sTable));
        Results map = this.invoke(op).getResults();
        return new EntrySetWrapper(map.entrySet(), this);
    }

    @Override
    public void addIndex(ValueExtractor valueExtractor, boolean fOrdered, Comparator comparator) {
        if (valueExtractor instanceof IndexAwareExtractor) {
            throw new UnsupportedOperationException("Custom indexes are not supported for transactional caches.");
        }
        AddIndexOperation op = new AddIndexOperation(this.getServiceName());
        op.setValueExtractor(new ExtractorWrapper(valueExtractor, this.m_context, this.m_sTable));
        op.setOrdered(fOrdered);
        op.setComparator(new ComparatorWrapper(comparator));
        this.invoke(op);
    }

    @Override
    public void removeIndex(ValueExtractor valueExtractor) {
        RemoveIndexOperation op = new RemoveIndexOperation(this.getServiceName());
        op.setValueExtractor(new ExtractorWrapper(valueExtractor, this.m_context, this.m_sTable));
        this.invoke(op);
    }

    @Override
    public Object get(Object key) {
        this.checkClosed();
        FetchOperation op = new FetchOperation(this.getServiceName());
        op.addKey(key);
        return this.invoke(op).getResults().getClientData().get(key);
    }

    @Override
    public void putAll(Map map) {
        PutAllOperation op = new PutAllOperation(this.getServiceName());
        op.setValues(map);
        this.invoke(op);
    }

    public Set entrySet() {
        return this.entrySet(null, null);
    }

    public Set keySet() {
        return this.keySet(null);
    }

    @Override
    public Object remove(Object oKey) {
        RemoveOperation op = new RemoveOperation(this.getServiceName());
        op.addKey(oKey);
        op.setValue(Storage.NIL);
        return this.invoke(op).getResults().get(oKey);
    }

    @Override
    public int size() {
        SizeOperation op = new SizeOperation(this.getServiceName());
        Schema schema = this.m_connection.getSchema();
        Set<FixedPartitionKey> m_setPartitions = schema.getPartitionSetKeys();
        op.addKeys(m_setPartitions);
        return (Integer)this.invoke(op).getResults().get(AggregateOperation.AGGREGATE_KEY);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return (Integer)this.aggregate(new EqualsFilter(new KeyExtractor(IdentityExtractor.INSTANCE), o), (InvocableMap.EntryAggregator)new Count()) > 0;
    }

    @Override
    public boolean containsValue(Object o) {
        return (Integer)this.aggregate(new EqualsFilter(IdentityExtractor.INSTANCE, o), (InvocableMap.EntryAggregator)new Count()) > 0;
    }

    @Override
    public Object put(Object key, Object value) {
        PutOperation op = new PutOperation(this.getServiceName());
        op.addKey(key);
        op.setValue(value);
        op.setPredicate(null);
        return this.invoke(op).getResults().get(key);
    }

    @Override
    public void clear() {
        InvokeFilterOperation op = new InvokeFilterOperation(this.getServiceName());
        FilterWrapper filter = new FilterWrapper(AlwaysFilter.INSTANCE, this.m_context, this.m_sTable);
        op.setPredicate(filter);
        op.setEntryProcessor(new UpdaterProcessor((ValueUpdater)null, (Object)Storage.NIL));
        this.invoke(op);
    }

    public Collection values() {
        EntrySetOperation op = new EntrySetOperation(this.getServiceName());
        op.setPredicate(new FilterWrapper(AlwaysFilter.INSTANCE, this.m_context, this.m_sTable));
        op.setPartitionSet(new PartitionSet(((DistributedCacheService)this.m_context.getService()).getPartitionCount()));
        return new ValuesWrapper(op, this);
    }

    @Override
    public String getCacheName() {
        return this.m_sTable;
    }

    @Override
    public CacheService getCacheService() {
        return new ServiceWrapper(this.m_context);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void release() {
        this.m_valid = false;
    }

    @Override
    public void destroy() {
        this.m_valid = false;
        CacheService service = (CacheService)this.m_connection.getService();
        Schema schema = this.m_connection.getSchema();
        TableInfoImpl table = new TableInfoImpl(this.m_sTable, service.getInfo().getServiceName());
        NamedCache valuesTable = schema.getValuesTableByName(this.m_sTable);
        valuesTable.removeIndex(new ValuesKeyExtractor(table));
        service.destroyCache(valuesTable);
        service.destroyCache(schema.getVersionsTableByName(this.m_sTable));
        service.destroyCache(schema.getNaturalKeysTableByName(this.m_sTable));
    }

    @Override
    public Object put(Object object, Object object1, long l) {
        throw new UnsupportedOperationException("Expiry is currently not available when using a transactional cache");
    }

    @Override
    public void addMapListener(MapListener mapListener) {
        if (mapListener instanceof MapTriggerListener) {
            throw new UnsupportedOperationException("MapTriggers are not supported for transactional caches");
        }
        MapEventTransformerFilter transformerFilter = new MapEventTransformerFilter(null, new MapEventTransformerImpl(this.getCacheName(), this.getServiceName()));
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).addMapListener((MapListener)listenerWrapper, transformerFilter, false);
    }

    @Override
    public void removeMapListener(MapListener mapListener) {
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).removeMapListener(listenerWrapper);
    }

    @Override
    public void addMapListener(MapListener mapListener, Object key, boolean fLite) {
        if (mapListener instanceof MapTriggerListener) {
            throw new UnsupportedOperationException("MapTriggers are not supported for transactional caches");
        }
        MapEventTransformerFilter transformerFilter = new MapEventTransformerFilter(null, new MapEventTransformerImpl(this.getCacheName(), this.getServiceName(), key));
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).addMapListener((MapListener)listenerWrapper, transformerFilter, false);
    }

    @Override
    public void removeMapListener(MapListener mapListener, Object key) {
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).removeMapListener((MapListener)listenerWrapper, key);
    }

    @Override
    public void addMapListener(MapListener mapListener, Filter filter, boolean fLite) {
        if (mapListener instanceof MapTriggerListener) {
            throw new UnsupportedOperationException("MapTriggers are not supported for transactional caches");
        }
        MapEventTransformerFilter transformerFilter = new MapEventTransformerFilter(null, new MapEventTransformerImpl(this.getCacheName(), this.getServiceName(), filter));
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).addMapListener((MapListener)listenerWrapper, transformerFilter, false);
    }

    @Override
    public void removeMapListener(MapListener mapListener, Filter filter) {
        MapListenerWrapper listenerWrapper = new MapListenerWrapper(mapListener, this);
        this.m_connection.getSchema().getVersionsTableByName(this.getCacheName()).removeMapListener((MapListener)listenerWrapper, filter);
    }

    @Override
    public boolean lock(Object object, long l) {
        throw new UnsupportedOperationException("The ConcurrentMap API is currently not available when using a transactional cache");
    }

    @Override
    public boolean lock(Object object) {
        throw new UnsupportedOperationException("The ConcurrentMap API is currently not available when using a transactional cache");
    }

    @Override
    public boolean unlock(Object object) {
        throw new UnsupportedOperationException("The ConcurrentMap API is currently not available when using a transactional cache");
    }

    @Override
    public Object invoke(Object object, InvocableMap.EntryProcessor entryProcessor) {
        InvokeKeyOperation op = new InvokeKeyOperation(this.getServiceName());
        op.addKey(object);
        op.setEntryProcessor(entryProcessor);
        return this.invoke(op).getResults().get(object);
    }

    @Override
    public Map invokeAll(Collection collection, InvocableMap.EntryProcessor entryProcessor) {
        ImmutableArrayList setKeys = new ImmutableArrayList(collection.toArray(), 0, collection.size());
        InvokeKeyOperation op = new InvokeKeyOperation(this.getServiceName());
        op.addKeys(setKeys);
        op.setEntryProcessor(entryProcessor);
        return this.invoke(op).getResults();
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor entryProcessor) {
        InvokeFilterOperation op = new InvokeFilterOperation(this.getServiceName());
        filter = new FilterWrapper(filter, this.m_context, this.m_sTable);
        op.setPredicate(filter);
        op.setEntryProcessor(entryProcessor);
        return this.invoke(op).getResults();
    }

    @Override
    public Object aggregate(Collection collection, InvocableMap.EntryAggregator entryAggregator) {
        ImmutableArrayList setKeys = new ImmutableArrayList(collection.toArray(), 0, collection.size());
        InFilter filter = new InFilter((ValueExtractor)new KeyExtractor(IdentityExtractor.INSTANCE), (Set)setKeys);
        return this.aggregate(filter, entryAggregator);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator entryAggregator) {
        AggregateOperation op = new AggregateOperation(this.getServiceName());
        filter = new FilterWrapper(filter, this.m_context, this.m_sTable);
        op.setPredicate(filter);
        op.setEntryAggregator(entryAggregator);
        return this.invoke(op).getResults().get(AggregateOperation.AGGREGATE_KEY);
    }

    public Message invoke(Operation op) {
        op.setTableName(this.m_sTable);
        op.setAutoCommit(this.getTransaction().isAutoCommit());
        op.setXid(this.getTransaction().getXid());
        Message msg = new Message(op);
        msg.setContext(this.getTransaction());
        msg = this.m_localDirector.dispatch(msg);
        if (msg.getResults() == null) {
            throw new RuntimeException("Unknown error occurred: Invocation did not return a value");
        }
        return msg;
    }

    protected Transaction getTransaction() {
        return this.m_connection.getTransaction();
    }

    protected Session getSession() {
        return this.getTransaction().getSession();
    }

    protected boolean isEager() {
        return this.m_connection.isEager();
    }

    protected void checkClosed() {
        if (this.m_connection.isClosed()) {
            throw new ConnectionClosedException("ServiceConnection is closed");
        }
        if (!this.m_valid) {
            throw new IllegalStateException("Cache has been released.");
        }
    }

    protected String getServiceName() {
        return this.m_connection.getService().getInfo().getServiceName();
    }

    public ServiceContext getServiceContext() {
        return this.m_context;
    }
}

