/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.SimpleXid;
import com.tangosol.coherence.transaction.internal.ValuesKeyExtractor;
import com.tangosol.coherence.transaction.internal.ValuesKeyIndex;
import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.aggregator.AbstractAggregator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class XidManager {
    private String m_sService;
    private int m_block;
    private long m_lRemaining;
    private volatile NamedCache m_cacheXidBlocks;
    private volatile NamedCache m_cacheXidRoot;
    private volatile ServiceContext m_context;
    private static final String ROOT_KEY = "RootXid";
    private static final int BLOCK_SIZE_BITS = 48;
    private static final long BLOCK_SIZE = 0x1000000000000L;
    private static final long NUM_BLOCKS = 32767L;
    private static final long BLOCKID_MASK = 0x7FFF000000000000L;
    private static final KeyExtractor KEY_EXTRACTOR = new KeyExtractor(IdentityExtractor.INSTANCE);

    public XidManager(String sService) {
        this.m_sService = sService;
    }

    public TransactionId nextXid() {
        return new SimpleXid(this.next());
    }

    public InvocableMap.EntryAggregator getLockedXidsAggregator(TableInfo tableInfo) {
        return new LockedXids(tableInfo);
    }

    public Set getBlockIds(Member member) {
        Collection collBlocks = (Collection)this.getXidBlocksCache().get(member);
        return collBlocks == null ? null : new ImmutableArrayList(collBlocks);
    }

    public static Integer extractBlockId(TransactionId xid) {
        long lXid = xid.getId();
        return (int)((lXid & 0x7FFF000000000000L) >> 48);
    }

    public static boolean isKeyVisibleByTx(XidSyntheticKey xidSynKey, TransactionId xid, Set setXidSynKeys, long lVersion, TableInfo tableInfo) {
        SyntheticKey synKey = new SyntheticKey(xidSynKey.getKey());
        if (xid.equals(xidSynKey.getXid())) {
            return true;
        }
        if (setXidSynKeys.contains(new XidSyntheticKey(synKey, xid))) {
            return false;
        }
        LocalPartitionState lps = LocalMemberState.getMemberState(tableInfo.getServiceName()).getLocalPartitionState(synKey.getPartition());
        TransactionId versionXid = lps.ensureVersionIndex(tableInfo.getTableName()).getXid(synKey, lVersion);
        return versionXid != null && versionXid.equals(xidSynKey.getXid());
    }

    public static XidSyntheticKey getXidSynKeyFromEntry(BinaryEntry entry, TableInfo table) {
        XidSyntheticKey xidSynKey = null;
        ValuesKeyIndex index = ValuesKeyExtractor.getIndex(table);
        if (index != null) {
            xidSynKey = (XidSyntheticKey)index.get(entry.getBinaryKey());
        }
        if (xidSynKey == null) {
            String sLogMsg = index == null ? "Transactional values cache key index is missing." : "Transactional values cache key missing from index.";
            CacheFactory.log(sLogMsg, 2);
            Object oKey = entry.getKey();
            xidSynKey = oKey instanceof Binary ? (XidSyntheticKey)entry.extract(KEY_EXTRACTOR) : (XidSyntheticKey)oKey;
        }
        return xidSynKey;
    }

    public static Object getNaturalKey(XidSyntheticKey xidSynKey, TableInfo tableInfo) {
        long lKey = xidSynKey.getKey();
        LocalPartitionState lps = LocalMemberState.getMemberState(tableInfo.getServiceName()).getLocalPartitionState(SyntheticKey.getPartition(lKey));
        KeyIndex keyIndex = lps.getKeyIndex(tableInfo.getTableName());
        return keyIndex.getNaturalKey(SyntheticKey.getIndex(lKey));
    }

    private synchronized long next() {
        if (this.m_lRemaining == 0L) {
            this.takeNextBlock();
        }
        long lXid = (long)this.m_block << 48 | 0x1000000000000L - this.m_lRemaining;
        --this.m_lRemaining;
        return lXid;
    }

    private void takeNextBlock() {
        Integer block = (Integer)this.getXidRootCache().invoke(ROOT_KEY, new TakeBlockProcessor());
        Base.azzert(block != null);
        this.m_block = block;
        this.getXidBlocksCache().invoke(this.getContext().getSchema().getLocalMember(), new RegisterBlockProcessor(block));
        this.m_lRemaining = 0x1000000000000L;
    }

    private NamedCache getXidRootCache() {
        if (this.m_cacheXidRoot == null) {
            this.m_cacheXidRoot = this.getContext().getSchema().getXidBlockTable();
        }
        return this.m_cacheXidRoot;
    }

    private NamedCache getXidBlocksCache() {
        if (this.m_cacheXidBlocks == null) {
            this.m_cacheXidBlocks = this.getContext().getSchema().getXidMemberTable();
        }
        return this.m_cacheXidBlocks;
    }

    private ServiceContext getContext() {
        if (this.m_context == null) {
            this.m_context = ServiceContext.getContext(this.m_sService);
        }
        return this.m_context;
    }

    public static class LockedXids
    extends AbstractAggregator
    implements ExternalizableLite,
    PortableObject {
        private Set<XidSyntheticKey> m_setKeys = new HashSet<XidSyntheticKey>();
        private TableInfo m_tableInfo;

        public LockedXids() {
        }

        public LockedXids(TableInfo tableInfo) {
            super(KEY_EXTRACTOR);
            this.m_tableInfo = tableInfo;
        }

        @Override
        protected void init(boolean fFinal) {
            this.m_setKeys = new HashSet<XidSyntheticKey>();
        }

        @Override
        protected void process(Object o, boolean fFinal) {
            this.m_setKeys.add((XidSyntheticKey)o);
        }

        @Override
        public Object aggregateResults(Collection collResults) {
            HashMap<Long, HashSet<XidSyntheticKey>> mapResults = new HashMap<Long, HashSet<XidSyntheticKey>>();
            for (Object collResult : collResults) {
                Collection cacheResults = (Collection)collResult;
                for (Object cacheResult : cacheResults) {
                    XidSyntheticKey key = (XidSyntheticKey)cacheResult;
                    HashSet<XidSyntheticKey> set = (HashSet<XidSyntheticKey>)mapResults.get(key.getXid().getId());
                    if (set == null) {
                        set = new HashSet<XidSyntheticKey>();
                        mapResults.put(key.getXid().getId(), set);
                    }
                    set.add(key);
                }
            }
            return mapResults;
        }

        @Override
        protected Object finalizeResult(boolean fFinal) {
            return this.m_setKeys;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            super.readExternal(in);
            LockedXids.readCollection(in, this.m_setKeys, null);
            this.m_tableInfo = (TableInfo)LockedXids.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            super.writeExternal(out);
            LockedXids.writeCollection(out, this.m_setKeys);
            LockedXids.writeObject(out, this.m_tableInfo);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            super.readExternal(in);
            in.readCollection(2, this.m_setKeys);
            this.m_tableInfo = (TableInfo)in.readObject(3);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            super.writeExternal(out);
            out.writeCollection(2, this.m_setKeys);
            out.writeObject(3, this.m_tableInfo);
        }
    }

    public static class RegisterBlockProcessor
    extends AbstractProcessor
    implements ExternalizableLite,
    PortableObject {
        private Integer m_block;

        public RegisterBlockProcessor() {
        }

        public RegisterBlockProcessor(Integer block) {
            this.m_block = block;
        }

        @Override
        public Object process(InvocableMap.Entry entry) {
            HashSet<Integer> collBlockIds = (HashSet<Integer>)entry.getValue();
            if (collBlockIds == null) {
                collBlockIds = new HashSet<Integer>();
            }
            collBlockIds.add(this.m_block);
            entry.setValue(collBlockIds);
            return null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_block = Base.makeInteger(in.readInt());
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            out.writeInt(this.m_block);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_block = Base.makeInteger(in.readInt(1));
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(1, this.m_block);
        }
    }

    public static class TakeBlockProcessor
    extends AbstractProcessor
    implements ExternalizableLite,
    PortableObject {
        @Override
        public Object process(InvocableMap.Entry entry) {
            Integer currentVal = (Integer)entry.getValue();
            Integer newVal = currentVal == null ? 0 : currentVal + 1;
            Base.azzert((long)newVal.intValue() < 32767L);
            entry.setValue(newVal);
            return newVal;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }
}

