/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.InvokeOperation;
import com.tangosol.coherence.transaction.internal.operation.InvokeUpdateOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStorageInvoke
implements Component {
    @Override
    public Message invoke(Message msg) {
        InvokeOperation op = (InvokeOperation)msg.getOperation();
        Results results = msg.getResults();
        Set setEntries = this.obtainEntrySet(msg);
        Long version = (Long)msg.getBinding("write-version");
        LocalMemberState.getMemberState(op.getServiceName()).setCurrentWriteVersion(version);
        InvocableMap.EntryProcessor processor = op.getEntryProcessor();
        if (setEntries.size() == 1) {
            InvocableMap.Entry entry = (InvocableMap.Entry)setEntries.iterator().next();
            results.put(entry.getKey(), processor.process(entry));
        } else if (setEntries.size() > 1) {
            results.putAll(processor.processAll(setEntries));
        }
        for (Object setEntry : setEntries) {
            EntryProxy entry = (EntryProxy)setEntry;
            if (!entry.isUpdated()) continue;
            results.addInvokeData(entry.getKey(), entry.getValue());
        }
        return msg;
    }

    protected abstract Set obtainEntrySet(Message var1);

    protected EntryProxy createEntryProxy(Map.Entry entry, InvocableMap.Entry valueEntry, Object oValue, Serializer serializer, BackingMapManagerContext context, boolean fPresent, Message msg) {
        return new EntryProxy(entry, valueEntry, oValue, serializer, context, fPresent, msg);
    }

    protected class EntryProxy
    implements BinaryEntry {
        private final Map.Entry m_entry;
        private final InvocableMap.Entry m_valueEntry;
        private final Binary m_binaryKey;
        private Object m_oValue;
        private final Serializer m_serializer;
        private final BackingMapManagerContext m_context;
        private boolean m_fPresent;
        private Message m_msg;
        private boolean m_fUpdated = false;

        EntryProxy(Map.Entry entry, InvocableMap.Entry valueEntry, Object oValue, Serializer serializer, BackingMapManagerContext context, boolean fPresent, Message msg) {
            this.m_oValue = oValue;
            this.m_entry = entry;
            this.m_valueEntry = valueEntry;
            this.m_fPresent = fPresent;
            this.m_msg = msg;
            this.m_serializer = serializer;
            this.m_context = context;
            this.m_binaryKey = (Binary)this.m_context.getKeyToInternalConverter().convert(this.m_entry.getKey());
        }

        @Override
        public Object getKey() {
            return this.m_entry.getKey();
        }

        @Override
        public Object getValue() {
            return this.m_oValue;
        }

        @Override
        public Object setValue(Object oValue) {
            Object oldValue = this.m_oValue;
            this.setValue(oValue, false);
            return oldValue;
        }

        @Override
        public void setValue(Object oValue, boolean synthetic) {
            if (this.m_valueEntry != null) {
                this.m_valueEntry.setValue(oValue, synthetic);
            } else {
                this.dispatchWrite(oValue);
                this.m_fUpdated = this.m_fUpdated || !oValue.equals(this.m_oValue);
                this.m_oValue = oValue;
                this.m_fPresent = true;
            }
        }

        @Override
        public void update(ValueUpdater updater, Object oValue) {
            Object oTarget = this.m_oValue;
            updater.update(oTarget, oValue);
            this.setValue(oTarget, false);
            this.m_fUpdated = true;
        }

        @Override
        public boolean isPresent() {
            return this.m_fPresent;
        }

        @Override
        public void remove(boolean fSynthetic) {
            this.setValue(Storage.NIL, fSynthetic);
        }

        @Override
        public Object extract(ValueExtractor valueExtractor) {
            return valueExtractor.extract(this.m_oValue);
        }

        @Override
        public Binary getBinaryKey() {
            return this.m_binaryKey;
        }

        @Override
        public Binary getBinaryValue() {
            return (Binary)this.getContext().getValueToInternalConverter().convert(this.m_oValue);
        }

        @Override
        public Serializer getSerializer() {
            return this.m_serializer;
        }

        @Override
        public BackingMapManagerContext getContext() {
            return this.m_context;
        }

        @Override
        public void updateBinaryValue(Binary binary) {
            if (binary == null) {
                this.remove(false);
            } else {
                this.setValue(this.getContext().getValueFromInternalConverter().convert(binary));
            }
        }

        @Override
        public Object getOriginalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Binary getOriginalBinaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObservableMap getBackingMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BackingMapContext getBackingMapContext() {
            return null;
        }

        @Override
        public void expire(long cMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public boolean isUpdated() {
            return this.m_fUpdated;
        }

        private Message dispatchWrite(Object oValue) {
            Operation op = this.m_msg.getOperation();
            String sService = op.getServiceName();
            InvokeUpdateOperation updateOp = new InvokeUpdateOperation(sService);
            updateOp.setTableName(op.getTableName());
            updateOp.addKey(this.m_entry.getKey());
            updateOp.setValue(oValue);
            updateOp.setXid(op.getXid());
            Message msg = new Message();
            msg.setOperation(updateOp);
            msg.setContext(Collections.singleton(this.m_entry));
            msg.setResults(this.m_msg.getResults());
            msg.addBindings(this.m_msg.getBindings());
            ServiceContext context = ServiceContext.getContext(sService);
            Endpoint ep = context.getCompositionManager().getEndpoint("storage.write");
            return ep.dispatch(msg);
        }
    }
}

