/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.exception.RollbackException;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.JmxStats;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;

public class ClientAutoCommit
implements Component {
    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        if (op.isAutoCommit()) {
            Results r = msg.getResults();
            RuntimeException e = r.getException();
            Transaction tx = (Transaction)msg.getContext();
            if (!op.isSingleKey()) {
                if (e == null) {
                    tx.commit();
                } else {
                    tx.rollback();
                    r.setException(new RollbackException(e));
                }
            } else {
                JmxStats jmxStats = LocalMemberState.getMemberState(op.getServiceName()).getJmxStats();
                jmxStats.incrementTotalTransactionMillis(System.currentTimeMillis() - tx.getTimestamp());
                if (e == null) {
                    tx.setCommitted();
                    jmxStats.incrementCommitCount();
                } else {
                    tx.setRolledback();
                    jmxStats.incrementRollbackCount();
                    r.setException(new RollbackException(e));
                }
            }
        }
        return msg;
    }
}

