/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.component.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CompositeComponent
implements Component {
    private List<Component> m_listComponents;
    private Component m_errorComponent;

    public CompositeComponent(Component ... components) {
        this.m_listComponents = Arrays.asList(components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message invoke(Message msg) {
        Set setEntries = (Set)msg.getContext();
        for (Object oEntry : setEntries) {
            Set setSingleEntry = Collections.singleton(oEntry);
            msg.setContext(setSingleEntry);
            try {
                for (Component component : this.m_listComponents) {
                    msg = component.invoke(msg);
                    if (!msg.getResults().hasError()) continue;
                    Message message = this.m_errorComponent.invoke(msg);
                    return message;
                }
            }
            catch (RuntimeException e) {
                msg.getResults().setException(e);
                Message message = this.m_errorComponent.invoke(msg);
                return message;
            }
            finally {
                msg.setContext(setEntries);
            }
        }
        return msg;
    }

    public void setErrorComponent(Component errorHandler) {
        this.m_errorComponent = errorHandler;
    }
}

