/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ValuesKeyExtractor;
import com.tangosol.coherence.transaction.internal.ValuesKeyIndex;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.AggregateOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.operation.SizeOperation;
import com.tangosol.coherence.transaction.internal.storage.FixedPartitionKey;
import com.tangosol.coherence.transaction.internal.storage.IndexedXidSyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StorageSize
implements Component {
    @Override
    public Message invoke(Message msg) {
        int cSize = 0;
        Results results = msg.getResults();
        Operation op = msg.getOperation();
        TableInfoImpl tableInfo = new TableInfoImpl(op.getTableName(), op.getServiceName());
        ValuesKeyIndex index = ValuesKeyExtractor.getIndex(tableInfo);
        if (index != null) {
            Set setEntries = (Set)msg.getContext();
            HashSet<Integer> setPartitions = new HashSet<Integer>();
            Iterator iter = setEntries.iterator();
            while (iter.hasNext()) {
                FixedPartitionKey key = (FixedPartitionKey)((Map.Entry)iter.next()).getKey();
                setPartitions.add(key.getPartition());
            }
            Object oVersion = msg.getBinding("version");
            long lVersion = oVersion == null ? LocalMemberState.getMemberState(op.getServiceName()).getCurrentWriteVersion() : ((Long)oVersion).longValue();
            Collection colKeys = index.getValues();
            for (IndexedXidSyntheticKey xidSynKey : colKeys) {
                int nPartition;
                if (xidSynKey.isEntryDeleted() || !setPartitions.contains(nPartition = SyntheticKey.getPartition(xidSynKey.getKey())) || !XidManager.isKeyVisibleByTx(xidSynKey, op.getXid(), ((SizeOperation)op).getCurrentXidSynKeys(), lVersion, tableInfo)) continue;
                ++cSize;
            }
        }
        results.put(AggregateOperation.AGGREGATE_KEY, (Object)cSize);
        return msg;
    }
}

