/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.composition;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.composition.EndpointManager;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.router.CoherenceDispatch;
import com.tangosol.coherence.transaction.internal.router.OperationFilter;
import com.tangosol.coherence.transaction.internal.router.RouterConcern;
import com.tangosol.coherence.transaction.internal.router.StaticEndpointConcern;
import com.tangosol.coherence.transaction.internal.router.StorageAutoCommitConcern;

public class CompositionManager {
    EndpointManager m_endpointManager = new EndpointManager();

    public void initialize() {
        this.m_endpointManager.initializeEndpoints();
        this.composeFetch();
        this.composeWrite();
        this.composePut();
        this.composeInvoke();
        this.composeInvokeFilter();
        this.composeKeySet();
        this.composeEntrySet();
        this.composeAggregate();
        this.composeAddIndex();
        this.composeRemoveIndex();
        this.composeSize();
        this.composeCommit();
        this.composeRollback();
        this.composeUpdateVersionDependencies();
    }

    public Endpoint getEndpoint(String sAddress) {
        return this.m_endpointManager.getEndpoint(sAddress);
    }

    private void composeFetch() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint jmxBeginEndpoint = this.getEndpoint("jmx.request.begin");
        Endpoint storageFetchEndpoint = this.getEndpoint("storage.fetch");
        Endpoint jmxEndEndpoint = this.getEndpoint("jmx.get.end");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Fetch, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Fetch, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Fetch, (RouterConcern)new CoherenceDispatch(jmxBeginEndpoint)));
        jmxBeginEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Fetch, (RouterConcern)new StaticEndpointConcern(storageFetchEndpoint)));
        storageFetchEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Fetch, (RouterConcern)new StaticEndpointConcern(jmxEndEndpoint)));
    }

    private void composeWrite() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindMemberVersionEndpoint = this.getEndpoint("version.member.bind");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint jmxBeginEndpoint = this.getEndpoint("jmx.request.begin");
        Endpoint storageWriteEndpoint = this.getEndpoint("storage.write");
        Endpoint sessionReconcileEndpoint = this.getEndpoint("session.reconcile");
        Endpoint storageAutoCommitEndpoint = this.getEndpoint("storage.commit.auto");
        Endpoint clientAutoCommitEndpoint = this.getEndpoint("client.commit.auto");
        Endpoint clientHandleErrorEndpoint = this.getEndpoint("client.error");
        Endpoint jmxEndEndpoint = this.getEndpoint("jmx.put.end");
        Operation.Id[] aiOps = new Operation.Id[]{Operation.Id.Insert, Operation.Id.Update, Operation.Id.Delete, Operation.Id.PutAll};
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(bindMemberVersionEndpoint)));
        bindMemberVersionEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new CoherenceDispatch(jmxBeginEndpoint)));
        jmxBeginEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(storageWriteEndpoint)));
        storageWriteEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(jmxEndEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(sessionReconcileEndpoint)));
        storageWriteEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StorageAutoCommitConcern(storageAutoCommitEndpoint)));
        sessionReconcileEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(clientAutoCommitEndpoint)));
        clientAutoCommitEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(clientHandleErrorEndpoint)));
    }

    private void composePut() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindMemberVersionEndpoint = this.getEndpoint("version.member.bind");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint jmxBeginEndpoint = this.getEndpoint("jmx.request.begin");
        Endpoint storageWriteEndpoint = this.getEndpoint("storage.write");
        Endpoint storageFetchEndpoint = this.getEndpoint("storage.fetch");
        Endpoint sessionReconcileEndpoint = this.getEndpoint("session.reconcile");
        Endpoint storageAutoCommitEndpoint = this.getEndpoint("storage.commit.auto");
        Endpoint clientAutoCommitEndpoint = this.getEndpoint("client.commit.auto");
        Endpoint clientHandleErrorEndpoint = this.getEndpoint("client.error");
        Endpoint jmxEndEndpoint = this.getEndpoint("jmx.put.end");
        Operation.Id[] aiOps = new Operation.Id[]{Operation.Id.Put, Operation.Id.Remove};
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(bindMemberVersionEndpoint)));
        bindMemberVersionEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new CoherenceDispatch(jmxBeginEndpoint)));
        jmxBeginEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(storageFetchEndpoint)));
        storageFetchEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(storageWriteEndpoint)));
        storageWriteEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(jmxEndEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(sessionReconcileEndpoint)));
        storageFetchEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StorageAutoCommitConcern(storageAutoCommitEndpoint)));
        sessionReconcileEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(clientAutoCommitEndpoint)));
        clientAutoCommitEndpoint.getRouter().registerConcern(new OperationFilter(aiOps, (RouterConcern)new StaticEndpointConcern(clientHandleErrorEndpoint)));
    }

    private void composeInvoke() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint bindMemberVersionEndpoint = this.getEndpoint("version.member.bind");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageInvokeEndpoint = this.getEndpoint("storage.invoke");
        Endpoint sessionReconcileEndpoint = this.getEndpoint("session.reconcile");
        Endpoint storageAutoCommitEndpoint = this.getEndpoint("storage.commit.auto");
        Endpoint clientAutoCommitEndpoint = this.getEndpoint("client.commit.auto");
        Endpoint clientHandleErrorEndpoint = this.getEndpoint("client.error");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(bindMemberVersionEndpoint)));
        bindMemberVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new CoherenceDispatch(storageInvokeEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(sessionReconcileEndpoint)));
        storageInvokeEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StorageAutoCommitConcern(storageAutoCommitEndpoint)));
        sessionReconcileEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(clientAutoCommitEndpoint)));
        clientAutoCommitEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeKey, (RouterConcern)new StaticEndpointConcern(clientHandleErrorEndpoint)));
    }

    private void composeInvokeFilter() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint bindMemberVersionEndpoint = this.getEndpoint("version.member.bind");
        Endpoint clientInitFilterEndpoint = this.getEndpoint("client.init");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageInvokeEndpoint = this.getEndpoint("storage.invoke.filter");
        Endpoint sessionReconcileEndpoint = this.getEndpoint("session.reconcile");
        Endpoint clientAutoCommitEndpoint = this.getEndpoint("client.commit.auto");
        Endpoint clientHandleErrorEndpoint = this.getEndpoint("client.error");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(bindMemberVersionEndpoint)));
        bindMemberVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(clientInitFilterEndpoint)));
        clientInitFilterEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new CoherenceDispatch(storageInvokeEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(sessionReconcileEndpoint)));
        sessionReconcileEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(clientAutoCommitEndpoint)));
        clientAutoCommitEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.InvokeFilter, (RouterConcern)new StaticEndpointConcern(clientHandleErrorEndpoint)));
    }

    private void composeKeySet() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint clientInitFilterEndpoint = this.getEndpoint("client.init");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageQueryEndpoint = this.getEndpoint("storage.query.key");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.KeySet, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.KeySet, (RouterConcern)new StaticEndpointConcern(clientInitFilterEndpoint)));
        clientInitFilterEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.KeySet, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.KeySet, (RouterConcern)new CoherenceDispatch(storageQueryEndpoint)));
    }

    private void composeEntrySet() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint clientInitFilterEndpoint = this.getEndpoint("client.init");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageQueryEndpoint = this.getEndpoint("storage.query.entry");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.EntrySet, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.EntrySet, (RouterConcern)new StaticEndpointConcern(clientInitFilterEndpoint)));
        clientInitFilterEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.EntrySet, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.EntrySet, (RouterConcern)new CoherenceDispatch(storageQueryEndpoint)));
    }

    private void composeAggregate() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint clientInitFilterEndpoint = this.getEndpoint("client.init");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageAggregateEndpoint = this.getEndpoint("storage.aggregate");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Aggregate, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Aggregate, (RouterConcern)new StaticEndpointConcern(clientInitFilterEndpoint)));
        clientInitFilterEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Aggregate, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Aggregate, (RouterConcern)new CoherenceDispatch(storageAggregateEndpoint)));
    }

    private void composeAddIndex() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint addIndexEndpoint = this.getEndpoint("storage.index.add");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.AddIndex, (RouterConcern)new StaticEndpointConcern(addIndexEndpoint)));
    }

    private void composeRemoveIndex() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint removeIndexEndpoint = this.getEndpoint("storage.index.remove");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.RemoveIndex, (RouterConcern)new StaticEndpointConcern(removeIndexEndpoint)));
    }

    private void composeSize() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint bindReadVersionEndpoint = this.getEndpoint("version.read.bind");
        Endpoint clientInitFilterEndpoint = this.getEndpoint("client.init");
        Endpoint sizeEndpoint = this.getEndpoint("storage.size");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Size, (RouterConcern)new StaticEndpointConcern(bindReadVersionEndpoint)));
        bindReadVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Size, (RouterConcern)new StaticEndpointConcern(clientInitFilterEndpoint)));
        clientInitFilterEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Size, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Size, (RouterConcern)new CoherenceDispatch(sizeEndpoint)));
    }

    private void composeCommit() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint bindCommitVersionEndpoint = this.getEndpoint("version.commit.bind");
        Endpoint syncSyntheticKeysEndpoint = this.getEndpoint("client.keys.sync");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint writeMemberVersionEndpoint = this.getEndpoint("version.member.write");
        Endpoint storageCommitEndpoint = this.getEndpoint("storage.commit");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Commit, (RouterConcern)new StaticEndpointConcern(bindCommitVersionEndpoint)));
        bindCommitVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Commit, (RouterConcern)new StaticEndpointConcern(syncSyntheticKeysEndpoint)));
        syncSyntheticKeysEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Commit, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Commit, (RouterConcern)new CoherenceDispatch(writeMemberVersionEndpoint)));
        writeMemberVersionEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Commit, (RouterConcern)new StaticEndpointConcern(storageCommitEndpoint)));
    }

    private void composeRollback() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint syncSyntheticKeysEndpoint = this.getEndpoint("client.keys.sync");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint storageRollbackEndpoint = this.getEndpoint("storage.rollback");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Rollback, (RouterConcern)new StaticEndpointConcern(syncSyntheticKeysEndpoint)));
        syncSyntheticKeysEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Rollback, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.Rollback, (RouterConcern)new CoherenceDispatch(storageRollbackEndpoint)));
    }

    private void composeUpdateVersionDependencies() {
        Endpoint localDirectorEndpoint = this.getEndpoint("local-director");
        Endpoint storageEndpoint = this.getEndpoint("storage");
        Endpoint updateDependenciesEndpoint = this.getEndpoint("version.commit.update");
        localDirectorEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.UpdateCommitVersion, (RouterConcern)new StaticEndpointConcern(storageEndpoint)));
        storageEndpoint.getRouter().registerConcern(new OperationFilter(Operation.Id.UpdateCommitVersion, (RouterConcern)new CoherenceDispatch(updateDependenciesEndpoint)));
    }
}

