/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.operation;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.FilterWrapper;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractOperation
implements Operation,
ExternalizableLite,
PortableObject {
    private Filter m_predicate;
    private transient PartitionSet m_partitions;
    private transient Set<Object> m_setKeys = new HashSet<Object>();
    private boolean m_fAutoCommit;
    private TransactionId m_xid;
    private String m_sTable;
    private String m_sService;
    private boolean m_fSingleKey;

    protected AbstractOperation() {
    }

    public AbstractOperation(String sServiceName) {
        this.m_sService = sServiceName;
    }

    @Override
    public void initialize(Message msg) {
        Filter filter = this.getPredicate();
        if (filter instanceof FilterWrapper) {
            Transaction tx = (Transaction)msg.getContext();
            Session session = tx.getSession();
            FilterWrapper filterWrapper = (FilterWrapper)filter;
            Object oVersion = msg.getBinding("version");
            long lVersion = oVersion == null ? Long.MAX_VALUE : (Long)oVersion;
            filterWrapper.setVersion(lVersion);
            filterWrapper.setCurrentXid(this.getXid());
            filterWrapper.setCurrentXidSynKeys(session.getSyntheticKeyMap().get(this.getTableName()));
        }
    }

    @Override
    public void addKey(Object oKey) {
        if (oKey != null) {
            this.m_setKeys.add(oKey);
        }
        this.m_fSingleKey = this.m_setKeys.size() == 1;
    }

    @Override
    public void addKeys(Set setKeys) {
        if (setKeys != null) {
            this.m_setKeys.addAll(setKeys);
        }
        this.m_fSingleKey = this.m_setKeys.size() == 1;
    }

    protected Object getKey() {
        Set<Object> setKeys = this.m_setKeys;
        Base.azzert(setKeys.size() == 1);
        return setKeys.iterator().next();
    }

    @Override
    public Set getKeys() {
        return this.m_setKeys;
    }

    @Override
    public boolean isSingleKey() {
        return this.m_fSingleKey;
    }

    @Override
    public String getServiceName() {
        return this.m_sService;
    }

    @Override
    public Schema getSchema() {
        return ServiceContext.getContext(this.getServiceName()).getSchema();
    }

    @Override
    public void setTableName(String sTableName) {
        this.m_sTable = sTableName;
    }

    @Override
    public String getTableName() {
        return this.m_sTable;
    }

    @Override
    public void setPredicate(Filter predicate) {
        this.m_predicate = predicate;
    }

    @Override
    public Filter getPredicate() {
        return this.m_predicate;
    }

    @Override
    public void setPartitionSet(PartitionSet partitions) {
        this.m_partitions = partitions;
    }

    @Override
    public PartitionSet getPartitionSet() {
        return this.m_partitions;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public void setAutoCommit(boolean fAuto) {
        this.m_fAutoCommit = fAuto;
    }

    @Override
    public boolean isAutoCommit() {
        return this.m_fAutoCommit;
    }

    @Override
    public void setXid(TransactionId xid) {
        this.m_xid = xid;
    }

    @Override
    public TransactionId getXid() {
        return this.m_xid;
    }

    @Override
    public boolean isA(Operation.Id id) {
        return this.getId() == id || id == Operation.Id.Abstract;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_xid = (TransactionId)((Object)ExternalizableHelper.readExternalizableLite(in));
        this.m_predicate = (Filter)ExternalizableHelper.readObject(in);
        this.m_fAutoCommit = in.readBoolean();
        this.m_sTable = (String)ExternalizableHelper.readObject(in);
        this.m_sService = (String)ExternalizableHelper.readObject(in);
        this.m_fSingleKey = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)((Object)this.m_xid));
        ExternalizableHelper.writeObject(out, this.m_predicate);
        out.writeBoolean(this.m_fAutoCommit);
        ExternalizableHelper.writeObject(out, this.m_sTable);
        ExternalizableHelper.writeObject(out, this.m_sService);
        out.writeBoolean(this.m_fSingleKey);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_xid = (TransactionId)in.readObject(1);
        this.m_predicate = (Filter)in.readObject(2);
        this.m_fAutoCommit = in.readBoolean(3);
        this.m_sTable = in.readString(4);
        this.m_sService = in.readString(5);
        this.m_fSingleKey = in.readBoolean(6);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, this.m_xid);
        out.writeObject(2, this.m_predicate);
        out.writeBoolean(3, this.m_fAutoCommit);
        out.writeString(4, this.m_sTable);
        out.writeString(5, this.m_sService);
        out.writeBoolean(6, this.m_fSingleKey);
    }
}

