/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.router;

import com.tangosol.coherence.transaction.exception.PredicateFailedException;
import com.tangosol.coherence.transaction.exception.RollbackException;
import com.tangosol.coherence.transaction.exception.UnableToAcquireLockException;
import com.tangosol.coherence.transaction.exception.VersionNotAvailableException;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.Transcript;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.router.OutboundRouterImpl;
import com.tangosol.coherence.transaction.internal.storage.Session;
import java.util.List;

public class LocalDirector
extends OutboundRouterImpl {
    @Override
    public Message route(Message msg) {
        Operation op = msg.getOperation();
        Transaction tx = (Transaction)msg.getContext();
        Session session = tx.getSession();
        session.queueOperation(op);
        if (tx.isEager() || !op.isDeferrable() || op.isAutoCommit()) {
            Transcript transcript = session.flushPendingTranscript();
            List<Operation> listOps = transcript.getOperations();
            Message msgResults = msg;
            for (Operation operation : listOps) {
                Message message = new Message(operation);
                message.setContext(msg.getContext());
                msgResults = super.route(message);
                Results r = msgResults.getResults();
                this.checkForException(r);
            }
            return msgResults;
        }
        return msg;
    }

    private void checkForException(Results r) {
        if (r != null && r.hasError()) {
            try {
                throw r.getException();
            }
            catch (PredicateFailedException e) {
                throw new PredicateFailedException(e);
            }
            catch (UnableToAcquireLockException e) {
                throw new UnableToAcquireLockException(e);
            }
            catch (VersionNotAvailableException e) {
                throw new VersionNotAvailableException(e);
            }
            catch (RollbackException e) {
                throw new RollbackException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

