/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import java.util.Enumeration;
import java.util.Map;

public class StorageImpl
implements Storage {
    @Override
    public void write(TableInfo tableInfo, Object oKey, Object oValue, long lVersion) {
        BackingMapManagerContext context = this.getBackingMapContext(tableInfo);
        Map map = this.getBackingMap(context, tableInfo);
        Object binKey = context.getKeyToInternalConverter().convert(oKey);
        Object binVal = context.getValueToInternalConverter().convert(oValue);
        map.put(binKey, context.addInternalValueDecoration(binVal, 3, Base.makeLong(lVersion)));
    }

    @Override
    public Object read(TableInfo tableInfo, Object oKey) {
        Object binKey;
        BackingMapManagerContext context = this.getBackingMapContext(tableInfo);
        Map map = this.getBackingMap(context, tableInfo);
        Object oVal = map.get(binKey = context.getKeyToInternalConverter().convert(oKey));
        return NIL.equals(oVal) ? NIL : context.getValueFromInternalConverter().convert(oVal);
    }

    @Override
    public void remove(TableInfo tableInfo, Object oKey) {
        BackingMapManagerContext context = this.getBackingMapContext(tableInfo);
        Map map = this.getBackingMap(context, tableInfo);
        Object binKey = context.getKeyToInternalConverter().convert(oKey);
        map.remove(binKey);
    }

    @Override
    public boolean contains(TableInfo tableInfo, Object oKey) {
        BackingMapManagerContext context = this.getBackingMapContext(tableInfo);
        Map map = this.getBackingMap(context, tableInfo);
        Object binKey = context.getKeyToInternalConverter().convert(oKey);
        return map.containsKey(binKey);
    }

    @Override
    public void removeLock(TableInfo tableInfo, Object oKey) {
        BackingMapManagerContext context = this.getBackingMapContext(tableInfo);
        Map map = this.getBackingMap(context, tableInfo);
        Object binKey = context.getKeyToInternalConverter().convert(oKey);
        Object binValue = map.get(binKey);
        Object binNoDecVal = context.removeInternalValueDecoration(binValue, 3);
        map.put(binKey, binNoDecVal);
    }

    private BackingMapManagerContext getBackingMapContext(TableInfo tableInfo) {
        Service service = ServiceContext.getContext(tableInfo.getServiceName()).getSchema().getService();
        return ((CacheService)service).getBackingMapManager().getContext();
    }

    private Map getBackingMap(BackingMapManagerContext context, TableInfo tableInfo) {
        String sTable = Schema.getPhysicalValuesTableName(tableInfo.getTableName());
        Map map = context.getBackingMap(sTable);
        if (map == null) {
            Base.log("Unable to acquire backing map for cache: " + sTable + " with service: " + tableInfo.getServiceName());
            Base.log("Known Caches:");
            Enumeration enumCaches = context.getCacheService().getCacheNames();
            while (enumCaches.hasMoreElements()) {
                Base.log("Cache Name: " + enumCaches.nextElement());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            map = context.getBackingMap(sTable);
        }
        return map;
    }
}

