/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.storage.JmxTableStats;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.StorageImpl;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.VersionIndex;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.net.CacheService;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.SimpleMapEntry;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransactionalCache
implements ConfigurableCacheMap {
    private String m_sCache;
    private String m_sService;
    private JmxTableStats m_tableStats;
    private ConfigurableCacheMap m_valuesBackingMap;

    public TransactionalCache(String sCache, String sService, JmxTableStats tableStats) {
        this.m_sCache = sCache;
        this.m_sService = sService;
        this.m_tableStats = tableStats;
        Schema schema = new Schema(this.m_sService);
        String sValuesTable = Schema.getPhysicalValuesTableName(this.m_sCache);
        Map backingMap = ((CacheService)schema.getService()).getBackingMapManager().getContext().getBackingMap(sValuesTable);
        if (backingMap instanceof ConfigurableCacheMap) {
            this.m_valuesBackingMap = (ConfigurableCacheMap)backingMap;
        }
    }

    public Set keySet() {
        return (Set)this.getCollection(CollectionType.KEYS);
    }

    public Collection values() {
        return this.getCollection(CollectionType.VALUES);
    }

    public Set entrySet() {
        return (Set)this.getCollection(CollectionType.ENTRIES);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.keySet().contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values().contains(o);
    }

    public Object get(Object o) {
        for (Object oEnt : this.entrySet()) {
            Map.Entry entry = (Map.Entry)oEnt;
            Object oKey = entry.getKey();
            if (!Base.equals(o, oKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        throw new UnsupportedOperationException("put is not supported.");
    }

    public Object remove(Object o) {
        throw new UnsupportedOperationException("remove is not supported.");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("putAll is not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear is not supported.");
    }

    @Override
    public Map getAll(Collection colKeys) {
        HashMap mapReturn = new HashMap();
        HashSet setKeys = new HashSet(colKeys);
        for (Object o : this.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            Object oKey = entry.getKey();
            if (!setKeys.contains(oKey)) continue;
            mapReturn.put(oKey, entry.getValue());
        }
        return mapReturn;
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        throw new UnsupportedOperationException("put is not supported.");
    }

    @Override
    public int getUnits() {
        return -1;
    }

    @Override
    public int getHighUnits() {
        ConfigurableCacheMap mapBM = this.m_valuesBackingMap;
        return mapBM == null ? -1 : mapBM.getHighUnits();
    }

    @Override
    public void setHighUnits(int cMax) {
        ConfigurableCacheMap mapBM = this.m_valuesBackingMap;
        if (mapBM != null) {
            mapBM.setHighUnits(cMax);
        }
    }

    @Override
    public int getLowUnits() {
        return -1;
    }

    @Override
    public void setLowUnits(int cUnits) {
    }

    @Override
    public int getUnitFactor() {
        return -1;
    }

    @Override
    public void setUnitFactor(int nFactor) {
    }

    @Override
    public void evict(Object oKey) {
    }

    @Override
    public void evictAll(Collection colKeys) {
    }

    @Override
    public void evict() {
    }

    @Override
    public int getExpiryDelay() {
        return -1;
    }

    @Override
    public void setExpiryDelay(int cMillis) {
    }

    @Override
    public int getFlushDelay() {
        return -1;
    }

    @Override
    public void setFlushDelay(int cMillis) {
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        return null;
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        return null;
    }

    @Override
    public void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        ConfigurableCacheMap mapBM = this.m_valuesBackingMap;
        return mapBM == null ? null : mapBM.getUnitCalculator();
    }

    @Override
    public void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        ConfigurableCacheMap mapBM = this.m_valuesBackingMap;
        if (mapBM != null) {
            mapBM.setUnitCalculator(calculator);
        }
    }

    @Override
    public void addMapListener(MapListener listener) {
        throw new UnsupportedOperationException("addMapListener is not supported.");
    }

    @Override
    public void removeMapListener(MapListener listener) {
        throw new UnsupportedOperationException("removeMapListener is not supported.");
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        throw new UnsupportedOperationException("addMapListener is not supported.");
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        throw new UnsupportedOperationException("removeMapListener is not supported.");
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        throw new UnsupportedOperationException("addMapListener is not supported.");
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        throw new UnsupportedOperationException("removeMapListener is not supported.");
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_tableStats;
    }

    protected Collection getCollection(CollectionType type) {
        AbstractCollection colReturn = type == CollectionType.VALUES ? new ArrayList() : new HashSet();
        String sService = this.m_sService;
        LocalMemberState lms = LocalMemberState.getMemberState(sService);
        Collection<LocalPartitionState> colParts = lms.getAllPartitions();
        StorageImpl storage = new StorageImpl();
        boolean nSize = false;
        for (LocalPartitionState oLps : colParts) {
            String sTable;
            LocalPartitionState lps = oLps;
            VersionIndex vi = lps.ensureVersionIndex(sTable = this.m_sCache);
            if (vi == null) continue;
            for (SyntheticKey oSynKey : vi.getAllKeys()) {
                SyntheticKey synKey = oSynKey;
                TransactionId xid = vi.getXid(synKey, Long.MAX_VALUE);
                if (xid == null) continue;
                XidSyntheticKey xidSynKey = new XidSyntheticKey(synKey, xid);
                TableInfoImpl tableInfo = new TableInfoImpl(sTable, sService);
                Object oVal = storage.read(tableInfo, xidSynKey);
                if (Storage.NIL.equals(storage.read(tableInfo, xidSynKey))) continue;
                Object oKey = XidManager.getNaturalKey(xidSynKey, tableInfo);
                switch (type) {
                    case KEYS: {
                        colReturn.add(oKey);
                        break;
                    }
                    case VALUES: {
                        colReturn.add(oVal);
                        break;
                    }
                    case ENTRIES: {
                        colReturn.add(new SimpleMapEntry(oKey, oVal));
                    }
                }
            }
        }
        return type == CollectionType.VALUES ? Collections.unmodifiableCollection(colReturn) : Collections.unmodifiableSet((Set)((Object)colReturn));
    }

    private static enum CollectionType {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

