/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;

public class VersionBackingMapListener
implements MapListener {
    private BackingMapManagerContext m_context;
    private String m_sTable;

    public VersionBackingMapListener(String sTable, BackingMapManagerContext context) {
        this.m_sTable = Schema.getLogicalTableName(sTable);
        this.m_context = context;
    }

    @Override
    public void entryInserted(MapEvent event) {
        boolean fOwned = this.m_context.isKeyOwned(event.getKey());
        if (fOwned) {
            return;
        }
        Binary binKey = (Binary)event.getKey();
        Binary binValue = (Binary)event.getNewValue();
        XidSyntheticKey key = (XidSyntheticKey)this.m_context.getKeyFromInternalConverter().convert(binKey);
        long lVersion = (Long)this.m_context.getValueFromInternalConverter().convert(binValue);
        String sService = this.m_context.getCacheService().getInfo().getServiceName();
        SyntheticKey synKey = new SyntheticKey(key.getKey());
        LocalMemberState lms = LocalMemberState.getMemberState(sService);
        LocalPartitionState lps = lms.getLocalPartitionState(synKey.getPartition());
        lps.ensureVersionIndex(this.m_sTable).addVersion(synKey, key.getXid(), lVersion);
        lms.setCurrentWriteVersion(lVersion);
    }

    @Override
    public void entryUpdated(MapEvent event) {
    }

    @Override
    public void entryDeleted(MapEvent event) {
    }
}

