/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.SparseArray;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VersionDependencyManager {
    private SparseArray m_versions = new SparseArray();
    private Map<TransactionId, Long> m_mapReverseIndex = new HashMap<TransactionId, Long>();
    private final LocalMemberState m_memberState;

    public VersionDependencyManager(LocalMemberState lms) {
        this.m_memberState = lms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addDependency(TransactionId xid) {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            this.removeExistingDependency(xid);
            long lCurrent = this.m_memberState.getCurrentWriteVersion();
            this.addDependency(xid, lCurrent);
            return lCurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(TransactionId xid, long lVersion) {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            HashSet<TransactionId> setXids = (HashSet<TransactionId>)this.m_versions.get(lVersion);
            if (setXids == null) {
                setXids = new HashSet<TransactionId>();
                this.m_versions.set(lVersion, setXids);
            }
            setXids.add(xid);
            this.m_mapReverseIndex.put(xid, Base.makeLong(lVersion));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDependency(TransactionId xid, long lVersion) {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            Long currentVersion = this.m_mapReverseIndex.get(xid);
            if (currentVersion == null) {
                CacheFactory.log("Attempted to update dependency for Xid: " + xid + " but no dependency exists.", 2);
            } else if (currentVersion != lVersion) {
                this.removeExistingDependency(xid);
                this.addDependency(xid, lVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitVersionDependency(TransactionId xid, long lVersion) {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            this.releaseVersionDependency(xid);
            this.m_memberState.setCurrentWriteVersion(lVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseVersionDependency(TransactionId xid) {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            this.removeExistingDependency(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStableVersion() {
        Object object = this.m_memberState.VERSION_LOCK;
        synchronized (object) {
            return this.m_versions.isEmpty() ? this.m_memberState.getCurrentWriteVersion() : this.m_versions.getFirstIndex();
        }
    }

    public boolean containsDependency(TransactionId xid) {
        return this.m_mapReverseIndex.containsKey(xid);
    }

    private void removeExistingDependency(TransactionId xid) {
        Long version = this.m_mapReverseIndex.get(xid);
        if (version != null) {
            Set setXids = (Set)this.m_versions.get(version);
            if (setXids != null) {
                if (setXids.size() == 1) {
                    this.m_versions.remove(version);
                } else {
                    setXids.remove(xid);
                }
            }
            this.m_mapReverseIndex.remove(xid);
        }
    }
}

