/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.exception.UnableToAcquireLockException;
import com.tangosol.coherence.transaction.exception.VersionNotAvailableException;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class VersionIndex {
    private final Map<SyntheticKey, VersionLog> m_mapLogs = new ConcurrentHashMap<SyntheticKey, VersionLog>();
    private String m_sTable;

    public VersionIndex(String sTable) {
        this.m_sTable = sTable;
    }

    public void addVersion(SyntheticKey syntheticKey, TransactionId xid, long lVersion) {
        this.ensureVersionLog(syntheticKey).addVersion(lVersion, xid);
    }

    public Set<XidSyntheticKey> pruneVersions(long lCeiling) {
        HashSet<XidSyntheticKey> setPrunedKeys = new HashSet<XidSyntheticKey>();
        for (VersionLog log : this.m_mapLogs.values()) {
            setPrunedKeys.addAll(log.prune(lCeiling));
        }
        return setPrunedKeys;
    }

    public long getOldestHistoricalVersion() {
        long lMin = Long.MAX_VALUE;
        for (VersionLog log : this.m_mapLogs.values()) {
            long lMinTemp = log.getOldestHistoricalVersion();
            lMin = lMinTemp < 0L ? lMin : Math.min(lMin, lMinTemp);
        }
        return lMin;
    }

    public Set<SyntheticKey> getAllKeys() {
        return new HashSet<SyntheticKey>(this.m_mapLogs.keySet());
    }

    public TransactionId getXid(SyntheticKey syntheticKey, long lVersion) {
        return this.ensureVersionLog(syntheticKey).getXid(lVersion);
    }

    public TransactionId getPreviousXid(SyntheticKey syntheticKey, TransactionId xid) {
        VersionLog log = this.m_mapLogs.get(syntheticKey);
        return log == null ? null : log.getPreviousXid(xid);
    }

    public boolean setWriteLock(SyntheticKey syntheticKey, TransactionId lockOwner) {
        return this.ensureVersionLog(syntheticKey).setWriteLock(lockOwner);
    }

    public void releaseWriteLock(SyntheticKey syntheticKey) {
        this.ensureVersionLog(syntheticKey).releaseWriteLock();
    }

    public TransactionId getLockOwner(SyntheticKey syntheticKey) {
        return syntheticKey == null ? null : this.ensureVersionLog(syntheticKey).getLockOwner();
    }

    public String getTable() {
        return this.m_sTable;
    }

    public boolean isInitialKey(XidSyntheticKey key) {
        return key.getXid().equals(this.ensureVersionLog(new SyntheticKey(key.getKey())).getInitialXid());
    }

    private synchronized VersionLog ensureVersionLog(SyntheticKey syntheticKey) {
        VersionLog versionLog = this.m_mapLogs.get(syntheticKey);
        if (versionLog == null) {
            versionLog = new VersionLog(syntheticKey);
            this.m_mapLogs.put(syntheticKey, versionLog);
        }
        return versionLog;
    }

    public class VersionLog {
        private SyntheticKey m_key;
        private TransactionId m_xidWriteLockOwner;
        private LongArray m_versions = new SparseArray();
        private long m_lInitialVersion = Long.MAX_VALUE;
        private TransactionId m_initialXid;

        public VersionLog(SyntheticKey key) {
            this.m_key = key;
        }

        private synchronized TransactionId getXid(long lVersion) {
            LongArray.Iterator iterReverse = null;
            try {
                iterReverse = this.m_versions.reverseIterator(lVersion);
            }
            catch (NoSuchElementException e) {
                this.checkVersionPruned(lVersion);
            }
            if (iterReverse.hasNext()) {
                return (TransactionId)iterReverse.next();
            }
            this.checkVersionPruned(lVersion);
            return null;
        }

        private void checkVersionPruned(long lVersion) {
            if (this.didGcOccur() && lVersion >= this.m_lInitialVersion) {
                throw new VersionNotAvailableException();
            }
        }

        private boolean didGcOccur() {
            return this.m_lInitialVersion != Long.MAX_VALUE && !this.m_versions.exists(this.m_lInitialVersion);
        }

        private synchronized TransactionId getPreviousXid(TransactionId xid) {
            try {
                LongArray.Iterator iterReverse = this.m_versions.reverseIterator(this.getCurrentVersion());
                while (iterReverse.hasNext()) {
                    TransactionId xidCur = (TransactionId)iterReverse.next();
                    if (!xid.equals(xidCur)) continue;
                    if (iterReverse.hasNext()) {
                        return (TransactionId)iterReverse.next();
                    }
                    return null;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        }

        private synchronized long getCurrentVersion() {
            return this.m_versions.getLastIndex();
        }

        private synchronized long getOldestHistoricalVersion() {
            return this.m_versions.getFirstIndex();
        }

        private synchronized void addVersion(long lVersion, TransactionId xid) {
            Object o;
            if (lVersion < this.m_lInitialVersion) {
                this.m_lInitialVersion = lVersion;
                this.m_initialXid = xid;
            }
            if (lVersion >= 0L && (o = this.m_versions.set(lVersion, xid)) != null && !o.equals(xid)) {
                CacheFactory.log("Overwrite of existing version entry", 1);
            }
        }

        private synchronized Set<XidSyntheticKey> prune(long lCeiling) {
            HashSet<XidSyntheticKey> setRemoved = new HashSet<XidSyntheticKey>();
            LongArray.Iterator iter = this.m_versions.iterator();
            while (iter.hasNext()) {
                TransactionId xid = (TransactionId)iter.next();
                long i = iter.getIndex();
                if (i > lCeiling || i == this.getCurrentVersion()) break;
                iter.remove();
                setRemoved.add(new XidSyntheticKey(this.m_key, xid));
            }
            return setRemoved;
        }

        private boolean setWriteLock(TransactionId lockOwner) {
            if (this.m_xidWriteLockOwner == null) {
                this.m_xidWriteLockOwner = lockOwner;
                return true;
            }
            if (this.m_xidWriteLockOwner.equals(lockOwner)) {
                return false;
            }
            throw new UnableToAcquireLockException("Unable to acquire write lock.");
        }

        private TransactionId getLockOwner() {
            return this.m_xidWriteLockOwner;
        }

        private void releaseWriteLock() {
            this.m_xidWriteLockOwner = null;
        }

        private TransactionId getInitialXid() {
            return this.m_initialXid;
        }
    }
}

