/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import com.tangosol.coherence.transaction.internal.xa.XAResourceAction;
import javax.transaction.xa.XAException;

public class TxBranchState {
    public static final TxBranchStateValue INITIAL_ST = new TxBranchStateValue("initial");
    public static final TxBranchStateValue ACTIVE_ST = new TxBranchStateValue("active");
    public static final TxBranchStateValue IDLE_ST = new TxBranchStateValue("idle");
    public static final TxBranchStateValue SUSPENDED_ST = new TxBranchStateValue("suspended");
    public static final TxBranchStateValue PREPARED_ST = new TxBranchStateValue("prepared");
    public static final TxBranchStateValue ERROR_ST = new TxBranchStateValue("error");
    private TxBranchStateValue m_currentState = INITIAL_ST;
    private static final TxBranchStateValue[] m_states = new TxBranchStateValue[]{INITIAL_ST, ACTIVE_ST, IDLE_ST, SUSPENDED_ST, PREPARED_ST, ERROR_ST};
    private static final TxBranchStateValue[][] m_stateTable = new TxBranchStateValue[][]{{ERROR_ST, ACTIVE_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, ERROR_ST, ERROR_ST, ACTIVE_ST, ERROR_ST, ERROR_ST}, {ACTIVE_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, IDLE_ST, IDLE_ST, IDLE_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, SUSPENDED_ST, ERROR_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {ERROR_ST, IDLE_ST, IDLE_ST, IDLE_ST, ERROR_ST, ERROR_ST}, {INITIAL_ST, INITIAL_ST, INITIAL_ST, INITIAL_ST, INITIAL_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, PREPARED_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, INITIAL_ST, ERROR_ST, PREPARED_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, ERROR_ST, ERROR_ST, INITIAL_ST, ERROR_ST}, {INITIAL_ST, ERROR_ST, INITIAL_ST, INITIAL_ST, INITIAL_ST, ERROR_ST}};

    public TxBranchState(TxBranchStateValue initialState) {
        this.m_currentState = initialState;
    }

    public final boolean isPrepared() {
        return this.m_currentState == PREPARED_ST;
    }

    public final boolean isActive() {
        return this.m_currentState == ACTIVE_ST || this.m_currentState == IDLE_ST || this.m_currentState == SUSPENDED_ST;
    }

    public void registerAction(XAResourceAction action) throws XAException {
        TxBranchStateValue txStateValue = this.m_currentState;
        this.m_currentState = m_stateTable[action.getOrdinal()][txStateValue.getOrdinal()];
        if (this.m_currentState == ERROR_ST) {
            XAException xaException = new XAException(this.handleInvalidAction(action, txStateValue));
            xaException.errorCode = -6;
            throw xaException;
        }
    }

    public TxBranchStateValue getState() {
        return this.m_currentState;
    }

    private String handleInvalidAction(XAResourceAction action, TxBranchStateValue txStateValue) {
        return "TxBranchState : invalid action " + action.toString() + " in " + txStateValue.toString() + " state.";
    }

    public static class TxBranchStateValue {
        private static int m_nextOrdinal = 0;
        private int m_ordinal = m_nextOrdinal++;
        private String m_stateName;

        private TxBranchStateValue(String stateName) {
            this.m_stateName = stateName;
        }

        private int getOrdinal() {
            return this.m_ordinal;
        }

        public String toString() {
            return this.m_stateName;
        }
    }
}

