/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import javax.transaction.xa.XAException;

public class XAResourceAction {
    public static final XAResourceAction START_JOIN = new XAResourceAction("start(join)");
    public static final XAResourceAction START_RESUME = new XAResourceAction("start(resume)");
    public static final XAResourceAction START_NOFLAGS = new XAResourceAction("start(noflags)");
    public static final XAResourceAction END_FAIL = new XAResourceAction("end(fail)");
    public static final XAResourceAction END_SUSPEND = new XAResourceAction("end(suspend)");
    public static final XAResourceAction END_SUCCESS = new XAResourceAction("end(success)");
    public static final XAResourceAction FORGET = new XAResourceAction("forget");
    public static final XAResourceAction PREPARE = new XAResourceAction("prepare");
    public static final XAResourceAction PREPARE_RDONLY = new XAResourceAction("prepare read only");
    public static final XAResourceAction COMMIT_1PC = new XAResourceAction("commit 1pc");
    public static final XAResourceAction COMMIT_2PC = new XAResourceAction("commit 2pc");
    public static final XAResourceAction ROLLBACK = new XAResourceAction("rollback");
    private static int m_nextOrdinal = 0;
    private int m_ordinal = m_nextOrdinal++;
    private String m_valueName;

    int getOrdinal() {
        return this.m_ordinal;
    }

    public String toString() {
        return this.m_valueName;
    }

    private XAResourceAction(String valueName) {
        this.m_valueName = valueName;
    }

    protected static XAResourceAction actionFromXAResourceStartFlags(int flags) throws XAException {
        if (flags == 0) {
            return START_NOFLAGS;
        }
        if ((flags & 0x200000) != 0) {
            return START_JOIN;
        }
        if ((flags & 0x8000000) != 0) {
            return START_RESUME;
        }
        XAException xaException = new XAException("Invalid flag: One of TMNOFLAGS, TMJOIN, or TMRESUME must be used. ");
        xaException.errorCode = -5;
        throw xaException;
    }

    protected static XAResourceAction actionFromXAResourceEndFlags(int flags) throws XAException {
        if ((flags & 0x4000000) != 0) {
            return END_SUCCESS;
        }
        if ((flags & 0x2000000) != 0) {
            return END_SUSPEND;
        }
        if ((flags & 0x20000000) != 0) {
            return END_FAIL;
        }
        XAException xaException = new XAException("Invalid flag: One of TMSUCCESS, TMFAIL, or TMSUSPEND must be used. ");
        xaException.errorCode = -5;
        throw xaException;
    }
}

