/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.RefConstant;
import com.tangosol.dev.assembler.SignatureConstant;

public class FieldConstant
extends RefConstant
implements Constants {
    private static final String CLASS = "FieldConstant";
    private char m_chType;

    protected FieldConstant() {
        super(9);
    }

    public FieldConstant(String sClass, String sName, String sType) {
        super(9, sClass, sName, sType);
    }

    public FieldConstant(ClassConstant constantClz, SignatureConstant constantSig) {
        super(9, constantClz, constantSig);
    }

    @Override
    public String toString() {
        return "(Field)->" + super.toString();
    }

    @Override
    public String format() {
        int of;
        String sClass = this.getClassConstant().format();
        if (sClass.startsWith("java") && (of = sClass.lastIndexOf(46)) != -1) {
            sClass = sClass.substring(of + 1);
        }
        sClass = sClass.replace('$', '.');
        SignatureConstant sig = this.getSignatureConstant();
        String sName = sig.getName();
        String sType = sig.getType();
        int of2 = (sType = Field.toTypeString(sType)).lastIndexOf(46);
        if (of2 != -1) {
            sType = sType.substring(of2 + 1);
        }
        sType = sType.replace('$', '.');
        return sClass + '.' + sName + " (" + sType + ')';
    }

    public static char getVariableType(String sType) {
        if (sType.length() == 1) {
            char ch = sType.charAt(0);
            switch (ch) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    return 'I';
                }
                case 'J': {
                    return 'L';
                }
                case 'F': {
                    return 'F';
                }
                case 'D': {
                    return 'D';
                }
                case 'V': {
                    return '\u0000';
                }
            }
            throw new IllegalStateException("FieldConstantIllegal type=" + ch);
        }
        return 'A';
    }

    public char getVariableType() {
        char chType = this.m_chType;
        if (chType == '\u0000') {
            this.m_chType = chType = FieldConstant.getVariableType(this.getType());
        }
        return chType;
    }

    public int getVariableSize() {
        return OpDeclare.getWidth(this.getVariableType());
    }
}

