/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SignatureAttribute
extends Attribute
implements Constants {
    private UtfConstant m_utfSignature;
    private boolean m_fModified;

    protected SignatureAttribute(VMStructure context) {
        super(context, "Signature");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_utfSignature = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        pool.registerConstant(this.m_utfSignature);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2);
        stream.writeShort(pool.findConstant(this.m_utfSignature));
    }

    @Override
    public String toString() {
        return super.getName() + '=' + this.m_utfSignature;
    }

    public String getSignature() {
        return this.m_utfSignature.getValue();
    }

    public void setSignature(String sSignature) {
        this.m_utfSignature = new UtfConstant(sSignature);
        this.m_fModified = true;
    }

    public UtfConstant getSignatureConstant() {
        return this.m_utfSignature;
    }

    @Override
    public boolean isModified() {
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }
}

