/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Areturn;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.Dreturn;
import com.tangosol.dev.assembler.Dstore;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.Freturn;
import com.tangosol.dev.assembler.Fstore;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.Ireturn;
import com.tangosol.dev.assembler.Istore;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.Lreturn;
import com.tangosol.dev.assembler.Lstore;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpLoad;
import com.tangosol.dev.assembler.OpStore;
import com.tangosol.dev.assembler.Return;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.ExitStatement;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.FinallyClause;
import com.tangosol.dev.compiler.java.GuardedStatement;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ReturnStatement
extends ExitStatement {
    private static final String CLASS = "ReturnStatement";

    public ReturnStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression value = this.getExpression();
        DataType dtReturn = ctx.getMethodInfo().getDataType();
        if (value == null) {
            if (dtReturn != DataType.VOID) {
                this.logError(3, "JC-007", null, errlist);
            }
        } else {
            value = (Expression)value.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            if (dtReturn == DataType.VOID) {
                this.logError(3, "JC-006", null, errlist);
            } else if (value.checkAssignable(ctx, dtReturn, null)) {
                value = value.convertAssignable(ctx, dtReturn);
            } else {
                value.logError(3, "JC-008", new String[]{value.getType().toString(), dtReturn.toString()}, errlist);
            }
            this.setExpression(value);
        }
        setUVars.clear();
        setFVars.clear();
        return this;
    }

    @Override
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression value = this.getExpression();
        int chType = 86;
        if (value != null) {
            chType = value.getType().getTypeString().charAt(0);
        }
        OpDeclare opDecl = null;
        OpStore opStore = null;
        OpLoad opLoad = null;
        Op opReturn = null;
        switch (chType) {
            case 86: {
                opReturn = new Return();
                break;
            }
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                opDecl = new Ivar();
                opStore = new Istore((Ivar)opDecl);
                opLoad = new Iload((Ivar)opDecl);
                opReturn = new Ireturn();
                break;
            }
            case 74: {
                opDecl = new Lvar();
                opStore = new Lstore((Lvar)opDecl);
                opLoad = new Lload((Lvar)opDecl);
                opReturn = new Lreturn();
                break;
            }
            case 70: {
                opDecl = new Fvar();
                opStore = new Fstore((Fvar)opDecl);
                opLoad = new Fload((Fvar)opDecl);
                opReturn = new Freturn();
                break;
            }
            case 68: {
                opDecl = new Dvar();
                opStore = new Dstore((Dvar)opDecl);
                opLoad = new Dload((Dvar)opDecl);
                opReturn = new Dreturn();
                break;
            }
            case 76: 
            case 78: 
            case 82: 
            case 91: {
                opDecl = new Avar();
                opStore = new Astore((Avar)opDecl);
                opLoad = new Aload((Avar)opDecl);
                opReturn = new Areturn();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (value != null) {
            value.compile(ctx, code, fReached, errlist);
        }
        Statement prev = null;
        boolean fUnwind = false;
        for (Statement stmt = this.getOuterStatement(); stmt != null; stmt = stmt.getOuterStatement()) {
            Label lblUnwind;
            if (stmt instanceof GuardedStatement && !(prev instanceof FinallyClause) && (lblUnwind = ((GuardedStatement)stmt).getUnwindLabel()) != null) {
                if (!fUnwind && opStore != null) {
                    code.add(new Begin());
                    code.add(opDecl);
                    code.add(opStore);
                }
                code.add(new Jsr(lblUnwind));
                fUnwind = true;
            }
            prev = stmt;
        }
        if (fUnwind && opLoad != null) {
            code.add(opLoad);
            code.add(new End());
        }
        code.add(opReturn);
        return false;
    }
}

