/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Loader;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ComponentClassLoader
extends ClassLoader {
    private static final String TAPS_LOADER = "com.tangosol.tde.component.dev.service.TAPSLoader";
    private static final boolean DEBUG = false;
    private static final String CLASS_PREFIX = "_package/".replace('/', '.');
    private static final String RESOURCE_PREFIX = "_package/";
    private Loader m_loader;
    private Hashtable m_tblClasses = new Hashtable();
    private Hashtable m_tblResources = new Hashtable();

    public ComponentClassLoader(Loader loader) {
        this(null, loader);
    }

    public ComponentClassLoader(ClassLoader parent, Loader loader) {
        super(ComponentClassLoader.ensureParent(parent));
        if (loader == null) {
            throw new IllegalArgumentException("The loader must be specified");
        }
        this.m_loader = loader;
    }

    public Loader getLoader() {
        return this.m_loader;
    }

    protected Class loadClass(String sName, boolean fResolve) throws ClassNotFoundException {
        byte[] ab = null;
        if (!this.isSystemClass(sName)) {
            try {
                ab = this.loadClassData(sName);
            }
            catch (ComponentException e) {
                throw new ClassNotFoundException(sName, e);
            }
        }
        if (ab == null) {
            if (sName.startsWith(CLASS_PREFIX)) {
                throw new ClassNotFoundException(sName);
            }
            return super.loadClass(sName, fResolve);
        }
        try {
            Class<?> clz = this.defineClass(sName, ab, 0, ab.length);
            if (fResolve) {
                this.resolveClass(clz);
            }
            return clz;
        }
        catch (Throwable e) {
            return super.loadClass(sName, fResolve);
        }
    }

    @Override
    public InputStream getResourceAsStream(String sName) {
        byte[] ab;
        try {
            ab = this.loadResourceData(sName);
        }
        catch (IOException e) {
            return null;
        }
        if (ab == null) {
            if (sName.startsWith(RESOURCE_PREFIX)) {
                return null;
            }
            return super.getResourceAsStream(sName);
        }
        return new ByteArrayInputStream(ab);
    }

    public byte[] loadClassData(String sName) throws ComponentException {
        ClassFile clsf;
        byte[] ab = (byte[])this.m_tblClasses.get(sName);
        if (ab == null && (clsf = this.m_loader.loadClass(sName)) != null) {
            ab = clsf.getBytes();
            this.m_tblClasses.put(sName, ab);
        }
        return ab;
    }

    public byte[] loadResourceData(String sName) throws IOException {
        byte[] ab = (byte[])this.m_tblResources.get(sName);
        if (ab == null && (ab = this.m_loader.loadResource(sName)) != null) {
            this.m_tblResources.put(sName, ab);
        }
        return ab;
    }

    static ClassLoader ensureParent(ClassLoader parent) {
        if (parent == null && (parent = ComponentClassLoader.class.getClassLoader()) == null) {
            parent = ComponentClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    protected boolean isSystemClass(String sName) {
        return sName.startsWith("java") || sName.startsWith("sun") || sName.startsWith("com.sun") || sName.startsWith("com.tangosol") || sName.startsWith("com.xtangosol");
    }

    public static void main(String[] asArg) throws Exception {
        int cArgs = asArg.length;
        Base.azzert(cArgs > 0, "Class name must be specified");
        Class<?> clzTapsLoader = Class.forName(TAPS_LOADER);
        Loader loader = (Loader)clzTapsLoader.newInstance();
        ClassHelper.invoke(loader, "configureStorage", ClassHelper.VOID);
        ComponentClassLoader cl = new ComponentClassLoader(loader);
        Class<?> clzMain = cl.loadClass(asArg[0]);
        if (--cArgs > 0) {
            String[] as = new String[cArgs];
            System.arraycopy(asArg, 1, as, 0, cArgs);
            asArg = as;
        } else {
            asArg = new String[]{};
        }
        Thread.currentThread().setContextClassLoader(cl);
        ClassHelper.invokeStatic(clzMain, "main", new Object[]{asArg});
    }
}

