/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Collator;
import java.util.Enumeration;

public class Interface
extends Trait
implements Constants {
    private static final String CLASS = "Interface";
    public static final int IMPLEMENTS = 1;
    public static final int DISPATCHES = 2;
    protected static final String DESCRIPTOR_IMPLEMENTS = "Implements";
    protected static final String DESCRIPTOR_DISPATCHES = "Dispatches";
    private String[] DESCRIPTORS = new String[]{"<invalid>", "Implements", "Dispatches"};
    private int m_nType;
    private String m_sName;
    private StringTable m_tblBehavior;
    private StringTable m_tblState;

    protected Interface(Component cd, String sName, int nType, Enumeration enmrBehavior, Enumeration enmrState) {
        super((Trait)cd, 1);
        StringTable tbl;
        if (cd == null) {
            throw new IllegalArgumentException("Interface:  Containing Component required.");
        }
        if (sName == null || sName.length() == 0) {
            throw new IllegalArgumentException("Interface:  Invalid interface name (" + sName + ")");
        }
        if (nType != 1 && nType != 2) {
            throw new IllegalArgumentException("Interface:  Invalid interface type (" + nType + ")");
        }
        this.m_sName = sName;
        this.m_nType = nType;
        if (enmrBehavior == null) {
            tbl = null;
        } else {
            tbl = new StringTable();
            while (enmrBehavior.hasMoreElements()) {
                String sBhvr = (String)enmrBehavior.nextElement();
                if (Behavior.isConstructor(sBhvr)) continue;
                tbl.add(sBhvr);
            }
        }
        this.m_tblBehavior = tbl;
        if (enmrState == null) {
            tbl = null;
        } else {
            tbl = new StringTable();
            while (enmrState.hasMoreElements()) {
                tbl.add((String)enmrState.nextElement());
            }
        }
        this.m_tblState = tbl;
    }

    protected Interface(Component cd, Component cdJCS, boolean fDispatch) {
        this(cd, cdJCS.getName(), fDispatch ? 2 : 1, new SimpleEnumerator(cdJCS.getBehavior()), new SimpleEnumerator(cdJCS.getProperty()));
        if (!cdJCS.isInterface()) {
            throw new IllegalArgumentException("Interface:  Interface type required!");
        }
        if (fDispatch) {
            String sIface = this.m_sName;
            String sClass = DataType.getClassType(sIface).getTypeString();
            String sSig = sIface.substring(sIface.lastIndexOf(46) + 1) + '(' + sClass + ')';
            StringTable tbl = this.m_tblBehavior;
            tbl.add("add" + sSig);
            tbl.add("remove" + sSig);
        }
    }

    protected Interface(Component cd, Class clz) {
        this(cd, clz.getName(), 1, NullImplementation.getEnumeration(), NullImplementation.getEnumeration());
        if (!clz.isInterface()) {
            throw new IllegalArgumentException("Interface:  Interface type required!");
        }
    }

    protected Interface(Component cdJCS, String sInterface) {
        this(cdJCS, sInterface, 1, null, null);
        if (!cdJCS.isSignature()) {
            throw new IllegalArgumentException("Interface:  Java Class Signature required!");
        }
    }

    protected Interface(Interface base, Component cd, int nMode) {
        super((Trait)base, cd, nMode);
    }

    protected Interface(Component cd, Interface that) {
        super((Trait)cd, that);
        this.m_nType = that.m_nType;
        this.m_sName = that.m_sName;
        this.m_tblBehavior = that.m_tblBehavior;
        this.m_tblState = that.m_tblState;
    }

    protected Interface(Component cd, DataInput stream, int nVersion) throws IOException {
        super((Trait)cd, stream, nVersion);
        this.m_sName = stream.readUTF();
        this.m_nType = stream.readInt();
        if (stream.readBoolean()) {
            int i;
            StringTable tbl = new StringTable();
            int c = stream.readInt();
            for (i = 0; i < c; ++i) {
                tbl.add(stream.readUTF());
            }
            this.m_tblBehavior = tbl;
            tbl = new StringTable();
            c = stream.readInt();
            for (i = 0; i < c; ++i) {
                tbl.add(stream.readUTF());
            }
            this.m_tblState = tbl;
        }
    }

    protected Interface(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sName = Interface.readString(xml.getElement("name"));
        String sType = Interface.readString(xml.getElement("type"));
        if (sName == "" || sType == "") {
            throw new IOException("name or type is missing");
        }
        this.m_sName = sName;
        int c = this.DESCRIPTORS.length;
        for (int i = 1; i < c; ++i) {
            if (!this.DESCRIPTORS[i].equalsIgnoreCase(sType)) continue;
            this.m_nType = i;
            break;
        }
        if (this.m_nType < 1) {
            throw new IOException("illegal type: " + sType);
        }
        this.m_tblBehavior = Interface.readTableKeys(xml, "methods", "method");
        this.m_tblState = Interface.readTableKeys(xml, "fields", "field");
        if (this.m_tblBehavior != null || this.m_tblState != null) {
            if (this.m_tblBehavior == null) {
                this.m_tblBehavior = new StringTable();
            }
            if (this.m_tblState == null) {
                this.m_tblState = new StringTable();
            }
        }
    }

    @Override
    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_sName);
        stream.writeInt(this.m_nType);
        boolean fCached = this.m_tblBehavior != null && this.m_tblState != null;
        stream.writeBoolean(fCached);
        if (fCached) {
            stream.writeInt(this.m_tblBehavior.getSize());
            Enumeration enmr = this.m_tblBehavior.keys();
            while (enmr.hasMoreElements()) {
                stream.writeUTF((String)enmr.nextElement());
            }
            stream.writeInt(this.m_tblState.getSize());
            enmr = this.m_tblState.keys();
            while (enmr.hasMoreElements()) {
                stream.writeUTF((String)enmr.nextElement());
            }
        }
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("name").setString(this.m_sName);
        xml.addElement("type").setString(this.DESCRIPTORS[this.m_nType]);
        super.save(xml);
        Interface.saveTableKeys(xml, this.m_tblBehavior, "methods", "method");
        Interface.saveTableKeys(xml, this.m_tblState, "fields", "field");
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Interface(this, (Component)parent, nMode);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Interface base = this;
        Interface delta = (Interface)this.resolveDelta(traitDelta, loader, errlist);
        Interface derived = (Interface)super.resolve(delta, parent, loader, errlist);
        derived.m_nType = base.m_nType;
        derived.m_sName = base.m_sName;
        derived.m_tblBehavior = base.m_tblBehavior;
        derived.m_tblState = base.m_tblState;
        return derived;
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Interface base = (Interface)traitBase;
        Interface delta = (Interface)super.extract(base, parent, loader, errlist);
        delta.m_nType = base.m_nType;
        delta.m_sName = base.m_sName;
        delta.m_tblBehavior = base.m_tblBehavior;
        delta.m_tblState = base.m_tblState;
        return delta;
    }

    @Override
    protected synchronized void finalizeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeExtract(loader, errlist);
        this.m_tblState = null;
        this.m_tblBehavior = null;
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sName = null;
        this.m_tblBehavior = null;
        this.m_tblState = null;
    }

    @Override
    protected String getUniqueName() {
        return this.m_sName;
    }

    @Override
    protected String getUniqueDescription() {
        return this.DESCRIPTORS[this.m_nType] + ' ' + this.getUniqueName();
    }

    public Component getComponent() {
        return (Component)this.getParentTrait();
    }

    public int getType() {
        return this.m_nType;
    }

    public String getName() {
        return this.m_sName;
    }

    public Enumeration getBehaviors() {
        return this.m_tblBehavior.keys();
    }

    public Enumeration getProperties() {
        return this.m_tblState.keys();
    }

    public static String getDispatchesVerb(String sSig) {
        Collator INSENS = Constants.INSENS;
        String REG = "add";
        String UNREG = "remove";
        if (INSENS.equals(sSig.substring(0, 3), "add")) {
            return "add";
        }
        if (sSig.length() > 6 && INSENS.equals(sSig.substring(0, 6), "remove")) {
            return "remove";
        }
        return null;
    }

    public static String getDispatchesName(String sSig) {
        String sVerb = Interface.getDispatchesVerb(sSig);
        if (sVerb == null) {
            return null;
        }
        String sIface = sSig.substring(sVerb.length(), sSig.indexOf(40));
        if (sIface.length() <= 0) {
            return null;
        }
        String SUFFIX = "Listener";
        int cchName = sIface.length() - "Listener".length();
        if (cchName <= 0) {
            return null;
        }
        String sEnd = sIface.substring(cchName);
        if (INSENS.equals(sEnd, "Listener")) {
            return sIface.substring(0, cchName);
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Interface) {
            Interface that = (Interface)obj;
            return this == that || this.m_nType == that.m_nType && this.m_sName.equals(that.m_sName) && (this.m_tblBehavior == null ? that.m_tblBehavior == null : this.m_tblBehavior.equals(that.m_tblBehavior)) && (this.m_tblState == null ? that.m_tblState == null : this.m_tblState.equals(that.m_tblState)) && super.equals(that);
        }
        return false;
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        out.println(sIndent + this.toString());
        super.dump(out, sIndent);
        String sBehavior = this.m_tblBehavior == null ? "<null>" : this.m_tblBehavior.toString();
        String sState = this.m_tblState == null ? "<null>" : this.m_tblState.toString();
        out.println(sIndent + "Behavior:  " + sBehavior);
        out.println(sIndent + "State:  " + sState);
    }
}

