/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.ClassConstant;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.NameTypeConstant;
import java.io.DataInput;
import java.io.IOException;

public class RefConstant
extends Constant {
    private int m_iClass;
    private int m_iNameType;

    public RefConstant(DataInput stream) throws IOException {
        this.m_iClass = stream.readUnsignedShort();
        this.m_iNameType = stream.readUnsignedShort();
    }

    public int getClassIndex() {
        return this.m_iClass;
    }

    public int getNameTypeIndex() {
        return this.m_iNameType;
    }

    public String getClassName() {
        return ((ClassConstant)this.m_aconst[this.m_iClass]).getName();
    }

    public String getRefName() {
        return ((NameTypeConstant)this.m_aconst[this.m_iNameType]).getName();
    }

    public String getSignature() {
        return ((NameTypeConstant)this.m_aconst[this.m_iNameType]).getSignature();
    }

    public String toString() {
        String s = null;
        switch (this.m_nType) {
            case 9: {
                s = "Field";
                break;
            }
            case 10: {
                s = "Method";
                break;
            }
            case 11: {
                s = "Interface Method";
            }
        }
        return s + ":  Class Index=" + this.m_iClass + " (" + RefConstant.format(this.getClassName()) + ")" + ", Name/Type Index=" + this.m_iNameType + " (" + RefConstant.format(this.getRefName()) + "/" + RefConstant.format(this.getSignature()) + ")";
    }
}

