/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.component.ComponentClassLoader;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.packager.ClassReference;
import com.tangosol.util.Base;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;

public abstract class ConstantPoolEntry
extends Base {
    static final int CONSTANT_UTF8 = 1;
    static final int CONSTANT_UNICODE = 2;
    static final int CONSTANT_INTEGER = 3;
    static final int CONSTANT_FLOAT = 4;
    static final int CONSTANT_LONG = 5;
    static final int CONSTANT_DOUBLE = 6;
    static final int CONSTANT_CLASS = 7;
    static final int CONSTANT_STRING = 8;
    static final int CONSTANT_FIELDREF = 9;
    static final int CONSTANT_METHODREF = 10;
    static final int CONSTANT_INTERFACE_METHODREF = 11;
    static final int CONSTANT_NAME_AND_TYPE = 12;
    byte tag;
    ConstantPoolEntry[] pool;
    Object referencedObject;

    public Object getReferencedObject() {
        return this.referencedObject;
    }

    /*
     * Unable to fully structure code
     */
    public static ConstantPoolEntry[] getClassConstants(String javaClassName, ClassLoader classLoader) throws IOException {
        if (javaClassName.startsWith("L") && javaClassName.endsWith(";")) {
            javaClassName = javaClassName.substring(1, javaClassName.length() - 1);
        }
        in = null;
        if (classLoader instanceof ComponentClassLoader) {
            try {
                ab = ((ComponentClassLoader)classLoader).loadClassData(javaClassName);
                if (ab == null) ** GOTO lbl14
                in = new ByteArrayInputStream(ab);
            }
            catch (ComponentException e) {
                throw new IOException(e.toString());
            }
        } else {
            resourcePath = javaClassName.replace('.', '/') + ".class";
            in = classLoader.getResourceAsStream(resourcePath);
        }
lbl14:
        // 3 sources

        if (in == null) {
            throw new IOException("Cannot find class: " + javaClassName);
        }
        dstream = new DataInputStream(in);
        magicNumber = dstream.readInt();
        if (magicNumber != -889275714) {
            throw new RuntimeException(javaClassName + ": Bad class-file magic number: " + Integer.toString(magicNumber, 16));
        }
        minorVersion = dstream.readUnsignedShort();
        majorVersion = dstream.readUnsignedShort();
        constantPoolCount = dstream.readUnsignedShort();
        constantPool = new ConstantPoolEntry[constantPoolCount];
        constantPool[0] = null;
        for (i = 1; i < constantPoolCount; ++i) {
            try {
                tag = (byte)dstream.readUnsignedByte();
                constantPool[i] = ConstantPoolEntry.decode(tag, dstream, constantPool);
                if (tag != 5 && tag != 6) continue;
                constantPool[++i] = null;
                continue;
            }
            catch (IOException e) {
                ConstantPoolEntry.out(javaClassName + ": constantPool[" + i + "]: " + e.getMessage());
                ConstantPoolEntry.out(e);
            }
        }
        for (i = 1; i < constantPoolCount; ++i) {
            if (constantPool[i] == null) continue;
            constantPool[i].resolve();
        }
        dstream.close();
        in.close();
        return constantPool;
    }

    final byte getTag() {
        return this.tag;
    }

    void resolve() {
    }

    protected ConstantPoolEntry(byte tag, ConstantPoolEntry[] pool) {
        this.tag = tag;
        this.pool = pool;
    }

    static ConstantPoolEntry decode(byte tag, DataInputStream dstream, ConstantPoolEntry[] pool) throws IOException {
        switch (tag) {
            case 7: {
                return new ConstantClass(tag, pool, dstream.readUnsignedShort());
            }
            case 9: {
                return new ConstantFieldRef(tag, pool, dstream.readUnsignedShort(), dstream.readUnsignedShort());
            }
            case 10: {
                return new ConstantMethodRef(tag, pool, dstream.readUnsignedShort(), dstream.readUnsignedShort());
            }
            case 11: {
                return new ConstantInterfaceMethodRef(tag, pool, dstream.readUnsignedShort(), dstream.readUnsignedShort());
            }
            case 8: {
                return new ConstantString(tag, pool, dstream.readUnsignedShort());
            }
            case 3: {
                return new ConstantInteger(tag, pool, dstream.readInt());
            }
            case 4: {
                return new ConstantFloat(tag, pool, dstream.readFloat());
            }
            case 5: {
                return new ConstantLong(tag, pool, dstream.readLong());
            }
            case 6: {
                return new ConstantDouble(tag, pool, dstream.readDouble());
            }
            case 12: {
                return new ConstantNameAndType(tag, pool, dstream.readUnsignedShort(), dstream.readUnsignedShort());
            }
            case 1: {
                return new ConstantUtf8String(tag, pool, dstream.readUTF());
            }
            case 2: {
                return new ConstantUnicodeString(tag, pool, ConstantPoolEntry.readUnicode(dstream));
            }
        }
        throw new IOException("Bad constant tag: " + tag);
    }

    static String readUnicode(DataInputStream dstream) throws IOException {
        int length = dstream.readUnsignedShort();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buffer.append((char)dstream.readUnsignedByte());
        }
        return buffer.toString();
    }

    String normalize(String s1) {
        if (s1.indexOf(47) != -1) {
            return s1.replace('/', '.');
        }
        return s1;
    }

    static class JavaSignature {
        String fullDecl;

        JavaSignature(String name, String mangledSig) {
            try {
                StringReader strRdr = new StringReader(mangledSig);
                this.parse(strRdr);
                this.fullDecl = JavaSignature.declString(mangledSig, name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static String declString(String mangledSig, String name) {
            try {
                String nameAndType = null;
                StringReader strRdr = new StringReader(mangledSig);
                nameAndType = name == null ? JavaSignature.nameAndTypeString(strRdr, "") : JavaSignature.nameAndTypeString(strRdr, " " + name);
                return nameAndType;
            }
            catch (IOException e) {
                return null;
            }
        }

        static String nameAndTypeString(StringReader strRdr, String name) throws IOException {
            int byteVal = strRdr.read();
            switch (byteVal) {
                case 66: {
                    return "byte" + name;
                }
                case 67: {
                    return "char" + name;
                }
                case 68: {
                    return "double" + name;
                }
                case 70: {
                    return "float" + name;
                }
                case 73: {
                    return "int" + name;
                }
                case 74: {
                    return "long" + name;
                }
                case 83: {
                    return "short" + name;
                }
                case 86: {
                    return "void" + name;
                }
                case 90: {
                    return "boolean" + name;
                }
                case 91: {
                    return JavaSignature.nameAndTypeString(strRdr, name) + "[]";
                }
                case 76: {
                    StringBuffer buf = new StringBuffer();
                    int c = strRdr.read();
                    while (c != -1 && c != 59) {
                        buf.append((char)(c == 47 ? 46 : c));
                        c = strRdr.read();
                    }
                    return buf + name;
                }
                case 40: {
                    String arg;
                    String args = "(";
                    while ((arg = JavaSignature.nameAndTypeString(strRdr, "")) != null) {
                        if (args.length() > 1) {
                            args = args + ", ";
                        }
                        args = args + arg;
                    }
                    args = args + ")";
                    return JavaSignature.nameAndTypeString(strRdr, "") + name + args;
                }
                case 41: {
                    return null;
                }
            }
            throw new IOException();
        }

        int parse(StringReader strRdr) throws IOException {
            int byteVal = strRdr.read();
            switch (byteVal) {
                case 66: 
                case 67: 
                case 70: 
                case 73: 
                case 83: 
                case 90: {
                    return 1;
                }
                case 68: 
                case 74: {
                    return 2;
                }
                case 86: {
                    return 0;
                }
                case 91: {
                    this.parse(strRdr);
                    return 1;
                }
                case 76: {
                    int c = strRdr.read();
                    while (c != -1 && c != 59) {
                        c = strRdr.read();
                    }
                    return 1;
                }
                case 40: {
                    int arg;
                    while ((arg = this.parse(strRdr)) != 0) {
                    }
                    return this.parse(strRdr);
                }
                case 41: {
                    return 0;
                }
            }
            throw new IOException();
        }
    }

    static class ConstantUnicodeString
    extends ConstantGenericString {
        ConstantUnicodeString(byte tag, ConstantPoolEntry[] pool, String value) {
            super(tag, pool, value);
        }
    }

    static class ConstantUtf8String
    extends ConstantGenericString {
        ConstantUtf8String(byte tag, ConstantPoolEntry[] pool, String value) {
            super(tag, pool, value);
        }
    }

    static class ConstantGenericString
    extends ConstantPoolEntry {
        protected String value;
        private Identifier id;

        final Identifier getId() {
            if (this.id == null) {
                this.id = Identifier.fromName(this.normalize(this.value));
            }
            return this.id;
        }

        ConstantGenericString(byte tag, ConstantPoolEntry[] pool, String value) {
            super(tag, pool);
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = this.value;
            }
        }
    }

    static class ConstantNameAndType
    extends ConstantPoolEntry {
        private int nameIndex;
        private int signatureIndex;

        ConstantNameAndType(byte tag, ConstantPoolEntry[] pool, int nameIndex, int signatureIndex) {
            super(tag, pool);
            this.nameIndex = nameIndex;
            this.signatureIndex = signatureIndex;
        }

        public String toString() {
            return this.getSignature() + " " + this.getName();
        }

        String getName() {
            return this.normalize(this.pool[this.nameIndex].toString());
        }

        String getSignature() {
            return this.pool[this.signatureIndex].toString();
        }

        Identifier getNameId() {
            return ((ConstantGenericString)this.pool[this.nameIndex]).getId();
        }

        Identifier getSignatureId() {
            return ((ConstantGenericString)this.pool[this.signatureIndex]).getId();
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = this.toString();
            }
        }
    }

    static class ConstantDouble
    extends ConstantPoolEntry {
        private double value;

        ConstantDouble(byte tag, ConstantPoolEntry[] pool, double value) {
            super(tag, pool);
            this.value = value;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = new Double(this.value);
            }
        }
    }

    static class ConstantLong
    extends ConstantPoolEntry {
        private long value;

        ConstantLong(byte tag, ConstantPoolEntry[] pool, long value) {
            super(tag, pool);
            this.value = value;
        }

        public String toString() {
            return "0x" + Long.toString(this.value, 16) + "L";
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = ConstantLong.makeLong(this.value);
            }
        }
    }

    static class ConstantFloat
    extends ConstantPoolEntry {
        private float value;

        ConstantFloat(byte tag, ConstantPoolEntry[] pool, float value) {
            super(tag, pool);
            this.value = value;
        }

        public String toString() {
            return Float.toString(this.value);
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = new Float(this.value);
            }
        }
    }

    static class ConstantInteger
    extends ConstantPoolEntry {
        private int value;

        ConstantInteger(byte tag, ConstantPoolEntry[] pool, int value) {
            super(tag, pool);
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = ConstantInteger.makeInteger(this.value);
            }
        }
    }

    static class ConstantString
    extends ConstantPoolEntry {
        private int stringIndex;

        ConstantString(byte tag, ConstantPoolEntry[] pool, int stringIndex) {
            super(tag, pool);
            this.stringIndex = stringIndex;
        }

        public String toString() {
            return "\"" + this.pool[this.stringIndex].toString() + "\"";
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                this.referencedObject = this.pool[this.stringIndex].toString();
            }
        }
    }

    static class ConstantInterfaceMethodRef
    extends ConstantMethodRef {
        ConstantInterfaceMethodRef(byte tag, ConstantPoolEntry[] pool, int classIndex, int nameAndTypeIndex) {
            super(tag, pool, classIndex, nameAndTypeIndex);
        }
    }

    static class ConstantMethodRef
    extends ConstantGenericField {
        ConstantMethodRef(byte tag, ConstantPoolEntry[] pool, int classIndex, int nameAndTypeIndex) {
            super(tag, pool, classIndex, nameAndTypeIndex);
        }

        @Override
        void resolve() {
        }
    }

    static class ConstantFieldRef
    extends ConstantGenericField {
        ConstantFieldRef(byte tag, ConstantPoolEntry[] pool, int classIndex, int nameAndTypeIndex) {
            super(tag, pool, classIndex, nameAndTypeIndex);
        }

        @Override
        void resolve() {
        }
    }

    static class ConstantGenericField
    extends ConstantPoolEntry {
        int classIndex;
        int nameAndTypeIndex;

        ConstantGenericField(byte tag, ConstantPoolEntry[] pool, int classIndex, int nameAndTypeIndex) {
            super(tag, pool);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public String toString() {
            return JavaSignature.declString(this.getSignature(), this.getClassEntry() + "." + this.getName());
        }

        ConstantClass getClassEntry() {
            return (ConstantClass)this.pool[this.classIndex];
        }

        String getName() {
            ConstantNameAndType nat = (ConstantNameAndType)this.pool[this.nameAndTypeIndex];
            return this.normalize(nat.getName());
        }

        String getFullyQualifiedName() {
            return this.getClassEntry().toString() + "." + this.getName();
        }

        String getSignature() {
            ConstantNameAndType nat = (ConstantNameAndType)this.pool[this.nameAndTypeIndex];
            return nat.getSignature();
        }
    }

    static class ConstantClass
    extends ConstantPoolEntry {
        private int nameIndex;

        ConstantClass(byte tag, ConstantPoolEntry[] pool, int nameIndex) {
            super(tag, pool);
            this.nameIndex = nameIndex;
        }

        @Override
        void resolve() {
            if (this.referencedObject == null) {
                Identifier id = ((ConstantGenericString)this.pool[this.nameIndex]).getId();
                this.referencedObject = new ClassReference(id.toString());
            }
        }

        public String toString() {
            return this.normalize(this.pool[this.nameIndex].toString());
        }
    }

    static class Identifier {
        private String name;
        private static Hashtable nameMap = new Hashtable();

        public static Identifier fromName(String name) {
            Identifier id = Identifier.findName(name);
            if (id == null) {
                id = new Identifier(name);
                nameMap.put(name, id);
            }
            return id;
        }

        private Identifier(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static Identifier findName(String name) {
            return (Identifier)nameMap.get(name);
        }
    }
}

