/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.PackagerEntry;
import com.tangosol.dev.packager.PackagerEntryNotFoundException;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.PackagerSet;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import com.tangosol.io.Base64OutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

public class JarFilePackagerSet
extends PackagerSet {
    public static final int MANIFEST_NONE = 0;
    public static final int MANIFEST_BLANK = 1;
    public static final int MANIFEST_HEADER = 2;
    public static final int MANIFEST_FULL = 3;
    private String jarFilePathName;
    private boolean compressed = true;
    private Manifest manifest = null;
    private int style = 0;
    private CRC32 crc32 = new CRC32();

    public JarFilePackagerSet() {
    }

    public JarFilePackagerSet(String fileName) throws IOException {
        this.setJarFilePathName(fileName);
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public int getManifestStyle() {
        return this.style;
    }

    public void setManifestStyle(int style) {
        this.style = style;
    }

    public String getJarFilePathName() {
        return this.jarFilePathName;
    }

    public void setJarFilePathName(String jarFilePathName) throws IOException {
        this.jarFilePathName = jarFilePathName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void materialize(ClassLoader classLoader) throws IOException, UnexpectedPackagerException {
        Collection entries = this.getCollectedEntries();
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            manifest = this.createManifest(classLoader);
        }
        FileOutputStream fileOut = new FileOutputStream(this.jarFilePathName);
        JarOutputStream jarOut = manifest == null ? new JarOutputStream(fileOut) : new JarOutputStream((OutputStream)fileOut, manifest);
        try {
            for (PackagerEntry entry : entries) {
                try {
                    this.storeEntryData(jarOut, entry, classLoader);
                }
                catch (PackagerEntryNotFoundException e) {
                    throw new IOException("Failed to store " + entry + ": " + e);
                    return;
                }
            }
        }
        finally {
            jarOut.close();
        }
    }

    protected Manifest createManifest(ClassLoader classLoader) {
        if (this.style == 0) {
            return null;
        }
        Manifest manifest = new Manifest();
        if (this.style > 1) {
            Collection entries = this.getCollectedEntries();
            Attributes mainAttrs = manifest.getMainAttributes();
            mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            Properties mainProps = this.getAttributes();
            for (String string : mainProps.keySet()) {
                mainAttrs.put(new Attributes.Name(string), mainProps.getProperty(string));
            }
            if (this.style > 2) {
                String[] digestAlgorithms = new String[]{"SHA", "MD5"};
                Attributes.Name name = new Attributes.Name("Digest-Algorithms");
                Attributes.Name[] digestAttributeNames = new Attributes.Name[]{new Attributes.Name("SHA-Digest"), new Attributes.Name("MD5-Digest")};
                MessageDigest[] msgDigests = new MessageDigest[2];
                String digestNames = null;
                int n = digestAlgorithms.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        msgDigests[i] = MessageDigest.getInstance(digestAlgorithms[i]);
                        if (digestNames == null) {
                            digestNames = digestAlgorithms[i];
                            continue;
                        }
                        digestNames = digestNames + " " + digestAlgorithms[i];
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithm) {
                        // empty catch block
                    }
                }
                for (PackagerEntry entry : entries) {
                    Attributes attributes = new Attributes();
                    if (digestNames != null && entry.isSecured()) {
                        try {
                            attributes.put(name, digestNames);
                            byte[] entryData = entry.getData(classLoader);
                            if (entryData == null) {
                                throw new PackagerEntryNotFoundException("No data for: " + entry);
                            }
                            int n2 = digestAlgorithms.length;
                            for (int i = 0; i < n2; ++i) {
                                MessageDigest msgDigest = msgDigests[i];
                                if (msgDigest == null) continue;
                                msgDigest.reset();
                                byte[] digestValue = msgDigest.digest(entryData);
                                String digestString = new String(Base64OutputStream.encode(digestValue, false));
                                attributes.put(digestAttributeNames[i], digestString);
                            }
                        }
                        catch (PackagerEntryNotFoundException noSuchEntry) {
                            continue;
                        }
                        Properties entryProps = entry.getAttributes();
                        if (entryProps != null) {
                            for (String string : entryProps.keySet()) {
                                attributes.put(new Attributes.Name(string), entryProps.getProperty(string));
                            }
                        }
                    }
                    manifest.getEntries().put(entry.getPath().getPathName(), attributes);
                }
            }
        }
        return manifest;
    }

    protected void storeEntryData(JarOutputStream jarOut, PackagerEntry entry, ClassLoader classLoader) throws IOException, PackagerEntryNotFoundException {
        PackagerPath path = entry.getPath();
        byte[] data = entry.getData(classLoader);
        if (data == null) {
            throw new PackagerEntryNotFoundException("No data for: " + entry);
        }
        JarEntry zipEntry = new JarEntry(path.getPathName());
        int entrySize = data == null ? 0 : data.length;
        zipEntry.setTime(entry.getModificationTime());
        String comment = entry.getComment();
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        if (entrySize == 0) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        } else {
            zipEntry.setMethod(8);
            if (!this.isCompressed()) {
                this.crc32.reset();
                this.crc32.update(data);
                zipEntry.setSize(data.length);
                zipEntry.setCrc(this.crc32.getValue());
            }
        }
        jarOut.putNextEntry(zipEntry);
        jarOut.write(data, 0, entrySize);
        jarOut.closeEntry();
    }
}

