/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.ClassPackagerPath;
import com.tangosol.dev.packager.PackagerBaseEntry;
import com.tangosol.dev.packager.PackagerEntryNotFoundException;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PackagerClassEntry
extends PackagerBaseEntry {
    private String entryClassName;
    private PackagerPath entryPath;
    private long modificationTime = -1L;

    public PackagerClassEntry() {
        this(null);
    }

    public PackagerClassEntry(String entryClassName) {
        this.setEntryClassName(entryClassName);
    }

    public String getEntryClassName() {
        return this.entryClassName;
    }

    public void setEntryClassName(String entryClassName) {
        this.entryClassName = entryClassName;
        this.modificationTime = -1L;
    }

    public String getPathName() {
        return this.getPath().getPathName();
    }

    @Override
    public PackagerPath getPath() {
        if (this.entryPath == null) {
            this.entryPath = new ClassPackagerPath(this.getEntryClassName());
        }
        return this.entryPath;
    }

    public void setPath(PackagerPath path) {
        this.entryPath = path;
    }

    @Override
    public byte[] getData(ClassLoader classLoader) throws PackagerEntryNotFoundException {
        try {
            InputStream entryStream = classLoader.getResourceAsStream(this.getEntryClassName().replace('.', '/') + ".class");
            if (entryStream == null) {
                throw new PackagerEntryNotFoundException(this.getPathName());
            }
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                collector.write(buffer, 0, bytesRead);
            }
            return collector.toByteArray();
        }
        catch (IOException ioe) {
            throw new UnexpectedPackagerException(ioe);
        }
    }

    @Override
    public long getModificationTime() {
        File classFile;
        if (this.modificationTime == -1L && (classFile = this.findClassFile()) != null) {
            this.modificationTime = classFile.lastModified();
        }
        return this.modificationTime == -1L ? super.getModificationTime() : this.modificationTime;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public boolean isSecured() {
        return true;
    }

    private File findClassFile() {
        return this.findEntryFile();
    }
}

