/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.tools;

import com.tangosol.dev.tools.CommandLineTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public class Notice
extends CommandLineTool {
    public static final byte[] FILE = "%file%".getBytes();
    public static final byte[] DIR = "%dir%".getBytes();
    public static final byte[] PATH = "%path%".getBytes();

    public static void main(String[] asArgs) {
        try {
            int MINSIZE;
            int cArgs = asArgs.length;
            if (cArgs < 2) {
                Notice.showInstructions();
                return;
            }
            String sFileSpec = asArgs[0];
            String sTextFile = asArgs[1];
            if (sFileSpec.length() < 1 || sTextFile.length() < 1) {
                Notice.showInstructions();
                return;
            }
            boolean fPrompt = false;
            boolean fRecurse = false;
            boolean fVerbose = false;
            for (int i = 2; i < cArgs; ++i) {
                String sOpt = asArgs[i];
                if (sOpt.length() < 2 || sOpt.charAt(0) != '-') {
                    Notice.showInstructions();
                    return;
                }
                block8: for (int of = 1; of < sOpt.length(); ++of) {
                    switch (sOpt.charAt(of)) {
                        case 'P': 
                        case 'p': {
                            fPrompt = true;
                            continue block8;
                        }
                        case 'D': 
                        case 'd': {
                            fRecurse = true;
                            continue block8;
                        }
                        case 'V': 
                        case 'v': {
                            fVerbose = true;
                            continue block8;
                        }
                        default: {
                            Notice.showInstructions();
                            return;
                        }
                    }
                }
            }
            if (fVerbose) {
                Notice.out();
                Notice.out("File Spec:  \"" + sFileSpec + "\"");
                Notice.out("Text File:  \"" + sTextFile + "\"");
                Notice.out("Selected Options:");
                if (fRecurse) {
                    Notice.out("  -d  Recurse sub-directories");
                }
                if (fPrompt) {
                    Notice.out("  -p  Prompt before making each change");
                }
                Notice.out("  -v  Verbose mode");
            }
            if (fVerbose) {
                Notice.out();
                Notice.out("Loading notice ...");
            }
            byte[] abNotice = null;
            Enumeration enmrFiles = Notice.applyFilter(sTextFile, false);
            if (enmrFiles == null) {
                Notice.out();
                Notice.out("Invalid directory or file specification:  " + sTextFile);
                Notice.showInstructions();
                return;
            }
            if (!enmrFiles.hasMoreElements()) {
                Notice.out();
                Notice.out("File does not exist:  " + sTextFile);
                Notice.showInstructions();
                return;
            }
            File file = (File)enmrFiles.nextElement();
            if (enmrFiles.hasMoreElements()) {
                Notice.out();
                Notice.out("File specification is ambiguous:  " + sTextFile);
                Notice.showInstructions();
                return;
            }
            boolean fReadable = file.canRead();
            int cbFile = (int)file.length();
            if (!fReadable || cbFile == 0 || cbFile > 65536) {
                String sText = "";
                sText = !fReadable ? "(not readable)" : (cbFile == 0 ? "(zero length)" : "(too large)");
                Notice.out();
                Notice.out("Notice file " + file.getPath() + " is invalid " + sText);
                Notice.showInstructions();
                return;
            }
            abNotice = new byte[cbFile];
            FileInputStream in = new FileInputStream(file);
            for (int cbTotal = 0; cbTotal < cbFile; cbTotal += in.read(abNotice, cbTotal, cbFile - cbTotal)) {
            }
            in.close();
            if (fVerbose) {
                Notice.out();
                Notice.out("Notice file:");
                Notice.out(Notice.indentString(new String(abNotice), "     "));
            }
            if (fVerbose) {
                Notice.out();
                Notice.out("Selecting files ...");
            }
            if ((enmrFiles = Notice.applyFilter(sFileSpec, fRecurse)) == null) {
                Notice.out();
                Notice.out("Invalid directory or file specification:  " + sFileSpec);
                Notice.showInstructions();
                return;
            }
            if (fVerbose) {
                Notice.out();
                Notice.out("Processing files ...");
            }
            int MAXSIZE = 0x1000000;
            int cbBuf = MINSIZE = 65536;
            byte[] abBuf = new byte[cbBuf];
            while (enmrFiles.hasMoreElements()) {
                File file2 = (File)enmrFiles.nextElement();
                boolean fReadable2 = file2.canRead();
                boolean fWriteable = file2.canWrite();
                boolean fHidden = file2.isHidden();
                int cbFile2 = (int)file2.length();
                if (fPrompt || fVerbose) {
                    StringBuffer sb = new StringBuffer();
                    if (fReadable2) {
                        sb.append("r");
                    }
                    if (fWriteable) {
                        sb.append("w");
                    }
                    if (fHidden) {
                        sb.append("h");
                    }
                    Notice.out(file2.getPath() + ", (" + sb.toString() + "), " + cbFile2 + " bytes");
                }
                if (!fReadable2 || !fWriteable || fHidden || cbFile2 > MAXSIZE) {
                    String sText = "";
                    if (!fReadable2) {
                        sText = "(not readable)";
                    } else if (!fWriteable) {
                        sText = "(not writeable)";
                    } else if (fHidden) {
                        sText = "(hidden)";
                    } else if (cbFile2 > MAXSIZE) {
                        sText = "(too large)";
                    }
                    Notice.out("Skipping " + file2.getPath() + " " + sText);
                    continue;
                }
                int chAns = 89;
                if (fPrompt && (chAns = (int)Notice.in("Stamp? (Y/N): ")) != 89 && chAns != 121) continue;
                if (cbFile2 > cbBuf) {
                    cbBuf = cbFile2 + MINSIZE;
                    abBuf = new byte[cbBuf];
                }
                byte[] abStamp = Notice.createNotice(abNotice, file2);
                FileInputStream in2 = new FileInputStream(file2);
                for (int cbTotal = 0; cbTotal < cbFile2; cbTotal += in2.read(abBuf, cbTotal, cbFile2 - cbTotal)) {
                }
                in2.close();
                if (!file2.delete()) {
                    Notice.out("Error deleting " + file2.getPath());
                    return;
                }
                if (!file2.createNewFile()) {
                    Notice.out("Error creating " + file2.getPath());
                    return;
                }
                FileOutputStream out = new FileOutputStream(file2);
                out.write(abStamp);
                out.write(abBuf, 0, cbFile2);
                out.close();
            }
        }
        catch (Throwable t) {
            Notice.out();
            Notice.out("Caught \"" + t + "\"");
            Notice.out("(begin stack trace)");
            Notice.out(t);
            Notice.out("(end stack trace)");
            Notice.out();
        }
    }

    static void showInstructions() {
        Notice.out();
        Notice.out("Source code stamping utility");
        Notice.out();
        Notice.out("Usage:");
        Notice.out("  Notice <filespec> <text file> [-p] [-d] [-v]");
        Notice.out();
        Notice.out("Options:");
        Notice.out("  -d  Recurse sub-directories");
        Notice.out("  -p  Prompt for each files");
        Notice.out("  -v  Verbose mode");
        Notice.out();
        Notice.out("The text file can contain the following tags:");
        Notice.out("  %file%   Substituted with the name of the file");
        Notice.out("  %dir%    Substituted with the directory name containing the file");
        Notice.out("  %path%   Substituted with the fully qualified path of the file");
        Notice.out();
        Notice.out("Example:");
        Notice.out("  java com.tangosol.dev.tools.Notice \"*.java\" copyright.txt -d");
        Notice.out();
    }

    static byte[] createNotice(byte[] abNotice, File file) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int cbNotice = abNotice.length;
        int of = 0;
        while (of < cbNotice) {
            byte b = abNotice[of];
            if (b == 37) {
                String s = null;
                int cb = 0;
                if (Notice.byteCompare(abNotice, of, FILE)) {
                    cb = FILE.length;
                    s = file.getName();
                } else if (Notice.byteCompare(abNotice, of, DIR)) {
                    cb = DIR.length;
                    s = file.getParent();
                } else if (Notice.byteCompare(abNotice, of, PATH)) {
                    cb = PATH.length;
                    s = file.getPath();
                }
                if (s != null) {
                    byte[] ab = s.getBytes();
                    stream.write(ab);
                    of += cb;
                    continue;
                }
            }
            stream.write(b);
            ++of;
        }
        return stream.toByteArray();
    }

    static boolean byteCompare(byte[] ab, int of, byte[] abSearch) throws IOException {
        int cb = abSearch.length;
        if (of + cb > ab.length) {
            return false;
        }
        for (int i = 0; i < cb; ++i) {
            if (ab[of++] == abSearch[i]) continue;
            return false;
        }
        return true;
    }
}

