/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultMemberIdentity;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.io.ConfigurableSerializerFactory;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.HashHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeLinkedList;
import java.net.InetAddress;
import java.net.SocketOptions;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public class DefaultClusterDependencies
implements ClusterDependencies {
    private Filter m_authorizedHostFilter;
    private ConfigurableQuorumPolicy m_clusterActionPolicy;
    private int m_cClusterAnnounceTimeout = 6000;
    private int m_cClusterHeartbeatDelay = 1000;
    private int m_cClusterTimestampMaxVariance = 16;
    private int m_nEdition = 5;
    private List<String> m_listFilter;
    private Map<String, WrapperStreamFactory> m_mapFilter;
    private boolean m_fFlowControlEnabled = true;
    private InetAddress m_groupAddress;
    private int m_nGroupBufferSize;
    private InetAddress m_groupInterface;
    private int m_nGroupListenerPriority = 8;
    private int m_gGroupPort = 8087;
    private int m_cGroupTimeToLive = 4;
    private int m_cIpMonitorAttempts;
    private int m_nIpMonitorPriority;
    private long m_cIpMonitorTimeout = 4L;
    private InetAddress m_localAddress;
    private int m_cLocalBufferSize;
    private int m_nLocalListenerPriority = 8;
    private int m_nLocalPort = 8088;
    private boolean m_fLocalPortAutoAdjust = true;
    private int m_cLostPacketThreshold = 16;
    private DefaultMemberIdentity m_memberIdentity;
    private int m_nMessageAllocatorGrowthFactor = 2;
    private int m_nMessageAllocatorMinBufferSize = 1024;
    private int m_nMessageAllocatorSegments = 4;
    private int m_nMessageAllocatorSegmentSize = 0xF00000;
    private int m_nMode = 1;
    private int m_cOutstandingPacketMaximum = 4096;
    private int m_cOutstandingPacketMinimum = 64;
    private double m_dPacketBundlingAggression = 0.0;
    private long m_cPacketBundlingThresholdNanos = 1000L;
    private int m_cbPacketMaxLength;
    private int m_cbPacketPreferredLength;
    private int m_cPublisherAckDelay = 16;
    private int m_cPublisherSocketBufferSize;
    private int m_cPublisherCloggedCount = 8192;
    private int m_cPublisherCloggedDelayMillis = 10;
    private int m_cPublisherGroupThreshold = 25;
    private int m_cPublisherNackDelay = 1;
    private int m_nPublisherPacketAllocatorSize;
    private int m_nPublisherPriority = 6;
    private int m_cPublisherResendDelayMillis = 200;
    private int m_cPublisherResendTimeoutMillis = 300000;
    private long m_cGuardTimeout = this.m_cPublisherResendTimeoutMillis;
    private boolean m_fReceiverNackEnabled = true;
    private int m_nReceiverPacketAllocatorSize;
    private int m_nReceiverPriority = 7;
    private transient String m_sReliableTransport;
    private Map<String, List<String>> m_mapServiceFilter;
    private Map<String, String> m_mapService;
    private Map<String, ConfigurableSerializerFactory> m_mapSerializer;
    private ServiceFailurePolicy m_serviceFailurePolicy;
    private int m_nShutdownHookOption = 1;
    private SocketProviderFactory m_socketProviderFactory;
    private XmlElement m_xmlUnicastSocketProvider;
    private int m_nSpeakerPriority = 8;
    private int m_cSpeakerVolumeMinimum = -1;
    private boolean m_fTcmpEnabled = true;
    private int m_cTcpBacklog;
    private SocketOptions m_optionsTcpDatagram;
    private boolean m_fTcpRingEnabled = true;
    private SocketOptions m_optionsTcpRing;
    private AddressProvider m_providerWellKnownAddresses;

    public DefaultClusterDependencies() {
    }

    public DefaultClusterDependencies(ClusterDependencies deps) {
        if (deps != null) {
            this.setMemberIdentity(deps.getMemberIdentity());
            this.m_authorizedHostFilter = deps.getAuthorizedHostFilter();
            this.m_clusterActionPolicy = deps.getClusterActionPolicy();
            this.m_cClusterAnnounceTimeout = deps.getClusterAnnounceTimeoutMillis();
            this.m_cClusterHeartbeatDelay = deps.getClusterHeartbeatDelayMillis();
            this.m_cClusterTimestampMaxVariance = deps.getClusterTimestampMaxVarianceMillis();
            this.m_nEdition = deps.getEdition();
            this.m_listFilter = deps.getFilterList();
            this.m_mapFilter = deps.getFilterMap();
            this.m_fFlowControlEnabled = deps.isFlowControlEnabled();
            this.m_groupAddress = deps.getGroupAddress();
            this.m_nGroupBufferSize = deps.getGroupBufferSize();
            this.m_groupInterface = deps.getGroupInterface();
            this.m_nGroupListenerPriority = deps.getGroupListenerPriority();
            this.m_gGroupPort = deps.getGroupPort();
            this.m_cGroupTimeToLive = deps.getGroupTimeToLive();
            this.m_cGuardTimeout = deps.getGuardTimeoutMillis();
            this.m_cIpMonitorAttempts = deps.getIpMonitorAttempts();
            this.m_nIpMonitorPriority = deps.getIpMonitorPriority();
            this.m_cIpMonitorTimeout = deps.getIpMonitorTimeoutMillis();
            this.m_localAddress = deps.getLocalAddress();
            this.m_cLocalBufferSize = deps.getLocalBufferSize();
            this.m_nLocalListenerPriority = deps.getLocalListenerPriority();
            this.m_nLocalPort = deps.getLocalPort();
            this.m_fLocalPortAutoAdjust = deps.isLocalPortAutoAdjust();
            this.m_cLostPacketThreshold = deps.getLostPacketThreshold();
            this.m_nMessageAllocatorGrowthFactor = deps.getMessageAllocatorGrowthFactor();
            this.m_nMessageAllocatorMinBufferSize = deps.getMessageAllocatorMinBufferSize();
            this.m_nMessageAllocatorSegments = deps.getMessageAllocatorSegments();
            this.m_nMessageAllocatorSegmentSize = deps.getMessageAllocatorSegmentSize();
            this.m_nMode = deps.getMode();
            this.m_cOutstandingPacketMaximum = deps.getOutstandingPacketMaximum();
            this.m_cOutstandingPacketMinimum = deps.getOutstandingPacketMinimum();
            this.m_dPacketBundlingAggression = deps.getPacketBundlingAggression();
            this.m_cPacketBundlingThresholdNanos = deps.getPacketBundlingThresholdNanos();
            this.m_cbPacketMaxLength = deps.getPacketMaxLength();
            this.m_cbPacketPreferredLength = deps.getPacketPreferredLength();
            this.m_cPublisherAckDelay = deps.getPublisherAckDelayMillis();
            this.m_cPublisherSocketBufferSize = deps.getPublisherSocketBufferSize();
            this.m_cPublisherCloggedCount = deps.getPublisherCloggedCount();
            this.m_cPublisherCloggedDelayMillis = deps.getPublisherCloggedDelayMillis();
            this.m_cPublisherGroupThreshold = deps.getPublisherGroupThreshold();
            this.m_cPublisherNackDelay = deps.getPublisherNackDelayMillis();
            this.m_nPublisherPacketAllocatorSize = deps.getPublisherPacketAllocatorSize();
            this.m_nPublisherPriority = deps.getPublisherPriority();
            this.m_cPublisherResendDelayMillis = deps.getPublisherResendDelayMillis();
            this.m_cPublisherResendTimeoutMillis = deps.getPublisherResendTimeoutMillis();
            this.m_fReceiverNackEnabled = deps.isReceiverNackEnabled();
            this.m_nReceiverPacketAllocatorSize = deps.getReceiverPacketAllocatorSize();
            this.m_nReceiverPriority = deps.getReceiverPriority();
            this.m_sReliableTransport = deps.getReliableTransport();
            this.m_mapSerializer = deps.getSerializerMap();
            this.m_serviceFailurePolicy = deps.getServiceFailurePolicy();
            this.m_mapServiceFilter = deps.getServiceFilterMap();
            this.m_mapService = deps.getServiceMap();
            this.m_nShutdownHookOption = deps.getShutdownHookOption();
            this.m_socketProviderFactory = deps.getSocketProviderFactory();
            this.m_xmlUnicastSocketProvider = deps.getUnicastSocketProviderXml();
            this.m_nSpeakerPriority = deps.getSpeakerPriority();
            this.m_cSpeakerVolumeMinimum = deps.getSpeakerVolumeMinimum();
            this.m_fTcmpEnabled = deps.isTcmpEnabled();
            this.m_cTcpBacklog = deps.getTcpBacklog();
            this.m_optionsTcpDatagram = deps.getTcpDatagramSocketOptions();
            this.m_fTcpRingEnabled = deps.isTcpRingEnabled();
            this.m_optionsTcpRing = deps.getTcpRingSocketOptions();
            this.m_providerWellKnownAddresses = deps.getWellKnownAddresses();
        }
    }

    @Override
    public Filter getAuthorizedHostFilter() {
        return this.m_authorizedHostFilter;
    }

    public DefaultClusterDependencies setAuthorizedHostFilter(Filter filter) {
        this.m_authorizedHostFilter = filter;
        return this;
    }

    @Override
    public ConfigurableQuorumPolicy getClusterActionPolicy() {
        return this.m_clusterActionPolicy;
    }

    public DefaultClusterDependencies setClusterActionPolicy(ConfigurableQuorumPolicy policy) {
        this.m_clusterActionPolicy = policy;
        return this;
    }

    @Override
    public int getClusterAnnounceTimeoutMillis() {
        return this.m_cClusterAnnounceTimeout;
    }

    public DefaultClusterDependencies setClusterAnnounceTimeoutMillis(int cMillis) {
        this.m_cClusterAnnounceTimeout = cMillis;
        return this;
    }

    @Override
    public int getClusterHeartbeatDelayMillis() {
        return this.m_cClusterHeartbeatDelay;
    }

    public DefaultClusterDependencies setClusterHeartbeatDelayMillis(int cMillis) {
        this.m_cClusterHeartbeatDelay = cMillis;
        return this;
    }

    @Override
    public int getClusterTimestampMaxVarianceMillis() {
        return this.m_cClusterTimestampMaxVariance;
    }

    public DefaultClusterDependencies setClusterTimestampMaxVarianceMillis(int cMillis) {
        this.m_cClusterTimestampMaxVariance = cMillis;
        return this;
    }

    @Override
    public int getEdition() {
        return this.m_nEdition;
    }

    public DefaultClusterDependencies setEdition(int n) {
        this.m_nEdition = n;
        return this;
    }

    @Override
    public Map<String, WrapperStreamFactory> getFilterMap() {
        LiteMap mapFilter = this.m_mapFilter;
        if (mapFilter == null) {
            this.m_mapFilter = mapFilter = new LiteMap();
        }
        return mapFilter;
    }

    public DefaultClusterDependencies setFilterMap(Map<String, WrapperStreamFactory> mapFilter) {
        this.m_mapFilter = mapFilter;
        return this;
    }

    @Override
    public List<String> getFilterList() {
        SafeLinkedList listFilter = this.m_listFilter;
        if (listFilter == null) {
            this.m_listFilter = listFilter = new SafeLinkedList();
        }
        return listFilter;
    }

    public DefaultClusterDependencies setFilterList(List<String> listFilter) {
        this.m_listFilter = listFilter;
        return this;
    }

    @Override
    public boolean isFlowControlEnabled() {
        return this.m_fFlowControlEnabled;
    }

    public DefaultClusterDependencies setFlowControlEnabled(boolean fEnabled) {
        this.m_fFlowControlEnabled = fEnabled;
        return this;
    }

    @Override
    public InetAddress getGroupAddress() {
        return this.m_groupAddress;
    }

    public DefaultClusterDependencies setGroupAddress(InetAddress addr) {
        this.m_groupAddress = addr;
        return this;
    }

    @Override
    public int getGroupBufferSize() {
        return this.m_nGroupBufferSize;
    }

    public DefaultClusterDependencies setGroupBufferSize(int nSize) {
        this.m_nGroupBufferSize = nSize;
        return this;
    }

    @Override
    public InetAddress getGroupInterface() {
        return this.m_groupInterface;
    }

    public DefaultClusterDependencies setGroupInterface(InetAddress addr) {
        this.m_groupInterface = addr;
        return this;
    }

    @Override
    public int getGroupListenerPriority() {
        return this.m_nGroupListenerPriority;
    }

    public DefaultClusterDependencies setGroupListenerPriority(int nPriority) {
        this.m_nGroupListenerPriority = nPriority;
        return this;
    }

    @Override
    public int getGroupPort() {
        return this.m_gGroupPort;
    }

    public DefaultClusterDependencies setGroupPort(int nPort) {
        this.m_gGroupPort = nPort;
        return this;
    }

    @Override
    public int getGroupTimeToLive() {
        return this.m_cGroupTimeToLive;
    }

    public DefaultClusterDependencies setGroupTimeToLive(int cHops) {
        this.m_cGroupTimeToLive = cHops;
        return this;
    }

    @Override
    public long getGuardTimeoutMillis() {
        return this.m_cGuardTimeout;
    }

    public DefaultClusterDependencies setGuardTimeoutMillis(long cTimeout) {
        this.m_cGuardTimeout = cTimeout;
        return this;
    }

    @Override
    public int getIpMonitorAttempts() {
        return this.m_cIpMonitorAttempts;
    }

    public DefaultClusterDependencies setIpMonitorAttempts(int cAttempts) {
        this.m_cIpMonitorAttempts = cAttempts;
        return this;
    }

    @Override
    public int getIpMonitorPriority() {
        return this.m_nIpMonitorPriority;
    }

    public DefaultClusterDependencies setIpMonitorPriority(int nPriority) {
        this.m_nIpMonitorPriority = nPriority;
        return this;
    }

    @Override
    public long getIpMonitorTimeoutMillis() {
        return this.m_cIpMonitorTimeout;
    }

    public DefaultClusterDependencies setIpMonitorTimeoutMillis(long cMillis) {
        this.m_cIpMonitorTimeout = cMillis;
        return this;
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress addr = this.m_localAddress;
        if (addr == null) {
            try {
                this.m_localAddress = addr = InetAddressHelper.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return addr;
    }

    public DefaultClusterDependencies setLocalAddress(InetAddress addr) {
        this.m_localAddress = addr;
        return this;
    }

    @Override
    public int getLocalBufferSize() {
        return this.m_cLocalBufferSize;
    }

    public DefaultClusterDependencies setLocalBufferSize(int cPackets) {
        this.m_cLocalBufferSize = cPackets;
        return this;
    }

    @Override
    public int getLocalListenerPriority() {
        return this.m_nLocalListenerPriority;
    }

    public DefaultClusterDependencies setLocalListenerPriority(int nPriority) {
        this.m_nLocalListenerPriority = nPriority;
        return this;
    }

    @Override
    public int getLocalPort() {
        return this.m_nLocalPort;
    }

    public DefaultClusterDependencies setLocalPort(int nPort) {
        this.m_nLocalPort = nPort;
        return this;
    }

    @Override
    public boolean isLocalPortAutoAdjust() {
        return this.m_fLocalPortAutoAdjust;
    }

    public DefaultClusterDependencies setLocalPortAutoAdjust(boolean fPortAuto) {
        this.m_fLocalPortAutoAdjust = fPortAuto;
        return this;
    }

    @Override
    public int getLostPacketThreshold() {
        return this.m_cLostPacketThreshold;
    }

    public DefaultClusterDependencies setLostPacketThreshold(int cPackets) {
        this.m_cLostPacketThreshold = cPackets;
        return this;
    }

    @Override
    public DefaultMemberIdentity getMemberIdentity() {
        return this.m_memberIdentity;
    }

    public DefaultClusterDependencies setMemberIdentity(MemberIdentity identity) {
        this.m_memberIdentity = new DefaultMemberIdentity(identity){

            @Override
            public String getClusterName() {
                String sName = super.getClusterName();
                if (sName == null || sName.isEmpty()) {
                    sName = DefaultClusterDependencies.this.makeClusterName();
                    this.setClusterName(sName);
                }
                return sName;
            }

            @Override
            public String getMachineName() {
                String sMachineName = super.getMachineName();
                if (sMachineName == null) {
                    sMachineName = DefaultClusterDependencies.this.makeMachineName();
                    super.setMachineName(sMachineName);
                }
                return sMachineName;
            }

            @Override
            public String getSiteName() {
                String sSiteName = super.getSiteName();
                if (sSiteName == null) {
                    sSiteName = DefaultClusterDependencies.this.makeSiteName();
                    super.setSiteName(sSiteName);
                }
                return sSiteName;
            }
        };
        return this;
    }

    @Override
    public int getMessageAllocatorGrowthFactor() {
        return this.m_nMessageAllocatorGrowthFactor;
    }

    public DefaultClusterDependencies setMessageAllocatorGrowthFactor(int nGrowthFactor) {
        this.m_nMessageAllocatorGrowthFactor = nGrowthFactor;
        return this;
    }

    @Override
    public int getMessageAllocatorMinBufferSize() {
        return this.m_nMessageAllocatorMinBufferSize;
    }

    public DefaultClusterDependencies setMessageAllocatorMinBufferSize(int nMinBufferSize) {
        this.m_nMessageAllocatorMinBufferSize = nMinBufferSize;
        return this;
    }

    @Override
    public int getMessageAllocatorSegments() {
        return this.m_nMessageAllocatorSegments;
    }

    public DefaultClusterDependencies setMessageAllocatorSegments(int nSegments) {
        this.m_nMessageAllocatorSegments = nSegments;
        return this;
    }

    @Override
    public int getMessageAllocatorSegmentSize() {
        return this.m_nMessageAllocatorSegmentSize;
    }

    public DefaultClusterDependencies setMessageAllocatorSegmentSize(int nSegmentSize) {
        this.m_nMessageAllocatorSegmentSize = nSegmentSize;
        return this;
    }

    @Override
    public int getMode() {
        return this.m_nMode;
    }

    public DefaultClusterDependencies setMode(int nMode) {
        this.m_nMode = nMode;
        return this;
    }

    @Override
    public int getOutstandingPacketMaximum() {
        return this.m_cOutstandingPacketMaximum;
    }

    public DefaultClusterDependencies setOutstandingPacketMaximum(int cPackets) {
        this.m_cOutstandingPacketMaximum = cPackets;
        return this;
    }

    @Override
    public int getOutstandingPacketMinimum() {
        return this.m_cOutstandingPacketMinimum;
    }

    public DefaultClusterDependencies setOutstandingPacketMinimum(int cPackets) {
        this.m_cOutstandingPacketMinimum = cPackets;
        return this;
    }

    @Override
    public double getPacketBundlingAggression() {
        return this.m_dPacketBundlingAggression;
    }

    public DefaultClusterDependencies setPacketBundlingAggression(double dAggression) {
        this.m_dPacketBundlingAggression = dAggression;
        return this;
    }

    @Override
    public long getPacketBundlingThresholdNanos() {
        return this.m_cPacketBundlingThresholdNanos;
    }

    public DefaultClusterDependencies setPacketBundlingThresholdNanos(long cNanos) {
        this.m_cPacketBundlingThresholdNanos = cNanos;
        return this;
    }

    @Override
    public int getPacketMaxLength() {
        return this.m_cbPacketMaxLength;
    }

    public DefaultClusterDependencies setPacketMaxLength(int cbMax) {
        this.m_cbPacketMaxLength = cbMax;
        return this;
    }

    @Override
    public int getPacketPreferredLength() {
        return this.m_cbPacketPreferredLength;
    }

    public DefaultClusterDependencies setPacketPreferredLength(int cb) {
        this.m_cbPacketPreferredLength = cb;
        return this;
    }

    @Override
    public int getPublisherAckDelayMillis() {
        return this.m_cPublisherAckDelay;
    }

    public DefaultClusterDependencies setPublisherAckDelayMillis(int cMillis) {
        this.m_cPublisherAckDelay = cMillis;
        return this;
    }

    @Override
    public int getPublisherSocketBufferSize() {
        return this.m_cPublisherSocketBufferSize;
    }

    public DefaultClusterDependencies setPublisherSocketBufferSize(int cPackets) {
        this.m_cPublisherSocketBufferSize = cPackets;
        return this;
    }

    @Override
    public int getPublisherCloggedCount() {
        return this.m_cPublisherCloggedCount;
    }

    public DefaultClusterDependencies setPublisherCloggedCount(int cMax) {
        this.m_cPublisherCloggedCount = cMax;
        return this;
    }

    @Override
    public int getPublisherCloggedDelayMillis() {
        return this.m_cPublisherCloggedDelayMillis;
    }

    public DefaultClusterDependencies setPublisherCloggedDelayMillis(int cMillis) {
        this.m_cPublisherCloggedDelayMillis = cMillis;
        return this;
    }

    @Override
    public int getPublisherGroupThreshold() {
        return this.m_cPublisherGroupThreshold;
    }

    public DefaultClusterDependencies setPublisherGroupThreshold(int cPercent) {
        this.m_cPublisherGroupThreshold = cPercent;
        return this;
    }

    @Override
    public int getPublisherNackDelayMillis() {
        return this.m_cPublisherNackDelay;
    }

    public DefaultClusterDependencies setPublisherNackDelayMillis(int cMillis) {
        this.m_cPublisherNackDelay = cMillis;
        return this;
    }

    @Override
    public int getPublisherPacketAllocatorSize() {
        return this.m_nPublisherPacketAllocatorSize;
    }

    public DefaultClusterDependencies setPublisherPacketAllocatorSize(int nSize) {
        this.m_nPublisherPacketAllocatorSize = nSize;
        return this;
    }

    @Override
    public int getPublisherPriority() {
        return this.m_nPublisherPriority;
    }

    public DefaultClusterDependencies setPublisherPriority(int nPriority) {
        this.m_nPublisherPriority = nPriority;
        return this;
    }

    @Override
    public int getPublisherResendDelayMillis() {
        return this.m_cPublisherResendDelayMillis;
    }

    public DefaultClusterDependencies setPublisherResendDelayMillis(int cMillis) {
        this.m_cPublisherResendDelayMillis = cMillis;
        return this;
    }

    @Override
    public int getPublisherResendTimeoutMillis() {
        return this.m_cPublisherResendTimeoutMillis;
    }

    public DefaultClusterDependencies setPublisherResendTimeoutMillis(int cMillis) {
        this.m_cPublisherResendTimeoutMillis = cMillis;
        return this;
    }

    @Override
    public boolean isReceiverNackEnabled() {
        return this.m_fReceiverNackEnabled;
    }

    public DefaultClusterDependencies setReceiverNackEnabled(boolean fEnabled) {
        this.m_fReceiverNackEnabled = fEnabled;
        return this;
    }

    @Override
    public int getReceiverPacketAllocatorSize() {
        return this.m_nReceiverPacketAllocatorSize;
    }

    public DefaultClusterDependencies setReceiverPacketAllocatorSize(int nSize) {
        this.m_nReceiverPacketAllocatorSize = nSize;
        return this;
    }

    @Override
    public int getReceiverPriority() {
        return this.m_nReceiverPriority;
    }

    public DefaultClusterDependencies setReceiverPriority(int nPriority) {
        this.m_nReceiverPriority = nPriority;
        return this;
    }

    @Override
    public String getReliableTransport() {
        return this.m_sReliableTransport;
    }

    public DefaultClusterDependencies setReliableTransport(String sName) {
        this.m_sReliableTransport = sName;
        return this;
    }

    @Override
    public Map<String, ConfigurableSerializerFactory> getSerializerMap() {
        LiteMap mapSerializer = this.m_mapSerializer;
        if (mapSerializer == null) {
            this.m_mapSerializer = mapSerializer = new LiteMap();
        }
        return mapSerializer;
    }

    public DefaultClusterDependencies setSerializerMap(Map<String, ConfigurableSerializerFactory> mapSerializer) {
        this.m_mapSerializer = mapSerializer;
        return this;
    }

    @Override
    public ServiceFailurePolicy getServiceFailurePolicy() {
        ServiceFailurePolicy serviceFailurePolicy = this.m_serviceFailurePolicy;
        if (serviceFailurePolicy == null) {
            this.m_serviceFailurePolicy = serviceFailurePolicy = new DefaultServiceFailurePolicy(1);
        }
        return serviceFailurePolicy;
    }

    public DefaultClusterDependencies setServiceFailurePolicy(ServiceFailurePolicy policy) {
        this.m_serviceFailurePolicy = policy;
        return this;
    }

    @Override
    public Map<String, List<String>> getServiceFilterMap() {
        LiteMap mapServiceFilter = this.m_mapServiceFilter;
        if (mapServiceFilter == null) {
            this.m_mapServiceFilter = mapServiceFilter = new LiteMap();
        }
        return mapServiceFilter;
    }

    public DefaultClusterDependencies setServiceFilterMap(Map<String, List<String>> mapServiceFilter) {
        this.m_mapServiceFilter = mapServiceFilter;
        return this;
    }

    @Override
    public Map<String, String> getServiceMap() {
        LiteMap mapService = this.m_mapService;
        if (mapService == null) {
            this.m_mapService = mapService = new LiteMap();
        }
        return mapService;
    }

    public DefaultClusterDependencies setServiceMap(Map<String, String> mapService) {
        this.m_mapService = mapService;
        return this;
    }

    @Override
    public int getShutdownHookOption() {
        return this.m_nShutdownHookOption;
    }

    public DefaultClusterDependencies setShutdownHookOption(int nOption) {
        this.m_nShutdownHookOption = nOption;
        return this;
    }

    @Override
    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory socketProviderFactory = this.m_socketProviderFactory;
        if (socketProviderFactory == null) {
            this.m_socketProviderFactory = socketProviderFactory = new SocketProviderFactory();
        }
        return socketProviderFactory;
    }

    public DefaultClusterDependencies setSocketProviderFactory(SocketProviderFactory factory) {
        this.m_socketProviderFactory = factory;
        return this;
    }

    @Override
    public XmlElement getUnicastSocketProviderXml() {
        return this.m_xmlUnicastSocketProvider;
    }

    public DefaultClusterDependencies setUnicastSocketProviderXml(XmlElement xmlProvider) {
        this.m_xmlUnicastSocketProvider = xmlProvider;
        return this;
    }

    @Override
    public int getSpeakerPriority() {
        return this.m_nSpeakerPriority;
    }

    public DefaultClusterDependencies setSpeakerPriority(int nPriority) {
        this.m_nSpeakerPriority = nPriority;
        return this;
    }

    @Override
    public int getSpeakerVolumeMinimum() {
        return this.m_cSpeakerVolumeMinimum;
    }

    public DefaultClusterDependencies setSpeakerVolumeMinimum(int cVolume) {
        this.m_cSpeakerVolumeMinimum = cVolume;
        return this;
    }

    @Override
    public boolean isTcmpEnabled() {
        return this.m_fTcmpEnabled;
    }

    public DefaultClusterDependencies setTcmpEnabled(boolean fEnabled) {
        this.m_fTcmpEnabled = fEnabled;
        return this;
    }

    @Override
    public int getTcpBacklog() {
        return this.m_cTcpBacklog;
    }

    public DefaultClusterDependencies setTcpBacklog(int cPeers) {
        this.m_cTcpBacklog = cPeers;
        return this;
    }

    @Override
    public SocketOptions getTcpDatagramSocketOptions() {
        return this.m_optionsTcpDatagram;
    }

    public DefaultClusterDependencies setTcpDatagramSocketOptions(SocketOptions options) {
        this.m_optionsTcpDatagram = options;
        return this;
    }

    @Override
    public SocketOptions getTcpRingSocketOptions() {
        return this.m_optionsTcpRing;
    }

    public DefaultClusterDependencies setTcpRingSocketOptions(SocketOptions options) {
        this.m_optionsTcpRing = options;
        return this;
    }

    @Override
    public boolean isTcpRingEnabled() {
        return this.m_fTcpRingEnabled;
    }

    public DefaultClusterDependencies setTcpRingEnabled(boolean fEnabled) {
        this.m_fTcpRingEnabled = fEnabled;
        return this;
    }

    @Override
    public AddressProvider getWellKnownAddresses() {
        return this.m_providerWellKnownAddresses;
    }

    public DefaultClusterDependencies setWellKnownAddresses(AddressProvider provider) {
        this.m_providerWellKnownAddresses = provider;
        return this;
    }

    @Override
    public boolean isIpMonitorEnabled() {
        return this.getIpMonitorTimeoutMillis() * (long)this.getIpMonitorAttempts() > 0L;
    }

    public DefaultClusterDependencies validate() {
        Base.checkNotNull(this.getMemberIdentity(), "MemberIdentity");
        this.getMemberIdentity().validate();
        this.validateGuardTimeout();
        Base.checkNotNull(this.getServiceMap(), "Services");
        Base.checkNotNull(this.getFilterMap(), "FilterMap");
        Base.checkNotNull(this.getFilterList(), "FilterList");
        Base.checkNotNull(this.getLocalAddress(), "LocalAddress");
        Base.checkNotNull(this.getMemberIdentity(), "MemberIdentity");
        Base.checkNotNull(this.getSerializerMap(), "SerializerMap");
        Base.checkNotNull(this.getServiceFailurePolicy(), "ServiceFailurePolicy");
        Base.checkNotNull(this.getServiceFilterMap(), "ServiceFilterMap");
        Base.checkNotNull(this.getServiceMap(), "ServiceMap");
        Base.checkNotNull(this.getSocketProviderFactory(), "SocketProviderFactory");
        Base.checkRange(this.getClusterAnnounceTimeoutMillis(), 0L, 1000000L, "ClusterAnnounceTimeoutMillis");
        Base.checkRange(this.getClusterHeartbeatDelayMillis(), 0L, 60000L, "ClusterHeartbeatDelayMillis");
        Base.checkRange(this.getClusterTimestampMaxVarianceMillis(), 1L, 1000L, "ClusterTimestampMaxVarianceMillis");
        Base.checkRange(this.getGroupListenerPriority(), 1L, 10L, "GroupListenerPriority");
        Base.checkRange(this.getGroupPort(), 1L, 65536L, "GroupPort");
        Base.checkRange(this.getGroupTimeToLive(), 0L, 255L, "GroupTimeToLive");
        Base.checkRange(this.getIpMonitorPriority(), 1L, 10L, "IpMonitorPriority");
        Base.checkRange(this.getLocalListenerPriority(), 1L, 10L, "LocalListenerPriority");
        Base.checkRange(this.getLocalPort(), 1L, 65535L, "LocalPort");
        Base.checkRange(this.getPacketMaxLength(), 0L, 65535L, "PacketMaxLength");
        Base.checkRange(this.getPacketPreferredLength(), 0L, this.getPacketMaxLength(), "PacketPreferredLength");
        Base.checkRange(this.getPublisherAckDelayMillis(), 0L, 60000L, "PublisherAckDelayMillis");
        Base.checkRange(this.getPublisherCloggedDelayMillis(), 0L, 60000L, "PublisherCloggedDelayMillis");
        Base.checkRange(this.getPublisherGroupThreshold(), 0L, 100L, "PublisherGroupThreshold");
        Base.checkRange(this.getPublisherPriority(), 1L, 10L, "PublisherPriority");
        Base.checkRange(this.getPublisherResendDelayMillis(), 0L, 60000L, "PublisherResendDelayMillis");
        Base.checkRange(this.getPublisherResendTimeoutMillis(), 0L, 1000000L, "PublisherResendTimeoutMillis");
        Base.checkRange(this.getReceiverPriority(), 1L, 10L, "ReceiverPriority");
        Base.checkRange(this.getSpeakerPriority(), 1L, 10L, "SpeakerPriority");
        return this;
    }

    public String toString() {
        return "DefaultClusterDependencies{\n\tAuthorizedHostFilter          = " + this.getAuthorizedHostFilter() + "\n\tClusterActionPolicy           = " + this.getClusterActionPolicy() + "\n\tClusterAnnounceTimeout        = " + this.getClusterAnnounceTimeoutMillis() + "\n\tClusterHeartbeatDelay         = " + this.getClusterHeartbeatDelayMillis() + "\n\tClusterTimestampMaxVariance   = " + this.getClusterTimestampMaxVarianceMillis() + "\n\tEdition                       = " + this.getEdition() + "\n\tFilterList                    = " + this.getFilterList() + "\n\tFilterMap                     = " + this.getFilterMap() + "\n\tServiceFilterMap              = " + this.getServiceFilterMap() + "\n\tGroupAddress                  = " + this.getGroupAddress() + "\n\tGroupBufferSize               = " + this.getGroupBufferSize() + "\n\tGroupInterface                = " + this.getGroupInterface() + "\n\tGroupTimeToLive               = " + this.getGroupTimeToLive() + "\n\tGuardTimeout                  = " + this.getGuardTimeoutMillis() + "\n\tIpMonitorAttempts             = " + this.getIpMonitorAttempts() + "\n\tIpMonitorPriority             = " + this.getIpMonitorPriority() + "\n\tLocalAddress                  = " + this.getLocalAddress() + "\n\tLocalBufferSize               = " + this.getLocalBufferSize() + "\n\tLocalListenerPriority         = " + this.getLocalListenerPriority() + "\n\tLocalPort                     = " + this.getLocalPort() + "\n\tLostPacketThreshold           = " + this.getLostPacketThreshold() + "\n\tMemberIdentity                = " + this.getMemberIdentity() + "\n\tMessageAllocatorGrowthFactor  = " + this.getMessageAllocatorGrowthFactor() + "\n\tMessageAllocatorMinBufferSize = " + this.getMessageAllocatorMinBufferSize() + "\n\tMessageAllocatorSegments      = " + this.getMessageAllocatorSegments() + "\n\tMessageAllocatorSegmentSize   = " + this.getMessageAllocatorSegmentSize() + "\n\tMode                          = " + this.getMode() + "\n\tOutstandingPacketMaximum      = " + this.getOutstandingPacketMaximum() + "\n\tOutstandingPacketMinimum      = " + this.getOutstandingPacketMinimum() + "\n\tPacketBundlingAggression      = " + this.getPacketBundlingAggression() + "\n\tPacketBundlingThresholdNanos  = " + this.getPacketBundlingThresholdNanos() + "\n\tPacketMaxLength               = " + this.getPacketMaxLength() + "\n\tPacketPreferredLength         = " + this.getPacketPreferredLength() + "\n\tPublisherAckDelay             = " + this.getPublisherAckDelayMillis() + "\n\tPublisherSocketBufferSize     = " + this.getPublisherSocketBufferSize() + "\n\tPublisherCloggedCount         = " + this.getPublisherCloggedCount() + "\n\tPublisherCloggedDelayMillis   = " + this.getPublisherCloggedDelayMillis() + "\n\tPublisherGroupThreshold       = " + this.getPublisherGroupThreshold() + "\n\tPublisherNackDelay            = " + this.getPublisherNackDelayMillis() + "\n\tPublisherPacketAllocatorSize  = " + this.getPublisherPacketAllocatorSize() + "\n\tPublisherPriority             = " + this.getPublisherPriority() + "\n\tPublisherResendDelayMillis    = " + this.getPublisherResendDelayMillis() + "\n\tPublisherResendTimeoutMillis  = " + this.getPublisherResendTimeoutMillis() + "\n\tReceiverPacketAllocatorSize   = " + this.getReceiverPacketAllocatorSize() + "\n\tReceiverPriority              = " + this.getReceiverPriority() + "\n\tReliableTransport             = " + this.getReliableTransport() + "\n\tServiceFailurePolicy          = " + this.getServiceFailurePolicy() + "\n\tShutdownHookOption            = " + this.getShutdownHookOption() + "\n\tSocketProviderFactory         = " + this.getSocketProviderFactory() + "\n\tServiceMap                    = " + this.getServiceMap() + "\n\tSerializerMap                 = " + this.getSerializerMap() + "\n\tUnicastSocketProviderXml      = " + this.getUnicastSocketProviderXml() + "\n\tSpeakerPriority               = " + this.getSpeakerPriority() + "\n\tSpeakerVolumeMinimum          = " + this.getSpeakerVolumeMinimum() + "\n\tTcpBacklog                    = " + this.getTcpBacklog() + "\n\tTcpDatagramSocketOptions      = " + this.getTcpDatagramSocketOptions() + "\n\tTcpRingSocketOptions          = " + this.getTcpRingSocketOptions() + "\n\tWellKnownAddresses            = " + this.getWellKnownAddresses() + "\n\tFlowControlEnabled            = " + (this.isFlowControlEnabled() ? "true" : "false") + "\n\tIpMonitorEnabled              = " + (this.isIpMonitorEnabled() ? "true" : "false") + "\n\tLocalPortAutoAdjust           = " + (this.isLocalPortAutoAdjust() ? "true" : "false") + "\n\tReceiverNackEnabled           = " + (this.isReceiverNackEnabled() ? "true" : "false") + "\n\tTcmpEnabled                   = " + (this.isTcmpEnabled() ? "true" : "false") + "\n\tTcpRingEnabled                = " + (this.isTcpRingEnabled() ? "true" : "false") + "}";
    }

    protected void validateGuardTimeout() {
        if (this.getGuardTimeoutMillis() <= 0L) {
            this.setGuardTimeoutMillis(this.getPublisherResendTimeoutMillis());
            this.setServiceFailurePolicy(new DefaultServiceFailurePolicy(3));
            CacheFactory.log("Disabling the service-guardian by setting a timeout of 0 has been deprecated. Instead, please configure a \"service-failure-policy\" of \"logging\" which will perform non-invasive monitoring of Coherence services.\n Configuring the Guardian to use the \"logging\" policy with a timeout of " + this.getGuardTimeoutMillis() + "ms", 2);
        }
    }

    protected String makeClusterName() {
        if (this.getWellKnownAddresses() == null) {
            return "cluster:0x" + Base.toHexString(HashHelper.hash(this.getGroupTimeToLive() == 0, HashHelper.hash(this.getGroupAddress().hashCode(), this.getGroupPort())), 4);
        }
        return "";
    }

    protected String makeMachineName() {
        try {
            InetAddress addr = this.getLocalAddress();
            String sHost = addr.getCanonicalHostName();
            if (!Base.equals(addr.getHostAddress(), sHost)) {
                int ofDelim = sHost.indexOf(46);
                int cChars = ofDelim == -1 ? sHost.length() : ofDelim;
                return sHost.substring(0, Math.min(32, cChars));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    protected String makeSiteName() {
        try {
            int ofDelim;
            InetAddress addr = this.getLocalAddress();
            String sHost = addr.getCanonicalHostName();
            if (!Base.equals(addr.getHostAddress(), sHost) && (ofDelim = sHost.indexOf(46)) != -1) {
                int ofEnd = Math.min(sHost.length(), ofDelim + 32);
                return sHost.substring(ofDelim + 1, ofEnd);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }
}

