/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.BinaryDeltaCompressor;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.OutputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.IOException;

public class DecoratedBinaryDeltaCompressor
extends ExternalizableHelper
implements DeltaCompressor {
    private static final byte DECO_NO_CHANGES = -3;
    private static final byte DECO_DELETE_ALL = -4;
    private static final byte DECO_INSERT = -5;
    private static final byte DECO_UPDATE = -6;
    private static final byte DECO_DELETE = -7;
    private static final byte DECO_TERM = -8;
    private static final byte VALUE_NO_CHANGES = -3;
    private static final byte VALUE_CHANGES = -4;
    private static final Binary NO_BINARY = AbstractReadBuffer.NO_BINARY;
    private static final BinaryDeltaCompressor s_compressorBinary = new BinaryDeltaCompressor();
    private DeltaCompressor m_compressorValue;

    public DecoratedBinaryDeltaCompressor(DeltaCompressor compressorValue) {
        Base.azzert(compressorValue != null, "DeltaCompressor is required");
        this.m_compressorValue = compressorValue;
    }

    @Override
    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        Binary binOld = bufOld == null ? null : bufOld.toBinary();
        Binary binNew = bufNew.toBinary();
        if (((Object)bufNew).equals(bufOld)) {
            return null;
        }
        BinaryWriteBuffer bufDelta = null;
        if (DecoratedBinaryDeltaCompressor.isDecorated(binNew)) {
            Binary[] abinDecoOld = DecoratedBinaryDeltaCompressor.getDecorations(binOld);
            Binary[] abinDecoNew = DecoratedBinaryDeltaCompressor.getDecorations(binNew);
            int cDecoOld = abinDecoOld.length;
            int cDecoNew = abinDecoNew.length;
            OutputStreaming outDelta = null;
            try {
                int c = Math.max(cDecoOld, cDecoNew);
                for (int i = 1; i < c; ++i) {
                    Binary binDecoNew;
                    Binary binDecoOld = i < cDecoOld ? abinDecoOld[i] : null;
                    Binary binary = binDecoNew = i < cDecoNew ? abinDecoNew[i] : null;
                    if (Base.equals(binDecoOld, binDecoNew)) continue;
                    if (bufDelta == null) {
                        bufDelta = new BinaryWriteBuffer(64);
                        outDelta = bufDelta.getAppendingBufferOutput();
                    }
                    if (binDecoOld == null) {
                        outDelta.write(-5);
                        outDelta.writePackedInt(i);
                        outDelta.writePackedInt(binDecoNew.length());
                        outDelta.writeBuffer(binDecoNew);
                        continue;
                    }
                    if (binDecoNew == null) {
                        outDelta.write(-7);
                        outDelta.writePackedInt(i);
                        continue;
                    }
                    outDelta.write(-6);
                    outDelta.writePackedInt(i);
                    ReadBuffer bufDecoDelta = s_compressorBinary.extractDelta(binDecoOld, binDecoNew);
                    Base.azzert(bufDecoDelta != null);
                    outDelta.writePackedInt(bufDecoDelta.length());
                    outDelta.writeBuffer(bufDecoDelta);
                }
                if (outDelta != null) {
                    outDelta.write(-8);
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            binOld = abinDecoOld[0];
            binNew = abinDecoNew[0];
        } else if (DecoratedBinaryDeltaCompressor.isDecorated(binOld)) {
            bufDelta = new BinaryWriteBuffer(64);
            bufDelta.write(0, (byte)-4);
            binOld = DecoratedBinaryDeltaCompressor.getUndecorated(binOld);
        }
        ReadBuffer bufValueDelta = this.m_compressorValue.extractDelta(binOld, binNew);
        if (bufValueDelta == null) {
            if (bufDelta != null) {
                bufDelta.write(bufDelta.length(), (byte)-3);
            }
        } else if (bufDelta == null) {
            boolean fAmbiguous = true;
            if (bufValueDelta.length() >= 1) {
                switch (bufValueDelta.byteAt(0)) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        break;
                    }
                    default: {
                        fAmbiguous = false;
                    }
                }
            }
            if (fAmbiguous) {
                bufDelta = new BinaryWriteBuffer(1 + bufValueDelta.length());
                bufDelta.write(0, (byte)-3);
                bufDelta.write(1, bufValueDelta);
            }
        } else {
            boolean fAmbiguous = true;
            if (bufValueDelta.length() >= 1) {
                switch (bufValueDelta.byteAt(0)) {
                    case -4: 
                    case -3: {
                        break;
                    }
                    default: {
                        fAmbiguous = false;
                    }
                }
            }
            if (fAmbiguous) {
                bufDelta.write(bufDelta.length(), (byte)-4);
            }
            bufDelta.write(bufDelta.length(), bufValueDelta);
        }
        return bufDelta == null ? (bufValueDelta == null ? null : bufValueDelta.toBinary()) : bufDelta.toBinary();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
        Binary[] abinDeco;
        Binary binOld;
        block21: {
            byte b;
            ReadBuffer.BufferInput inDelta;
            binOld = bufOld.toBinary();
            if (bufDelta == null) {
                return binOld;
            }
            abinDeco = EMPTY_BINARY_ARRAY;
            switch (bufDelta.byteAt(0)) {
                case -3: {
                    abinDeco = DecoratedBinaryDeltaCompressor.getDecorations(binOld);
                    bufDelta = bufDelta.getReadBuffer(1, bufDelta.length() - 1);
                    break block21;
                }
                case -4: {
                    bufDelta = DecoratedBinaryDeltaCompressor.parseValueDelta(bufDelta, 1);
                    break block21;
                }
                case -7: 
                case -6: 
                case -5: {
                    abinDeco = DecoratedBinaryDeltaCompressor.getDecorations(binOld);
                    inDelta = bufDelta.getBufferInput();
                    try {}
                    catch (IOException e) {
                        throw Base.ensureRuntimeException(e);
                    }
                    break;
                }
                default: {
                    abinDeco = DecoratedBinaryDeltaCompressor.getDecorations(binOld);
                    break block21;
                }
            }
            while ((b = inDelta.readByte()) != -8) {
                int iDeco = inDelta.readPackedInt();
                Binary binDeco = null;
                switch (b) {
                    case -5: {
                        if (iDeco >= abinDeco.length) {
                            Binary[] abinNew = new Binary[iDeco + 1];
                            System.arraycopy(abinDeco, 0, abinNew, 0, abinDeco.length);
                            abinDeco = abinNew;
                        }
                        int cbBin = inDelta.readPackedInt();
                        int ofBin = inDelta.getOffset();
                        binDeco = bufDelta.toBinary(ofBin, cbBin);
                        inDelta.setOffset(ofBin + cbBin);
                        break;
                    }
                    case -6: {
                        Binary binDecoOld;
                        int cbDelta = inDelta.readPackedInt();
                        int ofDelta = inDelta.getOffset();
                        try {
                            binDecoOld = abinDeco[iDeco];
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw Base.ensureRuntimeException(e, "update decoration " + iDeco);
                        }
                        ReadBuffer bufDecoDelta = bufDelta.getReadBuffer(ofDelta, cbDelta);
                        inDelta.setOffset(ofDelta + cbDelta);
                        binDeco = s_compressorBinary.applyDelta(binDecoOld, bufDecoDelta).toBinary();
                        break;
                    }
                    case -7: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("byte=" + Base.toHexEscape(b));
                    }
                }
                try {
                    abinDeco[iDeco] = binDeco;
                }
                catch (IndexOutOfBoundsException e) {
                    throw Base.ensureRuntimeException(e, "decoration " + iDeco);
                }
            }
            bufDelta = DecoratedBinaryDeltaCompressor.parseValueDelta(bufDelta, inDelta.getOffset());
        }
        if (abinDeco.length > 0) {
            binOld = abinDeco[0];
            abinDeco[0] = null;
        } else {
            binOld = DecoratedBinaryDeltaCompressor.getUndecorated(binOld);
        }
        Binary binNew = bufDelta == null ? binOld : this.m_compressorValue.applyDelta(binOld, bufDelta).toBinary();
        return DecoratedBinaryDeltaCompressor.decorate(binNew, abinDeco);
    }

    private static ReadBuffer parseValueDelta(ReadBuffer bufDelta, int of) {
        int cb = bufDelta.length();
        if (cb <= of) {
            return NO_BINARY;
        }
        switch (bufDelta.byteAt(of)) {
            case -3: {
                return null;
            }
            case -4: {
                return bufDelta.getReadBuffer(of + 1, cb - of - 1);
            }
        }
        return bufDelta.getReadBuffer(of, cb - of);
    }

    public String toString() {
        return "DecoratedBinaryDeltaCompressor {" + this.m_compressorValue + "}";
    }
}

