/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;

public class DecorationOnlyDeltaCompressor
extends ExternalizableHelper
implements DeltaCompressor {
    protected static Binary BIN_DECO_ONLY = new Binary(new byte[]{-1});

    @Override
    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        if (bufOld == null) {
            return bufNew;
        }
        Binary binNew = bufNew.toBinary();
        Binary binOld = bufOld.toBinary();
        if (Base.equals(binOld, binNew)) {
            return null;
        }
        boolean fDecoNew = DecorationOnlyDeltaCompressor.isDecorated(binNew);
        boolean fDecoOld = DecorationOnlyDeltaCompressor.isDecorated(binOld);
        if ((fDecoNew || fDecoOld) && Base.equals(DecorationOnlyDeltaCompressor.getUndecorated(binNew), DecorationOnlyDeltaCompressor.getUndecorated(binOld))) {
            Binary binDecoOnly = BIN_DECO_ONLY;
            if (fDecoNew) {
                Binary[] abinDeco = DecorationOnlyDeltaCompressor.getDecorations(binNew);
                abinDeco[0] = null;
                bufNew = DecorationOnlyDeltaCompressor.decorate(binDecoOnly, abinDeco);
            } else {
                bufNew = binDecoOnly;
            }
        }
        return bufNew;
    }

    @Override
    public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
        if (bufDelta == null) {
            return bufOld;
        }
        Binary binDelta = bufDelta.toBinary();
        if (BIN_DECO_ONLY.equals(DecorationOnlyDeltaCompressor.getUndecorated(binDelta))) {
            Binary[] abinDeco = DecorationOnlyDeltaCompressor.getDecorations(binDelta);
            abinDeco[0] = null;
            Binary binOld = DecorationOnlyDeltaCompressor.getUndecorated(bufOld.toBinary());
            return abinDeco.length == 1 ? binOld : DecorationOnlyDeltaCompressor.decorate(binOld, abinDeco);
        }
        return bufDelta;
    }
}

