/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.util.Base;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentingWriter
extends PrintWriter {
    private char[] m_achIndent;
    private boolean m_fNewline = true;
    private boolean m_fSuspended = false;
    private char[] m_achBuf;
    private static final int MAX_BUF = 1024;

    public IndentingWriter(Writer writer, int cSpaces) {
        this(writer, Base.dup(' ', cSpaces));
    }

    public IndentingWriter(Writer writer, String sIndent) {
        super(writer, true);
        Base.azzert(sIndent.indexOf(10) < 0);
        Class<IndentingWriter> clz = IndentingWriter.class;
        if (this.getClass() == clz && writer.getClass() == clz) {
            IndentingWriter that = (IndentingWriter)writer;
            sIndent = new StringBuffer().append(that.m_achIndent).append(sIndent).toString();
            this.out = that.out;
        }
        this.m_achIndent = sIndent.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (c == 10) {
                this.m_fNewline = true;
            } else if (this.m_fNewline) {
                this.m_fNewline = false;
                if (!this.m_fSuspended) {
                    super.write(this.m_achIndent);
                }
            }
            super.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.write(str.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            char[] ach;
            if (len <= 1024) {
                ach = this.m_achBuf;
                if (ach == null) {
                    this.m_achBuf = ach = new char[1024];
                }
            } else {
                ach = new char[len];
            }
            str.getChars(off, off + len, ach, 0);
            this.write(ach, 0, len);
        }
    }

    @Override
    public void println() {
        super.println();
        this.m_fNewline = true;
    }

    public void suspend() {
        this.m_fSuspended = true;
    }

    public void resume() {
        this.m_fSuspended = false;
    }
}

