/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.Disposable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class MultiplexingWriteBufferPool
implements MultiBufferWriteBuffer.WriteBufferPool,
Disposable {
    private static final int GEN_ID_SHIFT = 6;
    private static final int GEN_ID_BITS = 4;
    private static final int GEN_ID_MASK = 960;
    private static final int GEN_ID_UNPOOLED = 15;
    private static final short DEFAULT_GROWTH_FACTOR = 2;
    public static final int DEFAULT_BUF_SIZE = 1024;
    private static final int DEFAULT_STATS_FREQUENCY = 4095;
    private static final int DEFAULT_SEGMENT_COUNT = 4;
    private static final int DEFAULT_SEGMENT_SIZE = 0xC00000;
    private static final long CLEANUP_FREQUENCY_MILLIS = Base.parseTime(System.getProperty("tangosol.coherence.bufferpool.frequency", "5m"));
    private final PoolSegment[] m_aSegments;
    private final int m_cbMin;
    private final int m_cbMax;
    private final int m_nSegmentGrowthFactor;

    public MultiplexingWriteBufferPool() {
        this(4, 0xC00000, 1024, 2);
    }

    public MultiplexingWriteBufferPool(int cSegments, int cbSegment, int cbBufferMin, int nGrowthFactor) {
        cbBufferMin = MultiplexingWriteBufferPool.getBaseBufferSize(cbBufferMin);
        this.m_nSegmentGrowthFactor = nGrowthFactor;
        int cbBuff = this.m_cbMin = cbBufferMin;
        this.m_aSegments = new PoolSegment[cSegments];
        PoolSegment[] aSegment = this.m_aSegments;
        for (int i = 0; i < cSegments; ++i) {
            aSegment[i] = new PoolSegment(cbBuff, cbSegment / cbBuff, 4095);
            cbBuff <<= nGrowthFactor;
        }
        this.m_cbMax = cbBuff >> nGrowthFactor;
    }

    @Override
    public int getMaximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public WriteBuffer allocate(int cbPreviousTotal) {
        return this.ensureSegment(cbPreviousTotal).acquire();
    }

    @Override
    public void release(WriteBuffer buffer) {
        this.getSegment(buffer.getCapacity()).release(buffer);
    }

    @Override
    public void dispose() {
        for (PoolSegment pool : this.m_aSegments) {
            pool.dispose();
        }
    }

    private int decodeSize(int cb) {
        return cb & 0xFFFFFC3F;
    }

    private PoolSegment ensureSegment(int cb) {
        if (cb >= this.m_cbMax) {
            return this.m_aSegments[this.m_aSegments.length - 1];
        }
        int iSeg = 0;
        int cbMin = this.m_cbMin;
        while (cb > cbMin) {
            cb >>= this.m_nSegmentGrowthFactor;
            ++iSeg;
        }
        return this.m_aSegments[iSeg];
    }

    private PoolSegment getSegment(int cb) throws IllegalArgumentException {
        int iSeg;
        PoolSegment[] aSegments = this.m_aSegments;
        int cbDecoded = cb = this.decodeSize(cb);
        int cSeg = aSegments.length;
        int cbMin = this.m_cbMin;
        for (iSeg = 0; cb > cbMin && iSeg < cSeg; cb >>= this.m_nSegmentGrowthFactor, ++iSeg) {
        }
        if (iSeg < cSeg && cbDecoded == aSegments[iSeg].getBufferSize()) {
            return aSegments[iSeg];
        }
        throw new IllegalArgumentException("No pool segment for size: " + cbDecoded + " in " + cSeg + " segment(s) between " + aSegments[0].getBufferSize() + " .. " + aSegments[cSeg - 1].getBufferSize());
    }

    public static int getMaximumSegmentBufferSize(int iSeg, int cbMin, int nGrowthFactor) {
        int cb = MultiplexingWriteBufferPool.getBaseBufferSize(cbMin);
        while (iSeg-- > 0) {
            cb <<= nGrowthFactor;
        }
        return MultiplexingWriteBufferPool.encodeGeneration(cb, 15);
    }

    public static int getBaseBufferSize(int cbBufferMin) {
        if ((cbBufferMin & 0x3FF) != 0) {
            cbBufferMin = cbBufferMin / 1024 * 1024 + (cbBufferMin % 1024 == 0 ? 0 : 1024);
        }
        return cbBufferMin;
    }

    protected static int encodeGeneration(int cb, int nGenId) {
        return cb | nGenId << 6;
    }

    private final class PoolSegment
    implements Disposable {
        private static final int GEN_ID_LOCKED = -1;
        private static final int LOG_SEVERITY_LVL = 7;
        private final int m_cbBuffer;
        private final int m_cBufferGen;
        private final ConcurrentLinkedQueue<WriteBuffer> m_queue;
        private final AtomicInteger m_cGeneration;
        private volatile long m_ldtNextEvaluation;
        private final AtomicLong m_cAcquired;
        private final AtomicLong m_cReleased;
        private final int m_cbNonPooled;
        private final int m_cStatsFreq;
        private int m_cMaxBuffers;

        private PoolSegment(int cbBuffer, int cBuffers, int cReevalFreq) {
            this.m_cbBuffer = cbBuffer;
            this.m_cBufferGen = Math.max(cBuffers / 15, 1);
            this.m_cStatsFreq = cReevalFreq;
            this.m_queue = new ConcurrentLinkedQueue();
            this.m_cGeneration = new AtomicInteger(0);
            this.m_cReleased = new AtomicLong(0L);
            this.m_cAcquired = new AtomicLong(0L);
            this.m_cbNonPooled = MultiplexingWriteBufferPool.encodeGeneration(cbBuffer, 15);
            this.allocateGeneration(0);
        }

        public WriteBuffer acquire() {
            this.m_cAcquired.incrementAndGet();
            WriteBuffer buffer = this.m_queue.poll();
            return buffer == null ? this.ensureBuffer() : buffer;
        }

        public void release(WriteBuffer buffer) {
            int nGeneration = this.decodeGeneration(buffer.getCapacity());
            if ((this.m_cReleased.incrementAndGet() & (long)this.m_cStatsFreq) == 0L) {
                this.recordUsage();
                this.evaluateCapacity(true);
            }
            int cCurrentGen = this.getGenerationId();
            if (nGeneration != 15 && (nGeneration <= cCurrentGen || cCurrentGen == -1)) {
                buffer.clear();
                this.m_queue.offer(buffer);
            }
        }

        @Override
        public void dispose() {
            this.trim(0);
        }

        public int getBufferSize() {
            return this.m_cbBuffer;
        }

        public int getGenerationSize() {
            return this.m_cBufferGen;
        }

        private int getGenerationId() {
            return this.m_cGeneration.get();
        }

        private int getAcquired() {
            return Math.max(0, (int)(this.m_cAcquired.get() - this.m_cReleased.get()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WriteBuffer ensureBuffer() {
            AtomicInteger atomicGen = this.m_cGeneration;
            ConcurrentLinkedQueue<WriteBuffer> queue = this.m_queue;
            block7: while (true) {
                int cGen = atomicGen.get();
                WriteBuffer buffer = queue.poll();
                if (buffer != null) {
                    return buffer;
                }
                switch (cGen) {
                    case 15: {
                        return this.allocateNonPooledBuffer();
                    }
                    case -1: {
                        continue block7;
                    }
                }
                if (!atomicGen.compareAndSet(cGen, -1)) continue;
                try {
                    this.allocateGeneration(cGen + 1);
                    continue;
                }
                finally {
                    atomicGen.set(cGen + 1);
                    continue;
                }
                break;
            }
        }

        private WriteBuffer allocateNonPooledBuffer() {
            return new ByteArrayWriteBuffer(this.m_cbNonPooled);
        }

        private void allocateGeneration(int nGeneration) {
            block4: {
                ConcurrentLinkedQueue<WriteBuffer> queue = this.m_queue;
                int cbBuffer = MultiplexingWriteBufferPool.encodeGeneration(this.getBufferSize(), nGeneration);
                if (nGeneration > 0) {
                    CacheFactory.log("Growing MultiplexingWriteBufferPool segment '" + this.getBufferSize() + "' to " + (nGeneration + 1) + " generations", 7);
                }
                this.m_ldtNextEvaluation = Base.getSafeTimeMillis() + CLEANUP_FREQUENCY_MILLIS;
                try {
                    int c = this.getGenerationSize();
                    for (int i = 0; i < c; ++i) {
                        queue.offer(new ByteArrayWriteBuffer(cbBuffer));
                    }
                }
                catch (OutOfMemoryError e) {
                    if (!queue.isEmpty()) break block4;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateCapacity(boolean fEvalPeers) {
            long ldtNow = Base.getSafeTimeMillis();
            int nGen = this.getGenerationId();
            if (nGen > 0 && ldtNow > this.m_ldtNextEvaluation && this.m_cGeneration.compareAndSet(nGen, -1)) {
                this.m_ldtNextEvaluation = ldtNow + CLEANUP_FREQUENCY_MILLIS;
                int nDesiredGen = Math.min(this.m_cMaxBuffers / this.getGenerationSize() + 1, 14);
                try {
                    int cCapacity = Math.min(nGen + 1, 15);
                    if (nDesiredGen < cCapacity && nDesiredGen != nGen) {
                        CacheFactory.log("Shrinking MultiplexingWriteBufferPool segment '" + this.getBufferSize() + "' by " + (nGen - nDesiredGen) + " generation(s)", 7);
                        if (nDesiredGen + 1 > nGen) {
                            this.trim(nDesiredGen);
                        }
                    }
                    if (fEvalPeers) {
                        for (PoolSegment pool : MultiplexingWriteBufferPool.this.m_aSegments) {
                            if (pool == this) continue;
                            pool.evaluateCapacity(false);
                        }
                    }
                }
                finally {
                    this.m_cMaxBuffers = 0;
                    this.m_cGeneration.set(nDesiredGen);
                }
            }
        }

        private void recordUsage() {
            this.m_cMaxBuffers = Math.max(this.m_cMaxBuffers, this.getAcquired());
        }

        private void trim(int nGeneration) {
            int cbCutoff = MultiplexingWriteBufferPool.encodeGeneration(this.getBufferSize(), nGeneration + 1);
            try {
                Iterator<WriteBuffer> iter = this.m_queue.iterator();
                while (iter.hasNext()) {
                    WriteBuffer buf = iter.next();
                    if (buf == null || buf.getCapacity() < cbCutoff) continue;
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }

        private int decodeGeneration(int cbBuffer) {
            return (cbBuffer & 0x3C0) >> 6;
        }
    }
}

