/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.WrapperOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class PackedDataOutputStream
extends WrapperOutputStream
implements DataOutput {
    static final int MAX_BUF = 32;
    private byte[] m_abBuf = new byte[32];

    public PackedDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeBoolean(boolean f) throws IOException {
        this.getOutputStream().write(f ? 1 : 0);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.getOutputStream().write(b);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.writeInt((short)n);
    }

    @Override
    public void writeChar(int ch) throws IOException {
        OutputStream out = this.getOutputStream();
        if (ch >= 1 && ch <= 127) {
            out.write(ch);
        } else if (ch <= 2047) {
            byte[] ab = this.m_abBuf;
            ab[0] = (byte)(0xC0 | ch >>> 6 & 0x1F);
            ab[1] = (byte)(0x80 | ch & 0x3F);
            out.write(ab, 0, 2);
        } else {
            byte[] ab = this.m_abBuf;
            ab[0] = (byte)(0xE0 | ch >>> 12 & 0xF);
            ab[1] = (byte)(0x80 | ch >>> 6 & 0x3F);
            ab[2] = (byte)(0x80 | ch & 0x3F);
            out.write(ab, 0, 3);
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        byte[] ab = this.m_abBuf;
        int cb = 0;
        int b = 0;
        if (n < 0) {
            b = 64;
            n ^= 0xFFFFFFFF;
        }
        b |= (byte)(n & 0x3F);
        n >>>= 6;
        while (n != 0) {
            ab[cb++] = (byte)(b |= 0x80);
            b = n & 0x7F;
            n >>>= 7;
        }
        if (cb == 0) {
            this.getOutputStream().write(b);
        } else {
            ab[cb++] = (byte)b;
            this.getOutputStream().write(ab, 0, cb);
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        byte[] ab = this.m_abBuf;
        int cb = 0;
        int b = 0;
        if (l < 0L) {
            b = 64;
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        b |= (byte)((int)l & 0x3F);
        l >>>= 6;
        while (l != 0L) {
            ab[cb++] = (byte)(b |= 0x80);
            b = (int)l & 0x7F;
            l >>>= 7;
        }
        if (cb == 0) {
            this.getOutputStream().write(b);
        } else {
            ab[cb++] = (byte)b;
            this.getOutputStream().write(ab, 0, cb);
        }
    }

    @Override
    public void writeFloat(float fl) throws IOException {
        byte[] ab = this.m_abBuf;
        int n = Float.floatToIntBits(fl);
        ab[0] = (byte)(n >>> 24);
        ab[1] = (byte)(n >>> 16);
        ab[2] = (byte)(n >>> 8);
        ab[3] = (byte)n;
        this.getOutputStream().write(ab, 0, 4);
    }

    @Override
    public void writeDouble(double dfl) throws IOException {
        byte[] ab = this.m_abBuf;
        long l = Double.doubleToLongBits(dfl);
        int n = (int)(l >>> 32);
        ab[0] = (byte)(n >>> 24);
        ab[1] = (byte)(n >>> 16);
        ab[2] = (byte)(n >>> 8);
        ab[3] = (byte)n;
        n = (int)l;
        ab[4] = (byte)(n >>> 24);
        ab[5] = (byte)(n >>> 16);
        ab[6] = (byte)(n >>> 8);
        ab[7] = (byte)n;
        this.getOutputStream().write(ab, 0, 8);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int cb = s.length();
        byte[] ab = new byte[cb];
        s.getBytes(0, cb, ab, 0);
        this.write(ab);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        for (int of = 0; of < cch; ++of) {
            this.writeChar(ach[of]);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        this.writeInt(cch);
        if (cch > 0) {
            int cb = cch;
            for (int of = 0; of < cch; ++of) {
                char ch = ach[of];
                if (ch <= '\u007f') {
                    if (ch != '\u0000') continue;
                    ++cb;
                    continue;
                }
                cb += ch <= '\u07ff' ? 1 : 2;
            }
            this.writeInt(cb);
            byte[] ab = cb <= 32 ? this.m_abBuf : new byte[cb];
            int ofb = 0;
            for (int of = 0; of < cch; ++of) {
                char ch = ach[of];
                if (ch >= '\u0001' && ch <= '\u007f') {
                    ab[ofb++] = (byte)ch;
                    continue;
                }
                if (ch <= '\u07ff') {
                    ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                    ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                    continue;
                }
                ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                ab[ofb++] = (byte)(0x80 | ch & 0x3F);
            }
            this.getOutputStream().write(ab, 0, cb);
        }
    }
}

