/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.journal.Journal;
import com.tangosol.io.journal.JournalBinaryStore;
import com.tangosol.io.journal.JournalMBean;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.management.AnnotatedStandardMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Controllable;
import com.tangosol.util.Daemon;
import com.tangosol.util.Disposable;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.MapSet;
import com.tangosol.util.NullFilter;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.WrapperException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;

public abstract class AbstractJournalRM
implements Controllable,
XmlConfigurable,
Disposable,
BinaryStoreManager,
JournalMBean {
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_CONFIGURED = 1;
    protected static final int STATE_RUNNING = 2;
    protected static final int STATE_STOPPING = 3;
    protected static final int STATE_STOPPED = 4;
    protected static final int SHIFT_COMPACT_FLAG = 63;
    protected static final long MASK_COMPACT_FLAG = Long.MIN_VALUE;
    protected static final int SHIFT_COMPACT_LENGTH = 56;
    protected static final long MASK_COMPACT_LENGTH = 0x700000000000000L;
    public static final double MIN_COLLECT_PCT = 0.01;
    public static final double MAX_COLLECT_PCT = 0.99;
    protected int m_nState = 0;
    protected XmlElement m_xmlConfig;
    protected ClassLoader m_loader;
    protected long m_cbMaxFile = this.getDefaultMaxFileSize();
    protected int m_cbMaxValue = this.getDefaultMaxValueSize();
    protected double m_dflLoadFactorGC = this.getDefaultCollectorLoadFactor();
    protected double m_dflHighestLoadFactor;
    protected final Set<JournalImpl> m_setJournals = new MapSet(new ConcurrentHashMap());
    protected final JournalFile[] m_ajournalfile = new JournalFile[512];
    protected volatile int m_cJournalFiles;
    protected volatile JournalFile m_jrnlfile;
    protected CollectorDaemon m_daemonCollector;
    private final Cluster m_cluster;

    protected AbstractJournalRM(Cluster cluster) {
        this.m_cluster = cluster;
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        if (this.getState() != 0) {
            throw new IllegalStateException("AbstractJournalRM has already been configured");
        }
        XmlElement xmlConfig = (XmlElement)xml.clone();
        HashSet<String> setNames = new HashSet<String>();
        for (XmlElement xmlSetting : xmlConfig.getElementList()) {
            String sName = xmlSetting.getName();
            if (setNames.contains(sName)) {
                CacheFactory.log("Journal Resource Manager: Multiple values provided for the \"" + sName + "\" setting;" + " only the first value was used.", 2);
                continue;
            }
            this.applyConfig(sName, xmlSetting);
            setNames.add(sName);
        }
        this.m_xmlConfig = xmlConfig;
        this.setState(1);
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this.registerMBean();
        this.startThreads();
        this.setState(2);
    }

    @Override
    public synchronized boolean isRunning() {
        return this.m_nState == 2;
    }

    @Override
    public synchronized void shutdown() {
        if (this.getState() < 4) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        int nState = this.getState();
        if (nState < 4) {
            JournalFile[] ajrnlfile;
            String sImpl = this.getClass().getSimpleName();
            CacheFactory.log("Journal Resource Manager: Stopping " + sImpl + " (State=" + AbstractJournalRM.getStateDescription(nState) + ")", 6);
            try {
                this.setState(3);
                Iterator<Disposable> iter = this.iterateJournals();
                while (iter.hasNext()) {
                    iter.next().dispose();
                }
                this.stopThreads();
                iter = this.iterateJournalFiles();
                while (iter.hasNext()) {
                    ((JournalFile)iter.next()).dispose();
                }
                this.unregisterMBean();
                this.setState(4);
                this.m_loader = null;
                this.m_daemonCollector = null;
                this.m_jrnlfile = null;
                ajrnlfile = this.m_ajournalfile;
            }
            catch (Throwable throwable) {
                this.setState(4);
                this.m_loader = null;
                this.m_daemonCollector = null;
                this.m_jrnlfile = null;
                JournalFile[] ajrnlfile2 = this.m_ajournalfile;
                int c = ajrnlfile2.length;
                for (int i = 0; i < c; ++i) {
                    ajrnlfile2[i] = null;
                }
                this.m_cJournalFiles = 0;
                this.m_setJournals.clear();
                CacheFactory.log("Journal Resource Manager: Stopped " + sImpl, 6);
                throw throwable;
            }
            int c = ajrnlfile.length;
            for (int i = 0; i < c; ++i) {
                ajrnlfile[i] = null;
            }
            this.m_cJournalFiles = 0;
            this.m_setJournals.clear();
            CacheFactory.log("Journal Resource Manager: Stopped " + sImpl, 6);
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.m_loader;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    @Override
    public XmlElement getConfig() {
        XmlElement xmlConfig = this.m_xmlConfig;
        return xmlConfig == null ? null : (XmlElement)xmlConfig.clone();
    }

    @Override
    public void setConfig(XmlElement xml) {
        this.configure(xml);
    }

    @Override
    public void dispose() {
        try {
            this.shutdown();
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void close() {
        this.dispose();
    }

    @Override
    public int getMaxJournalFilesNumber() {
        return this.getMaxJournalFiles();
    }

    @Override
    public int getBinaryStoreCount() {
        return this.m_setJournals.size();
    }

    @Override
    public int getMaxValueSize() {
        return this.m_cbMaxValue;
    }

    @Override
    public int getFileCount() {
        return this.m_cJournalFiles;
    }

    @Override
    public long getTotalDataSize() {
        long cb = 0L;
        Iterator<JournalFile> iter = this.iterateJournalFiles();
        while (iter.hasNext()) {
            JournalFile jrnlfile = iter.next();
            cb += jrnlfile.getOffset() - jrnlfile.getReleased();
        }
        return cb;
    }

    @Override
    public long getTotalFileSize() {
        long cb = 0L;
        Iterator<JournalFile> iter = this.iterateJournalFiles();
        while (iter.hasNext()) {
            JournalFile jrnlfile = iter.next();
            cb += jrnlfile.getOffset();
        }
        return cb;
    }

    @Override
    public long getMaxFileSize() {
        return this.m_cbMaxFile;
    }

    @Override
    public double getCollectorLoadFactor() {
        return this.m_dflLoadFactorGC;
    }

    @Override
    public double getHighestLoadFactor() {
        return this.m_dflHighestLoadFactor;
    }

    @Override
    public JournalBinaryStore createBinaryStore() {
        JournalImpl journal = this.instantiateJournal();
        JournalBinaryStore store = new JournalBinaryStore(journal);
        journal.setConsumer(store);
        this.registerJournal(journal);
        return store;
    }

    @Override
    public void destroyBinaryStore(BinaryStore store) {
        if (store == null) {
            throw new IllegalArgumentException("BinaryStore required");
        }
        if (!(store instanceof JournalBinaryStore)) {
            throw new IllegalArgumentException("Invalid BinaryStore");
        }
        ((JournalBinaryStore)store).dispose();
    }

    public Journal createJournal(Journal.JournalConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("JournalConsumer required");
        }
        JournalImpl journal = this.instantiateJournal();
        journal.setConsumer(consumer);
        this.registerJournal(journal);
        return journal;
    }

    public String toString() {
        return "JournalRM{" + this.getDescription() + "}";
    }

    public abstract void setMaxValueSize(int var1);

    public abstract void setMaxFileSize(long var1);

    public void setCollectorLoadFactor(double dflFactor) {
        this.checkInitializing();
        if (dflFactor < 0.01 || dflFactor > 0.99) {
            throw new IllegalArgumentException("Illegal load factor of " + dflFactor + "; allowed range is " + 0.01 + " to " + 0.99);
        }
        this.m_dflLoadFactorGC = dflFactor;
    }

    protected synchronized int getState() {
        return this.m_nState;
    }

    protected synchronized void setState(int nState) {
        assert (nState > this.m_nState);
        this.m_nState = nState;
        this.notifyAll();
    }

    protected void checkInitializing() {
        if (this.getState() != 0) {
            throw new IllegalStateException("Operation not allowed once the Resource Manager has been started.");
        }
    }

    protected void applyConfig(String sName, XmlElement xmlConfig) {
        if (sName.equals("minimum-load-factor")) {
            String sFactor = xmlConfig.getString();
            if (sFactor.length() > 0) {
                double dflLoadFactorGC;
                double dflDefault = this.getDefaultCollectorLoadFactor();
                try {
                    Double dFactor = (Double)XmlHelper.convert(sFactor, 4);
                    dflLoadFactorGC = dFactor == null ? dflDefault : dFactor;
                }
                catch (RuntimeException e) {
                    CacheFactory.log("Journal Resource Manager: Unable to parse minimum load factor \"" + sFactor + "\"; using default value", 2);
                    dflLoadFactorGC = dflDefault;
                }
                if (dflLoadFactorGC < 0.01 || dflLoadFactorGC > 0.99) {
                    CacheFactory.log("Journal Resource Manager: Minimum load factor " + sFactor + " is out of range (0.01-0.99); using default value", 2);
                    dflLoadFactorGC = dflDefault;
                }
                this.m_dflLoadFactorGC = dflLoadFactorGC;
            }
        } else {
            CacheFactory.log("Journal Resource Manager: Unsupported option: " + sName);
        }
    }

    protected void startThreads() {
        this.m_daemonCollector = this.instantiateCollectorDaemon();
        this.m_daemonCollector.start();
    }

    protected void stopThreads() {
        try {
            this.m_daemonCollector.shutdown(10000L);
        }
        catch (Throwable t) {
            CacheFactory.log("An exception occured during shutdown of " + this.getClass().getSimpleName() + "; exception was " + t, 2);
        }
    }

    protected static String getStateDescription(int nState) {
        switch (nState) {
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Configured";
            }
            case 2: {
                return "Running";
            }
            case 3: {
                return "Stopping";
            }
            case 4: {
                return "Stopped";
            }
        }
        return "Unknown (" + nState + ")";
    }

    protected String getDescription() {
        return "State=" + AbstractJournalRM.getStateDescription(this.getState()) + ", MaxFileSize=" + this.m_cbMaxFile + ", MaxValueSize=" + this.m_cbMaxValue + ", BinaryStoreCount=" + this.getBinaryStoreCount() + ", FileCount=" + this.getFileCount() + ", TotalDataSize=" + this.getTotalDataSize() + ", TotalFileSize=" + this.getTotalFileSize() + ", Collector=" + this.m_daemonCollector;
    }

    protected int getMaxJournalFiles() {
        return 512;
    }

    protected abstract long getDefaultMaxFileSize();

    protected abstract int getDefaultMaxValueSize();

    protected abstract double getDefaultCollectorLoadFactor();

    protected long getMinCollectorSleepMillis() {
        return 15000L;
    }

    protected long getMaxCollectorSleepMillis() {
        return 300000L;
    }

    protected boolean isDedupEnabled() {
        return true;
    }

    protected boolean isSingleEvacuation() {
        return true;
    }

    protected void registerMBean() {
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            AnnotatedStandardMBean mbean;
            String sName = registry.ensureGlobalName("type=Journal,name=" + this.getClass().getSimpleName());
            try {
                mbean = new AnnotatedStandardMBean(this, JournalMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                throw new WrapperException(e);
            }
            registry.register(sName, mbean);
        }
    }

    protected void unregisterMBean() {
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            String sName = registry.ensureGlobalName("type=Journal,name=" + this.getClass().getSimpleName());
            registry.unregister(sName);
        }
    }

    protected JournalImpl instantiateJournal() {
        return new JournalImpl();
    }

    protected void registerJournal(JournalImpl journal) {
        boolean fAdded = this.m_setJournals.add(journal);
        assert (fAdded);
    }

    protected void unregisterJournal(JournalImpl journal) {
        boolean fRemoved = this.m_setJournals.remove(journal);
        assert (fRemoved);
    }

    protected Iterator<JournalImpl> iterateJournals() {
        return this.m_setJournals.iterator();
    }

    protected JournalFile getJournalFile(int nFileId) {
        return this.m_ajournalfile[nFileId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JournalFile ensureCurrentJournalFile() {
        JournalFile[] ajrnlfile;
        JournalFile jrnlfile = this.m_jrnlfile;
        if (jrnlfile != null && jrnlfile.isAppending()) {
            return jrnlfile;
        }
        int cMaxFiles = this.getMaxJournalFiles();
        if (this.m_cJournalFiles == cMaxFiles && jrnlfile != null && jrnlfile.getNextJournalFile() == null) {
            return null;
        }
        JournalFile[] journalFileArray = ajrnlfile = this.m_ajournalfile;
        synchronized (ajrnlfile) {
            JournalFile jrnlfileNew;
            jrnlfile = this.m_jrnlfile;
            if (jrnlfile != null && jrnlfile.isAppending()) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return jrnlfile;
            }
            int cJournalFiles = this.m_cJournalFiles;
            if (cJournalFiles == cMaxFiles) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return null;
            }
            int nFileId = -1;
            for (int i = 0; i < cMaxFiles; ++i) {
                if (ajrnlfile[i] != null) continue;
                nFileId = i;
                break;
            }
            assert (nFileId >= 0);
            ajrnlfile[nFileId] = jrnlfileNew = this.instantiateJournalFile(nFileId);
            this.m_jrnlfile = jrnlfileNew;
            if (jrnlfile != null) {
                jrnlfile.setNextJournalFile(jrnlfileNew);
            }
            this.m_cJournalFiles = ++cJournalFiles;
            double dflLoadFactor = (double)cJournalFiles / (double)cMaxFiles;
            if (dflLoadFactor > 0.9) {
                ajrnlfile.notifyAll();
            }
            if (dflLoadFactor > this.m_dflHighestLoadFactor) {
                this.m_dflHighestLoadFactor = dflLoadFactor;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return jrnlfileNew;
        }
    }

    protected Iterator<JournalFile> iterateJournalFiles() {
        return new FilterEnumerator(new SimpleEnumerator(this.m_ajournalfile), (Filter)NullFilter.getInstance());
    }

    protected abstract JournalFile instantiateJournalFile(int var1);

    protected CollectorDaemon instantiateCollectorDaemon() {
        return new CollectorDaemon();
    }

    protected CollectorDaemon getCollectorDaemon() {
        return this.m_daemonCollector;
    }

    protected boolean isCompact(long lTicket) {
        return (lTicket & Long.MIN_VALUE) != 0L;
    }

    protected abstract long getEvacuationMask();

    protected abstract int extractFileId(long var1);

    protected abstract long extractOffset(long var1);

    protected abstract int extractLength(long var1);

    protected abstract long encodeTicket(int var1, long var2, int var4);

    protected long encodeTicket(ByteSequence bin) {
        assert (bin != null);
        assert (bin.length() <= 7);
        int cb = bin.length();
        long lTicket = Long.MIN_VALUE | (long)cb << 56;
        for (int of = 0; of < cb; ++of) {
            lTicket |= (long)(bin.byteAt(of) & 0xFF) << (of << 3);
        }
        return lTicket;
    }

    protected Binary extractBinary(long lTicket) {
        assert (this.isCompact(lTicket));
        int cb = (int)((lTicket & 0x700000000000000L) >>> 56);
        byte[] ab = new byte[cb];
        for (int of = 0; of < cb; ++of) {
            ab[of] = (byte)lTicket;
            lTicket >>>= 8;
        }
        return new Binary(ab);
    }

    protected String getTicketDescription(long lTicket) {
        try {
            String sClass;
            if (this.isCompact(lTicket)) {
                return "Format=Compact, Binary=" + this.extractBinary(lTicket);
            }
            String sFormat = sClass = ClassHelper.getSimpleName(this.getClass());
            String sSuffix = "JournalRM";
            if (sClass.endsWith(sSuffix) && sClass.length() > sSuffix.length()) {
                sFormat = sClass.substring(0, sClass.length() - sSuffix.length());
            }
            return "Format=" + sFormat + ", FileId=" + this.extractFileId(lTicket) + ", Offset=" + this.extractOffset(lTicket) + ", Length=" + this.extractLength(lTicket);
        }
        catch (Exception e) {
            return "Format=Corrupt, Bytes=0x" + Base.toHexString((int)lTicket, 8) + Base.toHexString((int)(lTicket >>> 32), 8);
        }
    }

    public Cluster getCluster() {
        return this.m_cluster;
    }

    protected class CollectorDaemon
    extends Daemon {
        private static final int DEDUP_DELAY = 300000;
        private final int[] PRIME_ARRAY;
        private volatile int m_cEvacuations;
        private volatile int m_cMillisEvacuation;
        private volatile int m_cMaxMillisEvacuation;
        private volatile int m_cPrevDedupKeys;
        private volatile long m_ldtPrevDedup;

        public CollectorDaemon() {
            super("Journal-Collector");
            this.PRIME_ARRAY = new int[]{10069, 11087, 12203, 13003, 14051, 15017, 16007, 17027, 18061, 19013, 20063, 23011, 27011, 30011, 35023, 40009, 45007, 50021, 60013, 70001, 80021, 90001, 100003, 120011, 140009, 160001, 180001, 200003, 233021, 266003, 300007, 350003, 400009, 450001, 500009, 550007, 600011, 650011, 700001, 800011, 850009, 900001, 950009, 1000003, 1100009, 1200007, 1300021, 1400017, 1500007, 1600033, 1700021, 1800017, 1900009, 2000003, 2500009, 3000017, 3500017, 4000037, 4500007, 0x4C4B4B, 6000011, 7000003, 8000009, 9000011, 10000019, 0xB71B11, 14000029, 16000057, 18000041, 20000003, 25000009, 30000001, 35000011, 40000003, 45000017, 50000017, 60000011, 70000027};
        }

        @Override
        protected Daemon.DaemonWorker instantiateWorker() {
            return new Daemon.DaemonWorker(){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable e) {
                        CacheFactory.log("An error has occurred managing the journal:", 1);
                        CacheFactory.log(e.toString(), 1);
                        CacheFactory.log("The Journal Resource Manager will stop.", 1);
                        AbstractJournalRM.this.stop();
                    }
                }
            };
        }

        @Override
        public synchronized void stop() {
            super.stop();
            this.getThread().interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            long cWaitMillis = 30000L;
            boolean fSingleEvac = AbstractJournalRM.this.isSingleEvacuation();
            boolean fTriggered = true;
            AbstractJournalRM mgr = AbstractJournalRM.this;
            JournalFile[] ajrnlfile = mgr.m_ajournalfile;
            while (!this.isStopping()) {
                JournalFile jrnlfileEmptiest = null;
                double dflEmptiestLoadFactor = 0.0;
                double dflLoadFactorGC = Math.min(mgr.getCollectorLoadFactor(), Math.max(0.25, (double)AbstractJournalRM.this.m_cJournalFiles / (double)AbstractJournalRM.this.getMaxJournalFiles()));
                int cActionable = 0;
                Iterator<JournalFile> iter = mgr.iterateJournalFiles();
                while (iter.hasNext()) {
                    JournalFile jrnlfile = iter.next();
                    jrnlfile.touch();
                    long lState = jrnlfile.getState();
                    if (lState == 0x2000000000000000L) {
                        double dflLoadFactor;
                        long cbFile = jrnlfile.getOffset();
                        long cbWritten = jrnlfile.getBytesWritten();
                        long cbReleased = jrnlfile.getReleased();
                        assert (cbFile > 0L);
                        if (!$assertionsDisabled) {
                            if (cbReleased < 0L) throw new AssertionError();
                            if (cbReleased > cbFile) {
                                throw new AssertionError();
                            }
                        }
                        if (cbReleased >= cbFile) {
                            jrnlfile.setState(0x4000000000000000L);
                            continue;
                        }
                        if (cbWritten < cbFile) continue;
                        if (!jrnlfile.m_fNotifiedFull) {
                            jrnlfile.m_fNotifiedFull = true;
                            jrnlfile.notifyWriteCompleted();
                        }
                        if (!((dflLoadFactor = (double)(cbFile - cbReleased) / (double)cbFile) < dflLoadFactorGC)) continue;
                        if (jrnlfileEmptiest == null || dflLoadFactor < dflEmptiestLoadFactor) {
                            jrnlfileEmptiest = jrnlfile;
                            dflEmptiestLoadFactor = dflLoadFactor;
                        }
                        if (!fSingleEvac) {
                            this.evacuate(jrnlfile);
                        }
                        ++cActionable;
                        continue;
                    }
                    if (lState == 0x4000000000000000L) {
                        jrnlfile.setState(0x5000000000000000L);
                        jrnlfile.dispose();
                        ++cActionable;
                        continue;
                    }
                    if (lState != 0x5000000000000000L) continue;
                    JournalFile[] journalFileArray = ajrnlfile;
                    // MONITORENTER : ajrnlfile
                    ajrnlfile[jrnlfile.getFileId()] = null;
                    --AbstractJournalRM.this.m_cJournalFiles;
                    // MONITOREXIT : journalFileArray
                    ++cActionable;
                }
                if (jrnlfileEmptiest == null) {
                    if (AbstractJournalRM.this.isDedupEnabled() && Base.getSafeTimeMillis() - this.m_ldtPrevDedup > 300000L) {
                        this.dedupe();
                        ++cActionable;
                    }
                } else if (fSingleEvac) {
                    this.evacuate(jrnlfileEmptiest);
                }
                if (!fTriggered) {
                    cWaitMillis = cActionable == 0 ? Math.min((long)((double)cWaitMillis * 1.125), AbstractJournalRM.this.getMaxCollectorSleepMillis()) : Math.max(cWaitMillis / (long)cActionable, AbstractJournalRM.this.getMinCollectorSleepMillis());
                }
                try {
                    JournalFile[] lState = ajrnlfile;
                    // MONITORENTER : ajrnlfile
                    long ldtBefore = Base.getSafeTimeMillis();
                    ajrnlfile.wait(cWaitMillis);
                    // MONITOREXIT : lState
                    long ldtAfter = Base.getSafeTimeMillis();
                    fTriggered = ldtAfter - ldtBefore < cWaitMillis;
                }
                catch (InterruptedException e) {
                    CacheFactory.log("Journal Resource Manager: CollectorDaemon interrupted; stopping.", 6);
                    return;
                }
            }
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", LoadFactorGC=" + (int)(AbstractJournalRM.this.getCollectorLoadFactor() * 100.0);
        }

        protected void dedupe() {
            int cSlots = (int)((double)this.m_cPrevDedupKeys * 1.5 + CollectorDaemon.getRandom().nextDouble());
            int[] aiPrime = this.PRIME_ARRAY;
            int cPrimes = aiPrime.length;
            int iPrime = -1;
            for (int i = 0; i < cPrimes && (iPrime = aiPrime[i]) < cSlots; ++i) {
            }
            byte[][] aab = new byte[iPrime][];
            Iterator<JournalImpl> iter = AbstractJournalRM.this.iterateJournals();
            while (iter.hasNext()) {
                Journal.JournalConsumer consumer = iter.next().getConsumer();
                if (consumer == null) continue;
                consumer.dedupe(aab);
            }
            int cKeys = 0;
            for (int i = 0; i < iPrime; ++i) {
                if (aab[i] == null) continue;
                ++cKeys;
            }
            this.m_cPrevDedupKeys = cKeys;
            this.m_ldtPrevDedup = Base.getSafeTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void evacuate(JournalFile jrnlfile) {
            long lStart = System.currentTimeMillis();
            jrnlfile.evacuate();
            long lStop = System.currentTimeMillis();
            int cMillis = (int)(lStop - lStart);
            CollectorDaemon collectorDaemon = this;
            synchronized (collectorDaemon) {
                ++this.m_cEvacuations;
                this.m_cMillisEvacuation += cMillis;
                if (cMillis > this.m_cMaxMillisEvacuation) {
                    this.m_cMaxMillisEvacuation = cMillis;
                }
            }
        }

        public synchronized int getAvgEvacuationMillis() {
            int cEvacs = this.m_cEvacuations;
            return cEvacs == 0 ? 0 : this.m_cMillisEvacuation / cEvacs;
        }

        public int getMaxEvacuationMillis() {
            return this.m_cMaxMillisEvacuation;
        }
    }

    protected abstract class JournalFile
    implements Disposable {
        public static final long STATE_APPENDING = 0L;
        public static final long STATE_CONGESTION = 0x1000000000000000L;
        public static final long STATE_FULL = 0x2000000000000000L;
        public static final long STATE_EVACUATING = 0x3000000000000000L;
        public static final long STATE_GARBAGE = 0x4000000000000000L;
        public static final long STATE_DISCARDED = 0x5000000000000000L;
        public static final long STATE_MASK = -1152921504606846976L;
        private final String[] STATE_DESCRIPTIONS = new String[]{"Appending", "Congestion", "Full", "Evacuating", "Garbage", "Discarded"};
        protected final int m_nFile;
        protected final AtomicLong m_lStateOffset = new AtomicLong();
        protected final AtomicLong m_cbWritten = new AtomicLong();
        protected final AtomicLong m_cbReleased = new AtomicLong();
        protected volatile JournalFile m_jrnlfileNext;
        protected boolean m_fNotifiedFull;

        public JournalFile(int nFile) {
            assert (nFile >= 0 && nFile <= 511);
            this.m_nFile = nFile;
        }

        public abstract long enqueue(Binary var1);

        public abstract Binary read(long var1);

        public void release(int cbValue) {
            long lState;
            long cbTotalWritten;
            long cbTotalReleased = this.m_cbReleased.addAndGet(cbValue);
            if (cbTotalReleased >= (cbTotalWritten = this.m_cbWritten.get()) && ((lState = this.getState()) == 0x2000000000000000L || lState == 0x3000000000000000L)) {
                this.setState(0x4000000000000000L);
            }
        }

        public int getFileId() {
            return this.m_nFile;
        }

        public long getState() {
            return this.m_lStateOffset.get() & 0xF000000000000000L;
        }

        protected void setState(long lState) {
            assert ((lState & 0xFFFFFFFFFFFFFFFL) == 0L);
            AtomicLong lStateOffset = this.m_lStateOffset;
            long lPrevValue = lStateOffset.get();
            if ((lPrevValue & 0xF000000000000000L) != lState) {
                while (!lStateOffset.compareAndSet(lPrevValue, lState | lPrevValue & 0xFFFFFFFFFFFFFFFL)) {
                    lPrevValue = lStateOffset.get();
                }
            }
        }

        public long getOffset() {
            return this.m_lStateOffset.get() & 0xFFFFFFFFFFFFFFFL;
        }

        public long getBytesWritten() {
            return this.m_cbWritten.get();
        }

        public long getReleased() {
            return this.m_cbReleased.get();
        }

        public boolean isAppending() {
            return (this.m_lStateOffset.get() & 0xF000000000000000L) <= 0x1000000000000000L;
        }

        public void touch() {
        }

        public JournalFile getNextJournalFile() {
            return this.m_jrnlfileNext;
        }

        public void setNextJournalFile(JournalFile jrnlfileNext) {
            assert (this.getState() >= 0x2000000000000000L);
            this.m_jrnlfileNext = jrnlfileNext;
        }

        protected String getDescription() {
            String sStateDesc = "Unknown";
            try {
                sStateDesc = this.STATE_DESCRIPTIONS[(int)(this.getState() >>> 60)];
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return "FileNumber=" + this.m_nFile + ", State=" + sStateDesc + ", Offset (Length)=" + this.getOffset() + ", BytesWritten=" + this.m_cbWritten.get() + ", BytesReleased=" + this.m_cbReleased.get() + ", hasNext=" + (this.m_jrnlfileNext != null);
        }

        public void notifyWriteCompleted() {
        }

        public void evacuate() {
            this.setState(0x3000000000000000L);
            AbstractJournalRM mgr = AbstractJournalRM.this;
            long lMask = mgr.getEvacuationMask();
            long lTicket = mgr.encodeTicket(this.getFileId(), 0L, 0);
            Iterator<JournalImpl> iter = mgr.iterateJournals();
            while (iter.hasNext()) {
                JournalImpl journal = iter.next();
                try {
                    Journal.JournalConsumer consumer = journal.getConsumer();
                    if (consumer == null) continue;
                    consumer.evacuate(lMask, lTicket);
                }
                catch (RuntimeException e) {
                    Base.err("Journal Resource Manager: Exception while evacuating Journal \"" + journal + "\":");
                    Base.err(e);
                }
            }
        }

        @Override
        public abstract void dispose();

        public String toString() {
            return "JournalFile{" + this.getDescription() + "}";
        }
    }

    protected class JournalImpl
    implements Journal {
        private Journal.JournalConsumer m_consumer;
        private long m_ldtCreated = Base.getSafeTimeMillis();

        protected JournalImpl() {
        }

        @Override
        public long write(Binary bin) {
            JournalFile jrnlfile;
            long lTicket;
            if (bin.length() <= 7) {
                return AbstractJournalRM.this.encodeTicket(bin);
            }
            while ((lTicket = (jrnlfile = AbstractJournalRM.this.ensureCurrentJournalFile()) == null ? this.writeOverflow(bin) : jrnlfile.enqueue(bin)) == 0L) {
            }
            return lTicket;
        }

        @Override
        public Binary read(long lTicket) {
            return AbstractJournalRM.this.isCompact(lTicket) ? AbstractJournalRM.this.extractBinary(lTicket) : AbstractJournalRM.this.getJournalFile(AbstractJournalRM.this.extractFileId(lTicket)).read(lTicket);
        }

        @Override
        public int release(long lTicket) {
            int cb = AbstractJournalRM.this.extractLength(lTicket);
            if (!AbstractJournalRM.this.isCompact(lTicket)) {
                assert (cb > 0);
                int nFileId = AbstractJournalRM.this.extractFileId(lTicket);
                JournalFile jrnlfile = AbstractJournalRM.this.getJournalFile(nFileId);
                if (jrnlfile == null) {
                    throw new IllegalStateException("Journal: JournalFile #" + nFileId + " is missing; Ticket=" + AbstractJournalRM.this.getTicketDescription(lTicket));
                }
                jrnlfile.release(cb);
            }
            return cb;
        }

        @Override
        public void dispose() {
            Journal.JournalConsumer consumer = this.m_consumer;
            if (consumer != null) {
                this.m_consumer = null;
                consumer.dispose();
                AbstractJournalRM.this.unregisterJournal(this);
            }
        }

        protected Journal.JournalConsumer getConsumer() {
            return this.m_consumer;
        }

        protected void setConsumer(Journal.JournalConsumer consumer) {
            if (this.m_consumer != null) {
                throw new IllegalStateException();
            }
            this.m_consumer = consumer;
        }

        public String toString() {
            return "Journal{BinaryStore=" + this.m_consumer.getDescription() + ", Created=" + new Timestamp(this.m_ldtCreated) + "}";
        }

        protected long writeOverflow(Binary bin) {
            throw new IllegalStateException("Journal is completely full!");
        }
    }
}

