/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.reflect.ComplexPofValue;
import com.tangosol.io.pof.reflect.PofValue;
import java.io.IOException;

public class PofArray
extends ComplexPofValue {
    private int m_cElements;

    public PofArray(PofValue valueParent, ReadBuffer bufValue, PofContext ctx, int of, int nType, int ofChildren, int cElements) {
        super(valueParent, bufValue, ctx, of, nType, ofChildren);
        this.m_cElements = cElements;
    }

    public int getLength() {
        return this.m_cElements;
    }

    @Override
    protected PofValue findChildInternal(int nIndex, int ofStart, int iStart) {
        ReadBuffer bufValue = this.getValueBuffer();
        ReadBuffer.BufferInput in = bufValue.getBufferInput();
        in.setOffset(ofStart);
        try {
            if (nIndex < 0 || nIndex >= this.getLength()) {
                throw new IndexOutOfBoundsException("Element index " + nIndex + " must be in the range [0 .. " + this.getLength() + ").");
            }
            for (int iProp = iStart; iProp < nIndex; ++iProp) {
                this.skipChild(in);
            }
            int of = in.getOffset();
            this.skipChild(in);
            int cb = in.getOffset() - of;
            return this.extractChild(bufValue, of, cb);
        }
        catch (IOException e) {
            throw PofArray.ensureRuntimeException(e);
        }
    }
}

