/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.AddressProvider;
import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CompositeAddressProvider
extends AbstractCollection
implements AddressProvider,
Set {
    private final LinkedList m_listProviders = new LinkedList();
    protected AddressIterator m_iterInternal;

    public CompositeAddressProvider() {
    }

    public CompositeAddressProvider(AddressProvider provider) {
        this.addProvider(provider);
    }

    public synchronized void addProvider(AddressProvider provider) {
        this.getProviderList().add(provider);
    }

    public synchronized void addAddress(InetSocketAddress address) {
        SingleProvider providerNew = new SingleProvider(address);
        Iterator iter = this.getProviderList().iterator();
        while (iter.hasNext()) {
            if (!Base.equals(providerNew, iter.next())) continue;
            return;
        }
        this.addProvider(providerNew);
    }

    protected List getProviderList() {
        return this.m_listProviders;
    }

    @Override
    public InetSocketAddress getNextAddress() {
        AddressIterator iter = this.ensureInternalIterator();
        if (iter.hasNext()) {
            return (InetSocketAddress)iter.next();
        }
        return null;
    }

    @Override
    public void accept() {
    }

    @Override
    public void reject(Throwable eCause) {
        this.ensureInternalIterator().remove();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return o instanceof CompositeAddressProvider && ((CompositeAddressProvider)o).m_listProviders.equals(this.m_listProviders);
    }

    @Override
    public synchronized int hashCode() {
        return 37 * HashHelper.hash(this.m_listProviders, 0);
    }

    @Override
    public synchronized Iterator iterator() {
        return new AddressIterator(this.getProviderList());
    }

    @Override
    public int size() {
        int cAddress = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++cAddress;
        }
        return cAddress;
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof AddressProvider) {
            this.addProvider((AddressProvider)o);
        } else if (o instanceof InetSocketAddress) {
            this.addAddress((InetSocketAddress)o);
        } else {
            throw new ClassCastException(o == null ? "null" : o.getClass().getName());
        }
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o instanceof AddressProvider) {
            return this.getProviderList().remove(o);
        }
        if (o instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)o;
            return this.getProviderList().remove(new SingleProvider(address));
        }
        return false;
    }

    protected synchronized AddressIterator ensureInternalIterator() {
        AddressIterator iter = this.m_iterInternal;
        if (iter == null || !iter.hasNext()) {
            this.m_iterInternal = (AddressIterator)this.iterator();
            iter = iter == null ? this.m_iterInternal : iter;
        }
        return iter;
    }

    protected class SingleProvider
    implements AddressProvider {
        protected InetSocketAddress m_address;
        protected boolean m_fExhausted = false;

        protected SingleProvider(InetSocketAddress address) {
            this.m_address = address;
        }

        @Override
        public InetSocketAddress getNextAddress() {
            this.m_fExhausted = !this.m_fExhausted;
            boolean fReturnAddr = this.m_fExhausted;
            return fReturnAddr ? this.m_address : null;
        }

        @Override
        public void accept() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reject(Throwable eCause) {
            List listProvider;
            List list = listProvider = CompositeAddressProvider.this.getProviderList();
            synchronized (list) {
                listProvider.remove(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SingleProvider && ((SingleProvider)o).m_address.equals(this.m_address);
        }

        @Override
        public int hashCode() {
            return this.m_address.hashCode();
        }
    }

    protected static class AddressIterator
    extends AbstractStableIterator {
        protected AddressProvider m_providerCurrent;
        protected Iterator m_iterAddress;
        protected Iterator m_iterProvider;

        protected AddressIterator(List listProvider) {
            this.m_iterProvider = new LinkedList(listProvider).iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void advance() {
            while (this.m_iterAddress == null || !this.m_iterAddress.hasNext()) {
                if (this.m_iterProvider.hasNext()) {
                    AddressProvider provider;
                    this.m_providerCurrent = provider = (AddressProvider)this.m_iterProvider.next();
                    AddressProvider addressProvider = provider;
                    synchronized (addressProvider) {
                        InetSocketAddress address;
                        HashSet<InetSocketAddress> set = new HashSet<InetSocketAddress>();
                        while ((address = provider.getNextAddress()) != null) {
                            set.add(address);
                        }
                        this.m_iterAddress = set.iterator();
                        continue;
                    }
                }
                return;
            }
            this.setNext(this.m_iterAddress.next());
        }

        @Override
        public void remove(Object oPrev) {
            AddressProvider provider = this.getCurrentProvider();
            if (provider instanceof SingleProvider) {
                provider.reject(null);
            }
        }

        protected AddressProvider getCurrentProvider() {
            return this.m_providerCurrent;
        }
    }
}

