/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.AddressProvider;
import com.tangosol.util.Base;
import com.tangosol.util.Daemon;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class RefreshableAddressProvider
extends Base
implements AddressProvider {
    public static final long REFRESH_DEFAULT = 10000L;
    protected volatile List m_listCache;
    protected Iterator m_iterator;
    protected Daemon m_daemonRefresh;

    public RefreshableAddressProvider() {
        this(10000L);
    }

    public RefreshableAddressProvider(long lRefresh) {
        this.instantiateRefreshThread(lRefresh);
    }

    protected void initialize() {
        this.refreshAddressList();
        this.m_daemonRefresh.start();
    }

    protected abstract InetSocketAddress getNextAddressInternal();

    protected abstract boolean isExpired();

    @Override
    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    protected void finalize() {
        this.m_daemonRefresh.stop();
    }

    @Override
    public final InetSocketAddress getNextAddress() {
        Iterator iter = this.ensureIterator();
        if (iter.hasNext()) {
            return (InetSocketAddress)iter.next();
        }
        return null;
    }

    @Override
    public final void accept() {
    }

    @Override
    public final void reject(Throwable eCause) {
        this.ensureIterator().remove();
    }

    protected void refreshAddressList() {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        InetSocketAddress address = this.getNextAddressInternal();
        while (address != null) {
            list.add(address);
            address = this.getNextAddressInternal();
        }
        this.m_listCache = list;
    }

    protected void instantiateRefreshThread(long lRefresh) {
        this.m_daemonRefresh = new RefreshThread(lRefresh);
    }

    protected Iterator ensureIterator() {
        Iterator iter = this.m_iterator;
        if (iter == null || !iter.hasNext()) {
            this.m_iterator = this.m_listCache.iterator();
            if (iter == null) {
                iter = this.m_iterator;
            }
        }
        return iter;
    }

    protected class RefreshThread
    extends Daemon {
        protected final long m_lRefresh;

        protected RefreshThread(long lRefresh) {
            super(RefreshableAddressProvider.this.getClass().getName() + ": RefreshThread");
            this.m_lRefresh = lRefresh;
        }

        @Override
        public void run() {
            long lRefresh = this.m_lRefresh;
            while (!this.isStopping()) {
                try {
                    Thread.sleep(lRefresh);
                    if (!RefreshableAddressProvider.this.isExpired()) continue;
                    RefreshableAddressProvider.this.refreshAddressList();
                    lRefresh = this.m_lRefresh;
                }
                catch (Throwable t) {
                    RefreshThread.err("An exception occured while refreshing an address list: \n" + RefreshThread.getStackTrace(t) + "\nReducing the refresh rate.");
                    lRefresh = 2L * lRefresh;
                }
            }
        }
    }
}

