/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.SocketProvider;
import com.tangosol.net.SystemSocketProvider;
import com.tangosol.net.TcpSocketProvider;
import com.tangosol.net.ssl.SSLSocketProvider;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.SafeHashMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SocketProviderFactory
implements XmlConfigurable {
    protected XmlElement m_xml;
    protected Map m_mapConfig = new SafeHashMap();
    protected Map m_mapProvider = new SafeHashMap();
    public static final SocketProvider DEFAULT_PROVIDER = SystemSocketProvider.INSTANCE;
    public static final String XML_NAME = "socket-providers";
    public static final String XML_PROVIDER_NAME = "socket-provider";

    public SocketProvider createProvider(XmlElement xml) throws IOException {
        SocketProvider provider;
        String sType;
        XmlElement xmlProvider;
        if (xml == null || !xml.getName().equals(XML_PROVIDER_NAME)) {
            throw new IllegalArgumentException("Illegal configuration: " + xml);
        }
        List listProviders = xml.getElementList();
        switch (listProviders.size()) {
            case 0: {
                return DEFAULT_PROVIDER;
            }
            case 1: {
                xmlProvider = (XmlElement)listProviders.get(0);
                sType = xmlProvider.getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("multiple elements specified");
            }
        }
        if (sType.equals("system")) {
            provider = new SystemSocketProvider();
        } else if (sType.equals("tcp")) {
            provider = new TcpSocketProvider();
            ((TcpSocketProvider)provider).setConfig(xmlProvider);
        } else if (sType.equals("ssl")) {
            provider = new SSLSocketProvider();
            ((SSLSocketProvider)provider).setConfig(xmlProvider);
        } else if (sType.equals("instance")) {
            provider = (SocketProvider)XmlHelper.createInstance(xmlProvider, null, null);
        } else {
            throw new IllegalArgumentException("Unknown SocketProvider: " + sType);
        }
        provider.setFactory(this);
        return provider;
    }

    public SocketProvider ensureProvider(XmlElement xml) throws IOException {
        Map mapProvider;
        SocketProvider provider;
        String sRef;
        boolean fRef;
        if (xml == null) {
            return DEFAULT_PROVIDER;
        }
        if (xml.getElementList().isEmpty()) {
            fRef = true;
            sRef = xml.getString();
            if (sRef.length() == 0) {
                return DEFAULT_PROVIDER;
            }
        } else {
            fRef = false;
            sRef = xml.getSafeAttribute("id").getString();
            if (sRef.length() == 0) {
                return this.createProvider(xml);
            }
        }
        if ((provider = (SocketProvider)(mapProvider = this.m_mapProvider).get(sRef)) == null) {
            Map mapConfig = this.m_mapConfig;
            if (mapConfig.containsKey(sRef)) {
                xml = (XmlElement)mapConfig.get(sRef);
            } else if (fRef) {
                throw new IllegalArgumentException("unknown socket-provider configuration: " + sRef);
            }
            provider = this.createProvider(xml);
            if (sRef.length() != 0) {
                mapProvider.put(sRef, provider);
            }
        }
        return provider;
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public void setConfig(XmlElement xml) {
        if (this.m_xml != null) {
            throw new IllegalStateException("Already configured");
        }
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        if (!xml.getName().equals(XML_NAME)) {
            throw new IllegalArgumentException("Invalid configuration: " + xml);
        }
        Map mapConfig = this.m_mapConfig;
        Iterator iter = xml.getElements(XML_PROVIDER_NAME);
        while (iter.hasNext()) {
            XmlElement xmlSub = (XmlElement)iter.next();
            String sId = xmlSub.getSafeAttribute("id").getString();
            if (sId.length() == 0) {
                throw new IllegalArgumentException("id attribute required for: " + xmlSub);
            }
            if (!xmlSub.getName().equals(XML_PROVIDER_NAME)) {
                throw new IllegalArgumentException("unknown element: " + xmlSub);
            }
            mapConfig.put(sId, xmlSub);
        }
    }

    public String toString() {
        return "SocketProviderFactory{Xml=" + this.getConfig() + ", ConfigMap=" + this.m_mapConfig + ", ProviderMap=" + this.m_mapProvider + "}";
    }
}

