/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleMemoryCalculator
extends Base
implements OldCache.UnitCalculator {
    public static final int SIZE_OBJECT_REF;
    public static final int SIZE_OBJECT;
    public static final int SIZE_BOOLEAN;
    public static final int SIZE_BYTE;
    public static final int SIZE_SHORT;
    public static final int SIZE_CHARACTER;
    public static final int SIZE_INTEGER;
    public static final int SIZE_FLOAT;
    public static final int SIZE_LONG;
    public static final int SIZE_DOUBLE;
    public static final int SIZE_DATE;
    public static final int SIZE_TIMESTAMP;
    public static final int SIZE_BIGINTEGER;
    public static final int SIZE_BIGDECIMAL;
    public static final int SIZE_STRING;
    public static final int SIZE_BINARY;
    public static final int SIZE_ENTRY;
    public static final Map MAP_FIXED_SIZES;
    protected static final int SIZE_BASIC_OBJECT;

    @Override
    public int calculateUnits(Object oKey, Object oValue) {
        return oKey == null ? this.sizeOf(oValue) : SIZE_ENTRY + this.sizeOf(oKey) + this.sizeOf(oValue);
    }

    @Override
    public String getName() {
        return ClassHelper.getSimpleName(this.getClass());
    }

    public int sizeOf(Object o) {
        int cb;
        if (o == null) {
            throw new IllegalArgumentException("value is null");
        }
        Class<?> clz = o.getClass();
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes != null) {
            cb = IBytes;
        } else if (clz.equals(String.class)) {
            cb = SIZE_STRING + SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + 2 * ((String)o).length());
        } else if (clz.equals(Binary.class)) {
            cb = SIZE_BINARY + SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + ((Binary)o).length());
        } else if (clz.isArray()) {
            int cElements = Array.getLength(o);
            Class<?> clzElement = clz.getComponentType();
            IBytes = (Integer)MAP_FIXED_SIZES.get(clzElement);
            cb = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + cElements * (IBytes == null ? SIZE_OBJECT_REF : IBytes));
            if (IBytes == null) {
                try {
                    for (int i = 0; i < cElements; ++i) {
                        cb += this.sizeOf(Array.get(o, i));
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {}
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return cb;
    }

    protected int sizeOf(Class clz) {
        Base.azzert(clz != null);
        Integer cb = (Integer)MAP_FIXED_SIZES.get(clz);
        if (cb == null) {
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return cb;
    }

    protected static int padMemorySize(int cb) {
        return (int)SimpleMemoryCalculator.pad(cb, 16L);
    }

    protected static int calculateShallowSize(Class clz) {
        int cb;
        if (clz == null) {
            throw new IllegalArgumentException("class is null");
        }
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes == null) {
            cb = SIZE_BASIC_OBJECT;
            try {
                do {
                    Field[] aField;
                    int cField = (aField = clz.getDeclaredFields()) == null ? 0 : aField.length;
                    for (int i = 0; i < cField; ++i) {
                        Field field = aField[i];
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        IBytes = (Integer)MAP_FIXED_SIZES.get(field.getType());
                        cb += IBytes == null ? SIZE_OBJECT_REF : IBytes;
                    }
                    cb = SimpleMemoryCalculator.padMemorySize(cb);
                } while ((clz = clz.getSuperclass()) != null);
            }
            catch (SecurityException e) {
                throw SimpleMemoryCalculator.ensureRuntimeException(e, "Error calculating the shallow size of: " + clz);
            }
        } else {
            cb = IBytes;
        }
        return cb;
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            String sClass = asArg[0];
            try {
                SimpleMemoryCalculator.log(sClass + "=" + SimpleMemoryCalculator.calculateShallowSize(Class.forName(sClass)));
            }
            catch (Exception e) {
                SimpleMemoryCalculator.log("Could not load class: " + sClass);
            }
        } else {
            SimpleMemoryCalculator calc = new SimpleMemoryCalculator();
            SimpleMemoryCalculator.log("SIZE_OBJECT_REF=" + SIZE_OBJECT_REF);
            SimpleMemoryCalculator.log("SIZE_BASIC_OBJECT=" + SIZE_BASIC_OBJECT);
            SimpleMemoryCalculator.log("SIZE_OBJECT=" + SIZE_OBJECT);
            SimpleMemoryCalculator.log("SIZE_BOOLEAN=" + SIZE_BOOLEAN);
            SimpleMemoryCalculator.log("SIZE_BYTE=" + SIZE_BYTE);
            SimpleMemoryCalculator.log("SIZE_SHORT=" + SIZE_SHORT);
            SimpleMemoryCalculator.log("SIZE_CHARACTER=" + SIZE_CHARACTER);
            SimpleMemoryCalculator.log("SIZE_INTEGER=" + SIZE_INTEGER);
            SimpleMemoryCalculator.log("SIZE_FLOAT=" + SIZE_FLOAT);
            SimpleMemoryCalculator.log("SIZE_LONG=" + SIZE_LONG);
            SimpleMemoryCalculator.log("SIZE_DOUBLE=" + SIZE_DOUBLE);
            SimpleMemoryCalculator.log("SIZE_DATE=" + SIZE_DATE);
            SimpleMemoryCalculator.log("SIZE_TIMESTAMP=" + SIZE_TIMESTAMP);
            SimpleMemoryCalculator.log("SIZE_BIGINTEGER=" + SIZE_BIGINTEGER);
            SimpleMemoryCalculator.log("SIZE_BIGDECIMAL=" + SIZE_BIGDECIMAL);
            SimpleMemoryCalculator.log("SIZE_STRING=" + SIZE_STRING);
            SimpleMemoryCalculator.log("SIZE_BINARY=" + SIZE_BINARY);
            SimpleMemoryCalculator.log("SIZE_ENTRY=" + SIZE_ENTRY);
            SimpleMemoryCalculator.log("sizeof(\"hello world\")=" + calc.sizeOf("hello world"));
            SimpleMemoryCalculator.log("sizeof(0x010203040506070809)=" + calc.sizeOf(new Binary(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9})));
        }
    }

    static {
        String sValue = System.getProperty("sun.arch.data.model");
        int nBits = 32;
        try {
            nBits = Integer.parseInt(sValue);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        SIZE_OBJECT_REF = nBits / 8;
        SIZE_BASIC_OBJECT = SIZE_OBJECT_REF + 4;
        SIZE_OBJECT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT);
        SIZE_BOOLEAN = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 1);
        SIZE_BYTE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 1);
        SIZE_SHORT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 2);
        SIZE_CHARACTER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 2);
        SIZE_INTEGER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        SIZE_FLOAT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        SIZE_LONG = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 8);
        SIZE_DOUBLE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 8);
        SIZE_DATE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + SIZE_OBJECT_REF + 8);
        SIZE_TIMESTAMP = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + SIZE_OBJECT_REF + 12);
        SIZE_BIGINTEGER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 48);
        SIZE_BIGDECIMAL = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + SIZE_OBJECT_REF) + SIZE_BIGINTEGER;
        HashMap<Class<Object>, Integer> map = new HashMap<Class<Object>, Integer>();
        map.put(Boolean.TYPE, SimpleMemoryCalculator.makeInteger(1));
        map.put(Byte.TYPE, SimpleMemoryCalculator.makeInteger(1));
        map.put(Short.TYPE, SimpleMemoryCalculator.makeInteger(2));
        map.put(Character.TYPE, SimpleMemoryCalculator.makeInteger(2));
        map.put(Integer.TYPE, SimpleMemoryCalculator.makeInteger(4));
        map.put(Float.TYPE, SimpleMemoryCalculator.makeInteger(4));
        map.put(Long.TYPE, SimpleMemoryCalculator.makeInteger(8));
        map.put(Double.TYPE, SimpleMemoryCalculator.makeInteger(8));
        map.put(Object.class, SimpleMemoryCalculator.makeInteger(SIZE_OBJECT));
        map.put(Boolean.class, SimpleMemoryCalculator.makeInteger(SIZE_BOOLEAN));
        map.put(Byte.class, SimpleMemoryCalculator.makeInteger(SIZE_BYTE));
        map.put(Short.class, SimpleMemoryCalculator.makeInteger(SIZE_SHORT));
        map.put(Character.class, SimpleMemoryCalculator.makeInteger(SIZE_CHARACTER));
        map.put(Integer.class, SimpleMemoryCalculator.makeInteger(SIZE_INTEGER));
        map.put(Float.class, SimpleMemoryCalculator.makeInteger(SIZE_FLOAT));
        map.put(Long.class, SimpleMemoryCalculator.makeInteger(SIZE_LONG));
        map.put(Double.class, SimpleMemoryCalculator.makeInteger(SIZE_DOUBLE));
        map.put(java.util.Date.class, SimpleMemoryCalculator.makeInteger(SIZE_DATE));
        map.put(Date.class, SimpleMemoryCalculator.makeInteger(SIZE_DATE));
        map.put(Time.class, SimpleMemoryCalculator.makeInteger(SIZE_DATE));
        map.put(Timestamp.class, SimpleMemoryCalculator.makeInteger(SIZE_TIMESTAMP));
        map.put(BigInteger.class, SimpleMemoryCalculator.makeInteger(SIZE_BIGINTEGER));
        map.put(BigDecimal.class, SimpleMemoryCalculator.makeInteger(SIZE_BIGDECIMAL));
        MAP_FIXED_SIZES = Collections.unmodifiableMap(map);
        SIZE_STRING = SimpleMemoryCalculator.calculateShallowSize(String.class);
        SIZE_BINARY = SimpleMemoryCalculator.calculateShallowSize(Binary.class);
        SIZE_ENTRY = SimpleMemoryCalculator.calculateShallowSize(LocalCache.Entry.class);
    }
}

