/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperConcurrentMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WrapperNamedCache
extends WrapperConcurrentMap
implements NamedCache {
    protected String m_sName;
    protected CacheService m_service;

    public WrapperNamedCache(Map map, String sName) {
        this(map, sName, null);
    }

    public WrapperNamedCache(Map map, String sName, CacheService service) {
        super(map, false, -1L);
        this.m_sName = map instanceof NamedCache && sName == null ? ((NamedCache)map).getCacheName() : sName;
        this.m_service = map instanceof NamedCache ? ((NamedCache)map).getCacheService() : service;
    }

    @Override
    public String getCacheName() {
        return this.m_sName;
    }

    @Override
    public CacheService getCacheService() {
        Map map;
        CacheService service = this.m_service;
        if (service == null && (map = this.getMap()) instanceof NamedCache) {
            service = ((NamedCache)map).getCacheService();
        }
        return service;
    }

    @Override
    public boolean isActive() {
        Map map = this.getMap();
        return !(map instanceof NamedCache) || ((NamedCache)map).isActive();
    }

    @Override
    public void release() {
        Map map = this.getMap();
        if (map instanceof NamedCache) {
            ((NamedCache)map).release();
        }
    }

    @Override
    public void destroy() {
        Map map = this.getMap();
        if (map instanceof NamedCache) {
            ((NamedCache)map).destroy();
        }
    }

    @Override
    public Map getAll(Collection colKeys) {
        Map map = this.getMap();
        if (map instanceof CacheMap) {
            long ldtStart = WrapperNamedCache.getSafeTimeMillis();
            Map mapResult = ((CacheMap)map).getAll(colKeys);
            if (this.isCollectStats()) {
                int cMisses;
                int cHits = mapResult.size();
                if (cHits > 0) {
                    this.m_stats.registerHits(cHits, ldtStart);
                }
                if ((cMisses = colKeys.size() - cHits) > 0) {
                    this.m_stats.registerMisses(cMisses, ldtStart);
                }
            }
            return mapResult;
        }
        HashMap mapResult = new HashMap(colKeys.size());
        for (Object oKey : colKeys) {
            Object oVal = this.get(oKey);
            if (oVal == null && !this.containsKey(oKey)) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        Map mapInner = this.getMap();
        if (mapInner instanceof CacheMap) {
            boolean fForceLock = this.isLockingEnforced();
            if (fForceLock) {
                if (!this.lock(oKey, this.getWaitMillis())) throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
            }
            try {
                Object oOrig;
                long ldtStart;
                boolean fStats = this.isCollectStats();
                long l = ldtStart = fStats ? WrapperNamedCache.getSafeTimeMillis() : 0L;
                if (this.isEventFabricator()) {
                    int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
                    oOrig = ((CacheMap)mapInner).put(oKey, oValue, cMillis);
                    this.dispatchEvent(new CacheEvent(this, nEvent, oKey, oOrig, oValue, false));
                } else {
                    oOrig = ((CacheMap)mapInner).put(oKey, oValue, cMillis);
                }
                if (!fStats) return oOrig;
                this.m_stats.registerPut(ldtStart);
                return oOrig;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        } else {
            if (cMillis > 0L) throw new UnsupportedOperationException();
            return super.put(oKey, oValue);
        }
    }

    @Override
    public Set keySet(Filter filter) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).keySet(filter) : InvocableMapHelper.query(map, filter, false, false, null);
    }

    @Override
    public Set entrySet(Filter filter) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).entrySet(filter) : InvocableMapHelper.query(map, filter, true, false, null);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).entrySet(filter, comparator) : InvocableMapHelper.query(map, filter, true, true, comparator);
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        Map map = this.getMap();
        if (map instanceof QueryMap) {
            ((QueryMap)map).addIndex(extractor, fOrdered, comparator);
        }
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        Map map = this.getMap();
        if (map instanceof QueryMap) {
            ((QueryMap)map).removeIndex(extractor);
        }
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invoke(oKey, agent);
        }
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invokeAll(collKeys, agent);
        }
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invokeAll(filter, agent);
        }
        return this.invokeAll(this.keySet(filter), agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).aggregate(collKeys, agent);
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).aggregate(filter, agent);
        }
        return this.aggregate(this.keySet(filter), agent);
    }
}

