/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.SessionLocalBackingMap;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public abstract class SessionLocalHelper {
    public static SessionLocalBackingMap getBackingMap(NamedCache cache) {
        BackingMapContext ctx = cache.getCacheService().getBackingMapManager().getContext().getBackingMapContext(cache.getCacheName());
        return ctx == null ? null : (SessionLocalBackingMap)ctx.getBackingMap();
    }

    public static Object get(NamedCache cache, Object oKey) {
        Binary binKey;
        BackingMapManagerContext ctxMgr = cache.getCacheService().getBackingMapManager().getContext();
        BackingMapContext ctxMap = ctxMgr.getBackingMapContext(cache.getCacheName());
        if (ctxMap != null && ctxMgr.isKeyOwned(binKey = (Binary)ctxMgr.getKeyToInternalConverter().convert(oKey))) {
            SessionLocalBackingMap mapBacking = (SessionLocalBackingMap)ctxMap.getBackingMap();
            try {
                Object oValue = mapBacking.getObject(binKey);
                if (ctxMgr.isKeyOwned(binKey)) {
                    return oValue;
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return cache.get(oKey);
    }

    public static void put(NamedCache cache, Object oKey, Object oValue) {
        Binary binKey;
        BackingMapManagerContext ctxMgr = cache.getCacheService().getBackingMapManager().getContext();
        BackingMapContext ctxMap = ctxMgr.getBackingMapContext(cache.getCacheName());
        if (ctxMap != null && ctxMgr.isKeyOwned(binKey = (Binary)ctxMgr.getKeyToInternalConverter().convert(oKey))) {
            SessionLocalBackingMap mapBacking = (SessionLocalBackingMap)ctxMap.getBackingMap();
            try {
                mapBacking.putObject(binKey, oValue);
                if (ctxMgr.isKeyOwned(binKey)) {
                    return;
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        cache.putAll(Collections.singletonMap(oKey, oValue));
    }

    public static Object getValue(InvocableMap.Entry entry) {
        BinaryEntry entryBin = (BinaryEntry)entry;
        SessionLocalBackingMap mapBacking = (SessionLocalBackingMap)entryBin.getBackingMap();
        return mapBacking.getObject(entryBin.getBinaryKey());
    }

    public static Iterator getLocalKeysIterator(NamedCache cache) {
        SessionLocalBackingMap backingMap = SessionLocalHelper.getBackingMap(cache);
        if (backingMap != null) {
            Set binKeySet = backingMap.keySet();
            Iterator binKeyIterator = binKeySet.iterator();
            ArrayList<Object> origKeys = new ArrayList<Object>(binKeySet.size());
            while (binKeyIterator.hasNext()) {
                Binary binKey = (Binary)binKeyIterator.next();
                Object origKey = backingMap.convertKeyFromInternal(binKey);
                origKeys.add(origKey);
            }
            return origKeys.iterator();
        }
        return null;
    }

    public static boolean existsInBackingMap(NamedCache cache, Object key) {
        SessionLocalBackingMap backingMap = SessionLocalHelper.getBackingMap(cache);
        Binary binKey = backingMap.convertKeyToInternal(key);
        return backingMap.containsKey(binKey);
    }
}

