/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.management.MBeanReference;
import com.tangosol.net.management.MBeanServerFinder;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public abstract class MBeanHelper
extends Base {
    private static final String MANAGEABLE = "com.tangosol.coherence.component.manageable.";

    public static String getDefaultDomain() {
        return CacheFactory.getManagementConfig().getSafeElement("default-domain-name").getString();
    }

    public static MBeanServerFinder getServerFinder() {
        XmlElement xmlFactory = CacheFactory.getManagementConfig().getSafeElement("server-factory");
        return XmlHelper.isInstanceConfigEmpty(xmlFactory) ? null : (MBeanServerFinder)XmlHelper.createInstance(xmlFactory, null, null);
    }

    public static MBeanServer findMBeanServer() {
        return MBeanHelper.findMBeanServer(MBeanHelper.getDefaultDomain());
    }

    public static MBeanServer findMBeanServer(String sDefaultDomain) {
        try {
            MBeanServer server;
            MBeanServerFinder finder = MBeanHelper.getServerFinder();
            if (finder != null && (server = finder.findMBeanServer(sDefaultDomain)) != null) {
                return server;
            }
            for (MBeanServer server2 : MBeanServerFactory.findMBeanServer(null)) {
                if (sDefaultDomain != null && sDefaultDomain.length() != 0 && !server2.getDefaultDomain().equals(sDefaultDomain)) continue;
                return server2;
            }
            try {
                MBeanServer server2;
                Class<?> clzFactory = Class.forName("java.lang.management.ManagementFactory");
                server2 = (MBeanServer)ClassHelper.invokeStatic(clzFactory, "getPlatformMBeanServer", ClassHelper.VOID);
                if (sDefaultDomain == null || sDefaultDomain.length() == 0 || server2.getDefaultDomain().equals(sDefaultDomain)) {
                    return server2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return MBeanServerFactory.createMBeanServer(sDefaultDomain);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to locate the server");
        }
    }

    public static void registerQueryMBeans(String sMBeanServerDomain, String sQuery, String sPrefix, Registry registry) {
        if (sPrefix.length() > 0) {
            sPrefix = sPrefix + ',';
        }
        try {
            ObjectName onameQuery = new ObjectName(sQuery);
            MBeanServer mbs = MBeanHelper.findMBeanServer(sMBeanServerDomain);
            Set<ObjectName> setNames = mbs.queryNames(onameQuery, null);
            for (ObjectName oname : setNames) {
                String sSourceDomain = oname.getDomain();
                String sSourceName = oname.getKeyPropertyListString();
                String sTargetName = sPrefix + "Domain=" + sSourceDomain + ',' + sSourceName.replaceFirst("type=", "subType=");
                registry.register(registry.ensureGlobalName(sTargetName), new MBeanReference(oname, mbs));
            }
        }
        catch (MalformedObjectNameException e) {
            MBeanHelper.err("Ignoring failed registration request: " + e + "; " + MBeanHelper.getStackTrace(e));
        }
    }

    public static void registerCacheMBean(NamedCache cache, String sContext) {
        MBeanHelper.registerCacheMBean(cache.getCacheService(), cache.getCacheName(), sContext, cache);
    }

    public static void registerCacheMBean(CacheService service, String sCacheName, String sContext, Map map) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                String sName = "type=Cache,service=" + service.getInfo().getServiceName() + ",name=" + sCacheName;
                sName = registry.ensureGlobalName(sName);
                sName = sName + "," + sContext;
                registry.register(sName, map);
            }
        }
        catch (Throwable e) {
            CacheFactory.log("Failed to register cache \"" + sCacheName + "\"; " + e, 2);
        }
    }

    public static void unregisterCacheMBean(CacheService service, String sCacheName) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Member member = cluster.getLocalMember();
                String sPattern = "type=Cache,service=" + service.getInfo().getServiceName() + ",name=" + sCacheName + (member == null ? "" : ",nodeId=" + member.getId()) + ",*";
                registry.unregister(sPattern);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unregisterCacheMBean(String sCacheName, String sContext) {
        try {
            Cluster cluster = CacheFactory.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Member member = cluster.getLocalMember();
                String sPattern = "type=Cache,name=" + sCacheName + (member == null ? "" : ",nodeId=" + member.getId()) + "," + sContext + ",*";
                registry.unregister(sPattern);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static double calculateAverage(MBeanServer server, String sPattern, String sAttribute) {
        try {
            double dSum = 0.0;
            int cnt = 0;
            Set<ObjectName> setName = server.queryNames(new ObjectName(sPattern), null);
            for (ObjectName name : setName) {
                dSum += ((Number)server.getAttribute(name, sAttribute)).doubleValue();
                ++cnt;
            }
            return cnt > 1 ? dSum / (double)cnt : dSum;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e);
        }
    }

    public static MBeanReference ensureSingletonMBean(String sName) {
        try {
            MBeanServer server = MBeanHelper.findMBeanServer();
            ObjectName name = new ObjectName("Coherence:type=" + sName);
            if (!server.isRegistered(name)) {
                Object oBean = Class.forName(MANAGEABLE + sName + "MBean").newInstance();
                server.registerMBean(oBean, name);
            }
            return new MBeanReference(name, server);
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static JMXConnectorServer startRmiConnector(String sHost, int nRegPort, int nConPort, MBeanServer mbs, Map mapEnv) {
        try {
            String sAuth = System.getProperty("com.sun.management.jmxremote.authenticate");
            String sAuthFile = System.getProperty("com.sun.management.jmxremote.password.file");
            String sAccessFile = System.getProperty("com.sun.management.jmxremote.access.file");
            String sSSL = System.getProperty("com.sun.management.jmxremote.ssl");
            LocateRegistry.createRegistry(nRegPort);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + sHost + ":" + nConPort + "/jndi/rmi://" + sHost + ":" + nRegPort + "/server");
            if (sAuth == null || sAuth.equalsIgnoreCase("true")) {
                String sJavaHome = System.getProperty("java.home");
                if (sAuthFile == null) {
                    sAuthFile = sJavaHome + "/lib/management/jmxremote.password";
                }
                if (sAccessFile == null) {
                    sAccessFile = sJavaHome + "/lib/management/jmxremote.access";
                }
            }
            if (mapEnv == null) {
                mapEnv = new HashMap<String, String>();
            }
            if (sAuthFile != null && mapEnv.get("jmx.remote.x.password.file") == null) {
                mapEnv.put("jmx.remote.x.password.file", sAuthFile);
            }
            if (sAccessFile != null && mapEnv.get("jmx.remote.x.access.file") == null) {
                mapEnv.put("jmx.remote.x.access.file", sAccessFile);
            }
            if (sSSL == null || sSSL.equalsIgnoreCase("true")) {
                try {
                    if (mapEnv.get("jmx.remote.rmi.client.socket.factory") == null) {
                        mapEnv.put("jmx.remote.rmi.client.socket.factory", (String)Class.forName("javax.rmi.ssl.SslRMIClientSocketFactory").newInstance());
                    }
                    if (mapEnv.get("jmx.remote.rmi.server.socket.factory") == null) {
                        mapEnv.put("jmx.remote.rmi.server.socket.factory", (String)Class.forName("javax.rmi.ssl.SslRMIServerSocketFactory").newInstance());
                    }
                }
                catch (ClassNotFoundException e) {
                    String sMsg = "JMXConnectorServer not started. SSL security requires the Java Dynamic Management Kit or Java 1.5.";
                    throw MBeanHelper.ensureRuntimeException(e, sMsg);
                }
            }
            JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(url, mapEnv, mbs);
            connector.start();
            return connector;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e, "Could not start JMXConnectorServer");
        }
    }

    public static Object startHttpConnector(int nPort, MBeanServer mbs) {
        try {
            String sAdapter = "HttpAdapter:port=" + nPort;
            ObjectName nameAdapter = new ObjectName(sAdapter);
            Object adaptorServer = ClassHelper.newInstance(Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer"), new Object[]{Base.makeInteger(nPort)});
            mbs.registerMBean(adaptorServer, nameAdapter);
            mbs.invoke(nameAdapter, "start", null, null);
            return adaptorServer;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e, "Please ensure that JMX RI (jmxtools.jar, jmxri.jar) is in the classpath");
        }
    }

    public static String quote(String s) {
        String sDelims = "\n\\\"*?";
        StringTokenizer tokens = new StringTokenizer(s, sDelims, true);
        StringBuffer sb = new StringBuffer("\"");
        while (tokens.hasMoreTokens()) {
            String sToken = tokens.nextToken();
            if (sToken.length() == 1 && sDelims.indexOf(sToken) != -1) {
                sb.append('\\');
                if (sToken.equals("\n")) {
                    sb.append('n');
                    continue;
                }
                sb.append(sToken);
                continue;
            }
            sb.append(sToken);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String unquote(String s) {
        String sDelims = "\"\\";
        StringTokenizer tokens = new StringTokenizer(s, sDelims, true);
        StringBuffer sb = new StringBuffer("");
        if (tokens.countTokens() == 1) {
            return s;
        }
        if (tokens.nextToken().equals("\"")) {
            while (tokens.hasMoreTokens()) {
                String sToken = tokens.nextToken();
                if (sDelims.indexOf(sToken) != -1) {
                    if (!tokens.hasMoreTokens()) continue;
                    String sNextToken = tokens.nextToken();
                    if (sNextToken.startsWith("n")) {
                        sb.append('\n');
                        sb.append(sNextToken.substring(1));
                        continue;
                    }
                    sb.append(sNextToken);
                    continue;
                }
                sb.append(sToken);
            }
        } else {
            throw new IllegalArgumentException("Argument not quoted");
        }
        return sb.toString();
    }

    public static boolean isQuoteRequired(String s) {
        return s.indexOf(44) != -1 || s.indexOf(61) != -1 || s.indexOf(58) != -1 || !MBeanHelper.quote(s).equals("\"" + s + "\"");
    }

    public static String quoteCanonical(String sCanonical) throws MalformedObjectNameException {
        int ofDomain = sCanonical.indexOf(58);
        int ofEquals = sCanonical.indexOf(61);
        String sName = sCanonical;
        StringBuffer sbCanonical = new StringBuffer();
        if (ofDomain >= 0 && (ofEquals < 0 || ofDomain < ofEquals)) {
            sName = sCanonical.substring(ofDomain + 1);
            sbCanonical.append(sCanonical.substring(0, ofDomain + 1));
        }
        String[] asPairs = Base.parseDelimitedString(sName, ',');
        int cPairs = asPairs.length;
        for (int i = 0; i < cPairs; ++i) {
            String sKey;
            StringBuffer sbValue = new StringBuffer();
            String sPair = asPairs[i];
            if (asPairs[i].equals("*")) {
                sbCanonical.append(asPairs[i]);
                continue;
            }
            int ofValue = sPair.indexOf(61);
            if (ofValue > -1) {
                String[] asPair = Base.parseDelimitedString(asPairs[i], '=');
                sKey = asPair[0];
                if (MBeanHelper.isQuoteRequired(sKey)) {
                    sKey = MBeanHelper.quote(sKey);
                }
            } else {
                throw new MalformedObjectNameException("ObjectName \"" + sCanonical + "\" is invalid.");
            }
            sbCanonical.append(sKey).append('=');
            sbValue.append(sPair.substring(ofValue + 1));
            String sValue = sbValue.toString();
            if (MBeanHelper.isQuoteRequired(sValue)) {
                sValue = MBeanHelper.quote(sValue);
            }
            sbCanonical.append(sValue);
            if (i + 1 >= cPairs) continue;
            sbCanonical.append(',');
        }
        return sbCanonical.toString();
    }

    public static boolean hasDomain(String sCanonical) {
        if (sCanonical == null) {
            return false;
        }
        int ofDomain = sCanonical.indexOf(58);
        int ofEquals = sCanonical.indexOf(61);
        return ofDomain >= 0 && (ofEquals < 0 || ofDomain < ofEquals);
    }

    public static String stripDomain(String sCanonical) {
        return MBeanHelper.hasDomain(sCanonical) ? sCanonical.substring(sCanonical.indexOf(58) + 1) : sCanonical;
    }

    public static int compareKeyList(ObjectName oname1, ObjectName oname2) {
        Set setKeys2;
        Hashtable<String, String> mapKeyList1 = oname1.getKeyPropertyList();
        Hashtable<String, String> mapKeyList2 = oname2.getKeyPropertyList();
        Set setKeys1 = mapKeyList1.keySet();
        if (((Object)setKeys1).equals(setKeys2 = mapKeyList2.keySet())) {
            for (String sKey : mapKeyList1.keySet()) {
                String sValue1 = (String)mapKeyList1.get(sKey);
                String sValue2 = (String)mapKeyList2.get(sKey);
                if (sKey.equals("nodeId")) {
                    int n2;
                    int n1 = Integer.parseInt(sValue1);
                    if (n1 == (n2 = Integer.parseInt(sValue2))) continue;
                    return n1 - n2;
                }
                int iCompare = sValue1.compareTo(sValue2);
                if (iCompare == 0) continue;
                return iCompare;
            }
            return 0;
        }
        return oname1.getCanonicalName().compareTo(oname2.getCanonicalName());
    }
}

