/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;

public class BlockCipherOutputStream
extends FilterOutputStream {
    protected Cipher m_cipher;
    protected byte[] m_abBlockClear;
    protected int m_nBlockIndex;

    public BlockCipherOutputStream(OutputStream stream, Cipher cipher) {
        this(stream, cipher, cipher.getBlockSize());
    }

    public BlockCipherOutputStream(OutputStream stream, Cipher cipher, int cbBlock) {
        super(stream);
        if (cbBlock <= 0) {
            throw new IllegalArgumentException("block size must be greater than 0");
        }
        this.m_cipher = cipher;
        this.m_abBlockClear = new byte[cbBlock];
    }

    @Override
    public void flush() throws IOException {
        if (this.m_nBlockIndex > 0) {
            this.writeBlock();
        }
        super.flush();
    }

    @Override
    public void write(int bData) throws IOException {
        byte[] abBlockClear = this.m_abBlockClear;
        int nBlockIndex = this.m_nBlockIndex++;
        abBlockClear[nBlockIndex] = (byte)bData;
        if (nBlockIndex == abBlockClear.length - 1) {
            this.writeBlock();
        }
    }

    @Override
    public void write(byte[] abData, int nOffset, int nLength) throws IOException {
        byte[] abBlockClear = this.m_abBlockClear;
        int nBlockIndex = this.m_nBlockIndex;
        while (nLength > 0) {
            int nAvailable = abBlockClear.length - nBlockIndex;
            int nCopy = Math.min(nLength, nAvailable);
            System.arraycopy(abData, nOffset, abBlockClear, nBlockIndex, nCopy);
            this.m_nBlockIndex += nCopy;
            nOffset += nCopy;
            nLength -= nCopy;
            if (nCopy != nAvailable) continue;
            this.writeBlock();
            nBlockIndex = 0;
        }
    }

    protected void writeBlock() throws IOException {
        try {
            this.out.write(this.m_cipher.doFinal(this.m_abBlockClear, 0, this.m_nBlockIndex));
            this.m_nBlockIndex = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Cipher error: " + e);
        }
    }
}

